/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.icon.EmptyIcon;
import org.jdesktop.swingx.plaf.TaskPaneUI;

public class BasicTaskPaneUI
extends TaskPaneUI {
    private static FocusListener focusListener = new RepaintOnFocus();
    protected static int TITLE_HEIGHT = 25;
    protected static int ROUND_HEIGHT = 5;
    protected JXTaskPane group;
    protected boolean mouseOver;
    protected MouseInputListener mouseListener;
    protected PropertyChangeListener propertyListener;

    public static ComponentUI createUI(JComponent c) {
        return new BasicTaskPaneUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.group = (JXTaskPane)c;
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        this.group.setOpaque(true);
        this.group.setBorder(this.createPaneBorder());
        ((JComponent)this.group.getContentPane()).setBorder(this.createContentPaneBorder());
        LookAndFeel.installColorsAndFont(this.group, "TaskPane.background", "TaskPane.foreground", "TaskPane.font");
        LookAndFeel.installColorsAndFont((JComponent)this.group.getContentPane(), "TaskPane.background", "TaskPane.foreground", "TaskPane.font");
    }

    protected void installListeners() {
        this.mouseListener = this.createMouseInputListener();
        this.group.addMouseMotionListener(this.mouseListener);
        this.group.addMouseListener(this.mouseListener);
        this.group.addFocusListener(focusListener);
        this.propertyListener = this.createPropertyListener();
        this.group.addPropertyChangeListener(this.propertyListener);
    }

    protected void installKeyboardActions() {
        ActionMap map;
        InputMap inputMap = (InputMap)UIManager.get("TaskPane.focusInputMap");
        if (inputMap != null) {
            SwingUtilities.replaceUIInputMap(this.group, 0, inputMap);
        }
        if ((map = this.getActionMap()) != null) {
            SwingUtilities.replaceUIActionMap(this.group, map);
        }
    }

    ActionMap getActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("toggleExpanded", new ToggleExpandedAction());
        return map;
    }

    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        super.uninstallUI(c);
    }

    protected void uninstallListeners() {
        this.group.removeMouseListener(this.mouseListener);
        this.group.removeMouseMotionListener(this.mouseListener);
        this.group.removeFocusListener(focusListener);
        this.group.removePropertyChangeListener(this.propertyListener);
    }

    protected MouseInputListener createMouseInputListener() {
        return new ToggleListener();
    }

    protected PropertyChangeListener createPropertyListener() {
        return new ChangeListener();
    }

    protected boolean isInBorder(MouseEvent event) {
        return event.getY() < this.getTitleHeight();
    }

    protected final int getTitleHeight() {
        return TITLE_HEIGHT;
    }

    protected Border createPaneBorder() {
        return new PaneBorder();
    }

    public Dimension getPreferredSize(JComponent c) {
        Component component = this.group.getComponent(0);
        if (!(component instanceof JXCollapsiblePane)) {
            return super.getPreferredSize(c);
        }
        JXCollapsiblePane collapsible = (JXCollapsiblePane)component;
        Dimension dim = collapsible.getPreferredSize();
        Border groupBorder = this.group.getBorder();
        if (groupBorder instanceof PaneBorder) {
            Dimension border = ((PaneBorder)groupBorder).getPreferredSize(this.group);
            dim.width = Math.max(dim.width, border.width);
            dim.height += border.height;
        } else {
            dim.height += this.getTitleHeight();
        }
        return dim;
    }

    protected Border createContentPaneBorder() {
        Color borderColor = UIManager.getColor("TaskPane.borderColor");
        return new CompoundBorder(new ContentPaneBorder(borderColor), BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    public Component createAction(Action action) {
        JXHyperlink button = new JXHyperlink(action);
        button.setOpaque(false);
        button.setBorder(null);
        button.setBorderPainted(false);
        button.setFocusPainted(true);
        button.setForeground(UIManager.getColor("TaskPane.titleForeground"));
        return button;
    }

    protected void ensureVisible() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BasicTaskPaneUI.this.group.scrollRectToVisible(new Rectangle(BasicTaskPaneUI.this.group.getWidth(), BasicTaskPaneUI.this.group.getHeight()));
            }
        });
    }

    protected class PaneBorder
    implements Border {
        protected Color borderColor = UIManager.getColor("TaskPane.borderColor");
        protected Color titleForeground = UIManager.getColor("TaskPane.titleForeground");
        protected Color specialTitleBackground = UIManager.getColor("TaskPane.specialTitleBackground");
        protected Color specialTitleForeground = UIManager.getColor("TaskPane.specialTitleForeground");
        protected Color titleBackgroundGradientStart = UIManager.getColor("TaskPane.titleBackgroundGradientStart");
        protected Color titleBackgroundGradientEnd = UIManager.getColor("TaskPane.titleBackgroundGradientEnd");
        protected Color titleOver = UIManager.getColor("TaskPane.titleOver");
        protected Color specialTitleOver;
        protected JLabel label;

        public PaneBorder() {
            if (this.titleOver == null) {
                this.titleOver = this.specialTitleBackground.brighter();
            }
            this.specialTitleOver = UIManager.getColor("TaskPane.specialTitleOver");
            if (this.specialTitleOver == null) {
                this.specialTitleOver = this.specialTitleBackground.brighter();
            }
            this.label = new JLabel();
            this.label.setOpaque(false);
            this.label.setIconTextGap(8);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(BasicTaskPaneUI.this.getTitleHeight(), 0, 0, 0);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public Dimension getPreferredSize(JXTaskPane group) {
            this.configureLabel(group);
            Dimension dim = this.label.getPreferredSize();
            dim.width += 3;
            dim.width += TITLE_HEIGHT;
            dim.width += 3;
            dim.height = BasicTaskPaneUI.this.getTitleHeight();
            return dim;
        }

        protected void paintTitleBackground(JXTaskPane group, Graphics g) {
            if (group.isSpecial()) {
                g.setColor(this.specialTitleBackground);
            } else {
                g.setColor(this.titleBackgroundGradientStart);
            }
            g.fillRect(0, 0, group.getWidth(), BasicTaskPaneUI.this.getTitleHeight() - 1);
        }

        protected void paintTitle(JXTaskPane group, Graphics g, Color textColor, int x, int y, int width, int height) {
            this.configureLabel(group);
            this.label.setForeground(textColor);
            g.translate(x, y);
            this.label.setBounds(0, 0, width, height);
            this.label.paint(g);
            g.translate(-x, -y);
        }

        protected void configureLabel(JXTaskPane group) {
            this.label.applyComponentOrientation(group.getComponentOrientation());
            this.label.setFont(group.getFont());
            this.label.setText(group.getTitle());
            this.label.setIcon(group.getIcon() == null ? new EmptyIcon() : group.getIcon());
        }

        protected void paintExpandedControls(JXTaskPane group, Graphics g, int x, int y, int width, int height) {
        }

        protected Color getPaintColor(JXTaskPane group) {
            Color paintColor = this.isMouseOverBorder() ? (BasicTaskPaneUI.this.mouseOver ? (group.isSpecial() ? this.specialTitleOver : this.titleOver) : (group.isSpecial() ? this.specialTitleForeground : this.titleForeground)) : (group.isSpecial() ? this.specialTitleForeground : this.titleForeground);
            return paintColor;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            JXTaskPane group = (JXTaskPane)c;
            int controlWidth = TITLE_HEIGHT - 2 * ROUND_HEIGHT;
            int controlX = group.getWidth() - TITLE_HEIGHT;
            int controlY = ROUND_HEIGHT - 1;
            int titleX = 3;
            int titleY = 0;
            int titleWidth = group.getWidth() - BasicTaskPaneUI.this.getTitleHeight() - 3;
            int titleHeight = BasicTaskPaneUI.this.getTitleHeight();
            if (!group.getComponentOrientation().isLeftToRight()) {
                controlX = group.getWidth() - controlX - controlWidth;
                titleX = group.getWidth() - titleX - titleWidth;
            }
            this.paintTitleBackground(group, g);
            this.paintExpandedControls(group, g, controlX, controlY, controlWidth, controlWidth);
            Color paintColor = this.getPaintColor(group);
            if (group.hasFocus()) {
                this.paintFocus(g, paintColor, 3, 3, width - 6, BasicTaskPaneUI.this.getTitleHeight() - 6);
            }
            this.paintTitle(group, g, paintColor, titleX, titleY, titleWidth, titleHeight);
        }

        protected void paintRectAroundControls(JXTaskPane group, Graphics g, int x, int y, int width, int height, Color highColor, Color lowColor) {
            if (BasicTaskPaneUI.this.mouseOver) {
                int x2 = x + width;
                int y2 = y + height;
                g.setColor(highColor);
                g.drawLine(x, y, x2, y);
                g.drawLine(x, y, x, y2);
                g.setColor(lowColor);
                g.drawLine(x2, y, x2, y2);
                g.drawLine(x, y2, x2, y2);
            }
        }

        protected void paintOvalAroundControls(JXTaskPane group, Graphics g, int x, int y, int width, int height) {
            if (group.isSpecial()) {
                g.setColor(this.specialTitleBackground.brighter());
                g.drawOval(x, y, width, height);
            } else {
                g.setColor(this.titleBackgroundGradientStart);
                g.fillOval(x, y, width, height);
                g.setColor(this.titleBackgroundGradientEnd.darker());
                g.drawOval(x, y, width, width);
            }
        }

        protected void paintChevronControls(JXTaskPane group, Graphics g, int x, int y, int width, int height) {
            ChevronIcon chevron = group.isExpanded() ? new ChevronIcon(true) : new ChevronIcon(false);
            int chevronX = x + width / 2 - chevron.getIconWidth() / 2;
            int chevronY = y + (height / 2 - chevron.getIconHeight());
            chevron.paintIcon(group, g, chevronX, chevronY);
            chevron.paintIcon(group, g, chevronX, chevronY + chevron.getIconHeight() + 1);
        }

        protected void paintFocus(Graphics g, Color paintColor, int x, int y, int width, int height) {
            g.setColor(paintColor);
            BasicGraphicsUtils.drawDashedRect(g, x, y, width, height);
        }

        protected boolean isMouseOverBorder() {
            return false;
        }
    }

    protected static class ContentPaneBorder
    implements Border {
        Color color;

        public ContentPaneBorder(Color color) {
            this.color = color;
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(0, 1, 1, 1);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(this.color);
            g.drawLine(x, y, x, y + height - 1);
            g.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
            g.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
        }
    }

    protected static class ChevronIcon
    implements Icon {
        boolean up = true;

        public ChevronIcon(boolean up) {
            this.up = up;
        }

        public int getIconHeight() {
            return 3;
        }

        public int getIconWidth() {
            return 6;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.up) {
                g.drawLine(x + 3, y, x, y + 3);
                g.drawLine(x + 3, y, x + 6, y + 3);
            } else {
                g.drawLine(x, y, x + 3, y + 3);
                g.drawLine(x + 3, y + 3, x + 6, y);
            }
        }
    }

    class ToggleExpandedAction
    extends AbstractAction {
        public ToggleExpandedAction() {
            super("toggleExpanded");
        }

        public void actionPerformed(ActionEvent e) {
            BasicTaskPaneUI.this.group.setExpanded(!BasicTaskPaneUI.this.group.isExpanded());
        }

        public boolean isEnabled() {
            return BasicTaskPaneUI.this.group.isVisible();
        }
    }

    class ToggleListener
    extends MouseInputAdapter {
        ToggleListener() {
        }

        public void mouseEntered(MouseEvent e) {
            if (BasicTaskPaneUI.this.isInBorder(e)) {
                e.getComponent().setCursor(Cursor.getPredefinedCursor(12));
            } else {
                BasicTaskPaneUI.this.mouseOver = false;
                BasicTaskPaneUI.this.group.repaint();
            }
        }

        public void mouseExited(MouseEvent e) {
            e.getComponent().setCursor(Cursor.getDefaultCursor());
            BasicTaskPaneUI.this.mouseOver = false;
            BasicTaskPaneUI.this.group.repaint();
        }

        public void mouseMoved(MouseEvent e) {
            if (BasicTaskPaneUI.this.isInBorder(e)) {
                e.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                BasicTaskPaneUI.this.mouseOver = true;
                BasicTaskPaneUI.this.group.repaint();
            } else {
                e.getComponent().setCursor(Cursor.getDefaultCursor());
                BasicTaskPaneUI.this.mouseOver = false;
                BasicTaskPaneUI.this.group.repaint();
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (BasicTaskPaneUI.this.isInBorder(e)) {
                BasicTaskPaneUI.this.group.setExpanded(!BasicTaskPaneUI.this.group.isExpanded());
            }
        }
    }

    class ChangeListener
    implements PropertyChangeListener {
        ChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("expanded".equals(evt.getPropertyName()) && Boolean.TRUE.equals(evt.getNewValue()) && !BasicTaskPaneUI.this.group.isAnimated() || "animationState".equals(evt.getPropertyName()) && "expanded".equals(evt.getNewValue())) {
                if (BasicTaskPaneUI.this.group.isScrollOnExpand()) {
                    BasicTaskPaneUI.this.ensureVisible();
                }
            } else if ("icon".equals(evt.getPropertyName()) || "title".equals(evt.getPropertyName()) || "special".equals(evt.getPropertyName())) {
                BasicTaskPaneUI.this.group.repaint();
            }
        }
    }

    static class RepaintOnFocus
    implements FocusListener {
        RepaintOnFocus() {
        }

        public void focusGained(FocusEvent e) {
            e.getComponent().repaint();
        }

        public void focusLost(FocusEvent e) {
            e.getComponent().repaint();
        }
    }
}

