/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.dos.dosExtension.requestSender;

import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.support.types.StringToStringsMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RequestObject {
    private String xmlMessage = "";
    private String endpoint;
    private Map<String, String> httpHeaderMap;

    public RequestObject() {
    }

    public RequestObject(String xmlMessage, String endpoint, Map<String, String> httpHeaderMap) {
        this.xmlMessage = xmlMessage;
        this.endpoint = endpoint;
        this.httpHeaderMap = httpHeaderMap;
    }

    public RequestObject(WsdlRequest wsdlRequest) {
        this.xmlMessage = wsdlRequest.getRequestContent();
        this.endpoint = wsdlRequest.getEndpoint();
        this.createHttpHeaderMap(wsdlRequest);
    }

    public void createHttpHeaderMap(WsdlRequest wsdlRequest) {
        this.httpHeaderMap = new HashMap<String, String>();
        StringToStringsMap originalHeaders = wsdlRequest.getRequestHeaders();
        for (Map.Entry entry : originalHeaders.entrySet()) {
            for (String value : (List)entry.getValue()) {
                this.httpHeaderMap.put((String)entry.getKey(), value);
            }
        }
    }

    public String getHeaderString(String linebreak) {
        Iterator<String> iterator = this.httpHeaderMap.keySet().iterator();
        StringBuilder sb = new StringBuilder("");
        while (iterator.hasNext()) {
            String key = iterator.next();
            String value = this.httpHeaderMap.get(key);
            sb.append(key).append(" ").append(value).append(linebreak);
        }
        return sb.toString();
    }

    public String getXmlMessage() {
        return this.xmlMessage;
    }

    public void setXmlMessage(String xmlMessage) {
        this.xmlMessage = xmlMessage;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public Map<String, String> getHttpHeaderMap() {
        return this.httpHeaderMap;
    }

    public void setHttpHeaderMap(Map<String, String> httpHeaderMap) {
        this.httpHeaderMap = httpHeaderMap;
    }

    public int getXmlMessageLength() {
        return this.xmlMessage.length();
    }
}

