/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.dos.dosExtension.mvc.model;

import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.submit.transports.http.WsdlResponse;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.commons.math3.stat.descriptive.rank.Median;
import wsattacker.main.plugin.PluginOptionContainer;
import wsattacker.main.plugin.result.Result;
import wsattacker.main.plugin.result.ResultEntry;
import wsattacker.main.plugin.result.ResultLevel;
import wsattacker.plugin.dos.dosExtension.abstractPlugin.AbstractDosPlugin;
import wsattacker.plugin.dos.dosExtension.attackThreads.PerformAttackThread;
import wsattacker.plugin.dos.dosExtension.clock.Clock;
import wsattacker.plugin.dos.dosExtension.clock.TickerThread;
import wsattacker.plugin.dos.dosExtension.logEntry.LogEntryInterval;
import wsattacker.plugin.dos.dosExtension.logEntry.LogEntryRequest;
import wsattacker.plugin.dos.dosExtension.mvc.model.AttackModelSubject;
import wsattacker.plugin.dos.dosExtension.mvc.view.AttackListener;
import wsattacker.plugin.dos.dosExtension.requestSender.RequestObject;

public class AttackModel
implements AttackModelSubject {
    private static final int MAX_POINTS = 100;
    int min;
    int max;
    private int numberRequestsPerThread = 0;
    private int numberThreads = 0;
    private int millisecondsServerLoadRecovery;
    private int millisecondsBetweenProbes;
    private int millisecondsBetweenRequests;
    private int intervalLengthReport = 1000;
    private String attackName;
    private String attackDescription;
    private String attackCountermeasures;
    private String wsdlUrl;
    private String ip;
    private String payload;
    private Clock clock;
    private TickerThread ticker;
    private String attackTime = "0";
    private Thread performAttackThread;
    private Thread sendProbeRequestsThread;
    private WsdlRequest wsdlRequestOriginal;
    private WsdlResponse wsdlResponseOriginal;
    private RequestObject tamperedRequestObject;
    private RequestObject untamperedRequestObject;
    private Map<String, String> originalRequestHeaderFields;
    private ArrayList<AttackListener> listeners;
    private final String[] stateArray = new String[]{"Attack initialized<br />", "Performing network stability test<br />", "Attack running <br />sending untampered requests", "Attack running <br />allowing server to recover", "Attack running <br />sending tampered requests", "Attack running <br />ready to finalize", "Attack finished<br />", "Attack aborted by user<br />", "Generating results - please wait...<br />", "Attack done<br />sending test probes for defined number of seconds"};
    private String currentAttackState = "";
    private boolean attackFinished = false;
    private boolean attackAborted = false;
    private boolean autoFinalizeSwitch = false;
    private int autoFinalizeMilliSeconds = 60;
    private boolean networkTestEnabled = false;
    private boolean networkTestFinished = false;
    private int networkTestNumberRequests = 100;
    private int networkTestRequestIntervalInMilliseconds = 333;
    private double networkTestResult = 0.0;
    private String networkTestResultString = "";
    private int counterThreadsUntampered = 0;
    private int counterThreadsTampered = 0;
    private int counterRequestsSendTampered = 0;
    private int counterRequestsSendUntampered = 0;
    private int counterRequestsSendNetworkTest = 0;
    private int counterProbesSend = 0;
    private int requestSizeUntampered;
    private int requestSizeTampered;
    private int requestSizeTestProbe;
    private int requestSizePaddedUntampered;
    private int requestSizePaddedTampered;
    private long tsAttackStart;
    private long tsAttackStop;
    private long tsUntamperedStart;
    private long tsTamperedStart;
    private long tsTamperedLastSend;
    private List<LogEntryRequest> logList;
    private List<LogEntryRequest> logListUntamperedRequests;
    private List<LogEntryRequest> logListTamperedRequests;
    private List<LogEntryRequest> logListTestProbeRequests;
    private List<LogEntryRequest> logListNetworktestRequests;
    private double medianUntampered;
    private double medianTampered;
    private Map<Integer, LogEntryInterval> mapLogEntryIntervalUntampered;
    private Map<Integer, LogEntryInterval> mapLogEntryIntervalTampered;
    private Map<Integer, LogEntryInterval> mapLogEntryIntervalTestProbe;
    private String wsAttackerResults = "Attack finished";
    private final int sampleCountAttackEffectivness = 10;
    private final int payloadSuccessThreshold = 3;
    private PluginOptionContainer pluginOptions;

    public AttackModel() {
    }

    public AttackModel(AbstractDosPlugin plugin) {
        this.pluginOptions = plugin.getPluginOptions();
        this.numberRequestsPerThread = plugin.getOptionNumberRequests().getValue();
        this.numberThreads = plugin.getOptionNumberThreads().getValue();
        this.millisecondsServerLoadRecovery = plugin.getOptionSecondsServerLoadRecovery().getValue() * 1000;
        this.millisecondsBetweenProbes = plugin.getOptionSecondsBetweenProbes().getValue();
        this.millisecondsBetweenRequests = plugin.getOptionSecondsBetweenRequests().getValue();
        this.autoFinalizeSwitch = plugin.getOptionAutoFinalizeSwitch().isOn();
        this.autoFinalizeMilliSeconds = plugin.getOptionAutoFinalizeSeconds().getValue() * 1000;
        this.networkTestEnabled = plugin.getOptionNetworkTestEnabled().isOn();
        this.networkTestNumberRequests = plugin.getOptionNetworkTestNumberRequests().getValue();
        this.networkTestRequestIntervalInMilliseconds = plugin.getOptionNetworkTestRequestInterval().getValue();
        this.ip = "0.0.0.0";
        this.wsdlUrl = plugin.getOriginalRequestResponsePair().getWsdlRequest().getEndpoint();
        this.attackName = plugin.getName();
        this.attackDescription = plugin.getDescription();
        this.attackCountermeasures = plugin.getCountermeasures();
        this.wsdlRequestOriginal = plugin.getOriginalRequestResponsePair().getWsdlRequest();
        this.wsdlResponseOriginal = plugin.getOriginalRequestResponsePair().getWsdlResponse();
        this.originalRequestHeaderFields = plugin.getOriginalRequestHeaderFields();
        this.tamperedRequestObject = plugin.getTamperedRequestObject();
        this.untamperedRequestObject = plugin.getUntamperedRequestObject();
        this.requestSizeUntampered = this.untamperedRequestObject.getXmlMessageLength();
        this.requestSizeTampered = this.tamperedRequestObject.getXmlMessageLength();
        this.requestSizePaddedUntampered = this.untamperedRequestObject.getXmlMessageLength();
        this.requestSizePaddedTampered = this.tamperedRequestObject.getXmlMessageLength();
        this.requestSizeTestProbe = (int)this.wsdlRequestOriginal.getContentLength();
        this.listeners = new ArrayList();
        this.logList = new ArrayList<LogEntryRequest>();
        this.logListUntamperedRequests = new ArrayList<LogEntryRequest>();
        this.logListTamperedRequests = new ArrayList<LogEntryRequest>();
        this.logListTestProbeRequests = new ArrayList<LogEntryRequest>();
        this.logListNetworktestRequests = new ArrayList<LogEntryRequest>();
        this.currentAttackState = this.stateArray[0];
    }

    @Override
    public void addAttackListener(AttackListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeAttackListener(AttackListener l) {
        this.listeners.remove(l);
    }

    private void fireModelChanged() {
        for (AttackListener l : this.listeners) {
            l.valueChanged(this);
        }
    }

    public List<LogEntryRequest> getLogList() {
        return this.logList;
    }

    public List<LogEntryRequest> getLogListUntamperedRequests() {
        return this.logListUntamperedRequests;
    }

    public List<LogEntryRequest> getLogListTamperedRequests() {
        return this.logListTamperedRequests;
    }

    public List<LogEntryRequest> getLogListTestProbeRequests() {
        return this.logListTestProbeRequests;
    }

    public int getProgress() {
        float current;
        float total;
        if (this.isNetworkTestEnabled()) {
            total = 2 * this.numberRequestsPerThread * this.numberThreads + this.networkTestNumberRequests;
            current = this.counterRequestsSendTampered + this.counterRequestsSendUntampered + this.counterRequestsSendNetworkTest;
        } else {
            total = 2 * this.numberRequestsPerThread * this.numberThreads;
            current = this.counterRequestsSendTampered + this.counterRequestsSendUntampered;
        }
        float result = current / total * 100.0f;
        return (int)result;
    }

    public synchronized void logResponseTime(String type, long tsSend, long tsReceived, long duration, int threadNumber, boolean faultFlag, boolean errorflag, String responseString) {
        if (!this.attackAborted && !this.attackFinished) {
            LogEntryRequest logEntry = new LogEntryRequest(type, tsSend, tsReceived, duration, threadNumber, faultFlag, errorflag, responseString);
            this.logList.add(logEntry);
            if (type.equals("untampered")) {
                this.logListUntamperedRequests.add(logEntry);
            } else if (type.equals("tampered")) {
                this.logListTamperedRequests.add(logEntry);
            } else if (type.equals("testProbe")) {
                this.logListTestProbeRequests.add(logEntry);
            } else if (type.equals("networkTest")) {
                this.logListNetworktestRequests.add(logEntry);
            } else {
                return;
            }
        }
    }

    public void generateResults() {
        Result.getGlobalResult().add(new ResultEntry(ResultLevel.Trace, "attackModel", "Generate Results - start"));
        int secondsTotal = (int)((this.tsAttackStop - this.tsAttackStart) / 1000L);
        boolean currentMillisecond = false;
        boolean matchingInterval = false;
        this.mapLogEntryIntervalUntampered = new HashMap<Integer, LogEntryInterval>();
        this.mapLogEntryIntervalTampered = new HashMap<Integer, LogEntryInterval>();
        this.mapLogEntryIntervalTestProbe = new HashMap<Integer, LogEntryInterval>();
        for (LogEntryRequest currentLogEntryUntampered : this.logListUntamperedRequests) {
            this.writeLogEntryRequestToLogEntryInterval(this.mapLogEntryIntervalUntampered, currentLogEntryUntampered);
        }
        for (LogEntryRequest currentLogEntryTampered : this.logListTamperedRequests) {
            this.writeLogEntryRequestToLogEntryInterval(this.mapLogEntryIntervalTampered, currentLogEntryTampered);
        }
        for (LogEntryRequest currentLogEntryTestProbe : this.logListTestProbeRequests) {
            this.writeLogEntryRequestToLogEntryInterval(this.mapLogEntryIntervalTestProbe, currentLogEntryTestProbe);
        }
        Result.getGlobalResult().add(new ResultEntry(ResultLevel.Trace, "attackModel", "Generate Results - end"));
    }

    public void writeLogEntryRequestToLogEntryInterval(Map<Integer, LogEntryInterval> mapLogEntryInterval, LogEntryRequest currentLogEntryRequest) {
        LogEntryInterval currentLogEntryInterval;
        int currentMillisecond = (int)(currentLogEntryRequest.getTsSend() - this.tsAttackStart);
        long currentDuration = currentLogEntryRequest.getDuration() / 1000000L;
        int matchingInterval = currentMillisecond - currentMillisecond % this.intervalLengthReport;
        if (mapLogEntryInterval.get(matchingInterval) == null) {
            currentLogEntryInterval = new LogEntryInterval();
            currentLogEntryInterval.setIntervalNumber(matchingInterval);
            mapLogEntryInterval.put(currentLogEntryInterval.getIntervalNumber(), currentLogEntryInterval);
        } else {
            currentLogEntryInterval = mapLogEntryInterval.get(matchingInterval);
        }
        if (currentLogEntryInterval.getMeanResponseTime() > 0.0f) {
            currentLogEntryInterval.setMeanResponseTime((currentLogEntryInterval.getMeanResponseTime() + (float)currentDuration) / 2.0f);
        } else {
            currentLogEntryInterval.setMeanResponseTime(currentDuration);
        }
        currentLogEntryInterval.incNumberRequests();
    }

    public double getAttackRoundtripTimeRatio() {
        try {
            Median median = new Median();
            int sampleCountMax = this.logListUntamperedRequests.size() < 10 ? this.logListUntamperedRequests.size() : 10;
            this.medianUntampered = 0.0;
            double[] medianUntamperedArray = new double[sampleCountMax];
            for (int i = 1; i <= sampleCountMax; ++i) {
                medianUntamperedArray[i - 1] = this.logListUntamperedRequests.get(this.logListUntamperedRequests.size() - i).getDuration();
            }
            this.medianUntampered = median.evaluate(medianUntamperedArray);
            this.medianTampered = 0.0;
            double[] medianTamperedArray = new double[sampleCountMax];
            for (int i = 1; i <= sampleCountMax; ++i) {
                medianTamperedArray[i - 1] = this.logListTamperedRequests.get(this.logListTamperedRequests.size() - i).getDuration();
            }
            this.medianTampered = median.evaluate(medianTamperedArray);
            double timeDelta = (float)this.medianTampered / (float)this.medianUntampered;
            double result = timeDelta;
            if (result >= 0.0) {
                return (double)Math.round(result * 100.0) / 100.0;
            }
            return 0.0;
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public String getAttackRoundtripTimeRatioDescription(String type) {
        String text = "";
        String image = "";
        if (this.getAttackRoundtripTimeRatio() < 3.0) {
            text = "payload ineffective";
            image = "/IMG/statusGreen.png";
        } else if (this.getAttackRoundtripTimeRatio() < 6.0) {
            text = "payload effective";
            image = "/IMG/statusOrange.png";
        } else if (this.getAttackRoundtripTimeRatio() >= 6.0) {
            text = "payload higly effective";
            image = "/IMG/statusRed.png";
        }
        if (type.equals("image")) {
            return image;
        }
        return text;
    }

    public double getAttackRatioRequestsize() {
        try {
            double sizeDelta;
            double result = sizeDelta = (double)((float)this.requestSizeTestProbe / (float)this.requestSizeTampered);
            if (result >= 0.0) {
                return (double)Math.round(result * 100.0) / 100.0;
            }
            return 0.0;
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public String getAttackRatioRequestsizeDescription(String type) {
        String text = "";
        String image = "";
        if (this.getAttackRatioRequestsize() <= 0.5) {
            text = "inefficient attack";
            image = "/IMG/statusGreen.png";
        } else if (this.getAttackRatioRequestsize() > 0.5 && this.getAttackRatioRequestsize() <= 2.0) {
            text = "neutral result";
            image = "/IMG/statusGrey.png";
        } else if (this.getAttackRatioRequestsize() > 2.0 && this.getAttackRatioRequestsize() <= 5.0) {
            text = "efficient attack";
            image = "/IMG/statusRed.png";
        } else if (this.getAttackRatioRequestsize() > 5.0) {
            text = "highly efficient attack";
            image = "/IMG/statusRed.png";
        }
        if (type.equals("image")) {
            return image;
        }
        return text;
    }

    public double getTestProbeAttackRoundtripTime() {
        if (this.getAttackRoundtripTimeRatio() > 3.0 && this.logListTestProbeRequests.size() > 0) {
            Median median = new Median();
            int sampleCountMaxTestProbes = 0;
            for (int i = 0; i < this.logListTestProbeRequests.size(); ++i) {
                if (this.logListTestProbeRequests.get(i).getTsSend() <= this.tsTamperedLastSend) continue;
                ++sampleCountMaxTestProbes;
            }
            double[] medianTestProbesArray = new double[sampleCountMaxTestProbes];
            int k = 0;
            for (int i = 0; i < this.logListTestProbeRequests.size(); ++i) {
                if (this.logListTestProbeRequests.get(i).getTsSend() <= this.tsTamperedLastSend) continue;
                medianTestProbesArray[k] = this.logListTestProbeRequests.get(i).getDuration();
                ++k;
            }
            double medianTestProbes = median.evaluate(medianTestProbesArray);
            double result = medianTestProbes / 1.0E9;
            return (double)Math.round(result * 1000.0) / 1000.0;
        }
        return 0.0;
    }

    public double getAttackLongevitySeconds() {
        double result = (this.tsAttackStop - this.tsTamperedLastSend) / 1000L;
        return (double)Math.round(result * 100.0) / 100.0;
    }

    public String getTestProbeAttackRoundtripTimeDescription(String type) {
        String text = "";
        String image = "";
        if (this.getAttackRoundtripTimeRatio() > 3.0) {
            if (this.getTestProbeAttackRoundtripTime() < 2.0) {
                text = "no or small effect on third party users";
                image = "/IMG/statusGreen.png";
            } else if (this.getTestProbeAttackRoundtripTime() < 5.0) {
                text = "third party users are affected";
                image = "/IMG/statusOrange.png";
            } else if (this.getTestProbeAttackRoundtripTime() >= 5.0) {
                text = "third party users are heavily affected";
                image = "/IMG/statusRed.png";
            } else {
                text = "no attack effect";
                image = "/IMG/statusGreen.png";
            }
        } else {
            text = "no attack effect";
            image = "/IMG/statusGreen.png";
        }
        if (type.equals("image")) {
            return image;
        }
        return text;
    }

    public String getCustomAttackParameters() {
        StringBuilder sb = new StringBuilder();
        for (int i = 7; i < this.pluginOptions.size(); ++i) {
            sb.append(this.pluginOptions.getByIndex(i).getName());
            sb.append(": ");
            sb.append(this.pluginOptions.getByIndex(i).getValueAsString());
            sb.append(" - ");
            sb.append(this.pluginOptions.getByIndex(i).getDescription());
            sb.append("\n");
        }
        return sb.toString();
    }

    public void startAttack() {
        this.setClock(new Clock());
        this.ticker = new TickerThread(this);
        this.tsAttackStart = System.currentTimeMillis();
        this.performAttackThread = new PerformAttackThread(this);
        this.performAttackThread.start();
        Result.getGlobalResult().add(new ResultEntry(ResultLevel.Trace, "attackModel", "done starting attack: " + this.attackName));
        this.fireModelChanged();
    }

    public void finalizeAttack() {
        this.tsAttackStop = System.currentTimeMillis();
        if (this.ticker != null) {
            this.ticker.interrupt();
        }
        if (this.sendProbeRequestsThread != null) {
            this.sendProbeRequestsThread.interrupt();
        }
        this.currentAttackState = this.getStateArray()[8];
        this.generateResults();
        this.attackFinished = true;
        this.fireModelChanged();
    }

    public void finalizeAttackAuto() {
        this.finalizeAttack();
        this.attackAborted = true;
        this.attackFinished = true;
        Result.getGlobalResult().add(new ResultEntry(ResultLevel.Info, "Attack Model EDT", "Auto Finalization finished, attack closed"));
    }

    public void abortAttack() {
        this.currentAttackState = this.getStateArray()[7];
        if (this.ticker != null) {
            this.ticker.interrupt();
        }
        if (this.sendProbeRequestsThread != null) {
            this.sendProbeRequestsThread.interrupt();
        }
        if (this.performAttackThread != null) {
            this.performAttackThread.interrupt();
        }
        this.attackAborted = true;
        this.fireModelChanged();
    }

    public void closeAttackUnfinished() {
        this.abortAttack();
        this.attackFinished = true;
        this.setWsAttackerResults("Attack aborted by user");
        this.fireModelChanged();
    }

    public void incNumberRequests(String type) {
        if (!this.attackAborted && !this.attackFinished) {
            if (type.equals("tampered")) {
                ++this.counterRequestsSendTampered;
            } else if (type.equals("untampered")) {
                ++this.counterRequestsSendUntampered;
            } else {
                System.out.println("No number incremented");
            }
        } else {
            return;
        }
        this.fireModelChanged();
    }

    public void incNumberThreads(String type) {
        if (type.equals("tampered")) {
            ++this.counterThreadsTampered;
        } else {
            ++this.counterThreadsUntampered;
        }
        this.fireModelChanged();
    }

    public void incNumberProbes() {
        ++this.counterProbesSend;
        this.fireModelChanged();
    }

    public void incNumberNetworktestProbes() {
        ++this.counterRequestsSendNetworkTest;
        this.fireModelChanged();
    }

    public void setCurrentAttackState(int currentAttackState) {
        this.currentAttackState = this.stateArray[currentAttackState];
        Result.getGlobalResult().add(new ResultEntry(ResultLevel.Trace, "attackModel", "Updated state of Attack to: " + this.currentAttackState));
        this.fireModelChanged();
    }

    public void updateClock(String currentTime) {
        this.attackTime = currentTime;
        this.fireModelChanged();
    }

    public void generateNetworktestResult() {
        SummaryStatistics statistics = this.createNetworkStatistics();
        double standarddeviationResult = statistics.getStandardDeviation();
        double meanResult = statistics.getMean();
        this.networkTestResult = standarddeviationResult / meanResult;
        this.networkTestResult = (double)Math.round(this.networkTestResult * 100.0) / 100.0;
        System.out.println("--------------------Ergebnis NETWORK:" + standarddeviationResult + " - " + meanResult + " - " + standarddeviationResult / meanResult);
        this.networkTestResultString = this.networkTestResult < 0.5 ? "stable" : (this.networkTestResult >= 0.5 && this.networkTestResult < 2.0 ? "noisy" : "unstable");
        this.networkTestFinished = true;
        this.fireModelChanged();
    }

    private SummaryStatistics createNetworkStatistics() {
        int toSkip = 5;
        int j = 0;
        SummaryStatistics statistics = new SummaryStatistics();
        for (LogEntryRequest currentLogEntry : this.logListNetworktestRequests) {
            if (j >= toSkip) {
                statistics.addValue((double)currentLogEntry.getDuration());
                System.out.println("----add:" + (j - toSkip) + " - " + currentLogEntry.getDuration());
            }
            ++j;
        }
        return statistics;
    }

    public String[] getStateArray() {
        return this.stateArray;
    }

    public String getCurrentAttackState() {
        return this.currentAttackState;
    }

    public Clock getClock() {
        return this.clock;
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }

    public String getAttackTime() {
        return this.attackTime;
    }

    public void setAttackTime(String attackTime) {
        this.attackTime = attackTime;
    }

    public int getNumberRequestsPerThread() {
        return this.numberRequestsPerThread;
    }

    public void setNumberRequestsPerThread(int numberRequestsPerThread) {
        this.numberRequestsPerThread = numberRequestsPerThread;
    }

    public int getNumberThreads() {
        return this.numberThreads;
    }

    public void setNumberThreads(int numberThreads) {
        this.numberThreads = numberThreads;
    }

    public int getCounterThreadsTampered() {
        return this.counterThreadsTampered;
    }

    public void setCounterThreadsTampered(int counterThreads) {
        this.counterThreadsTampered = counterThreads;
    }

    public int getCounterThreadsUntampered() {
        return this.counterThreadsUntampered;
    }

    public void setCounterThreadsUntampered(int counterThreads) {
        this.counterThreadsUntampered = counterThreads;
    }

    public int getCounterRequestsSendTampered() {
        return this.counterRequestsSendTampered;
    }

    public int getCounterRequestsSendUntampered() {
        return this.counterRequestsSendUntampered;
    }

    public synchronized int getCounterRequestsSend(String requestType) {
        if (requestType.equals("untampered")) {
            return this.counterRequestsSendUntampered;
        }
        if (requestType.equals("tampered")) {
            return this.counterRequestsSendTampered;
        }
        if (requestType.equals("networkTest")) {
            return this.counterRequestsSendNetworkTest;
        }
        return 0;
    }

    public int getSecondsBetweenProbes() {
        return this.millisecondsBetweenProbes;
    }

    public void setSecondsBetweenProbes(int secondsBetweenProbes) {
        this.millisecondsBetweenProbes = secondsBetweenProbes;
    }

    public int getSecondsServerLoadRecovery() {
        return this.millisecondsServerLoadRecovery;
    }

    public void setSecondsServerLoadRecovery(int secondsServerLoadRecovery) {
        this.millisecondsServerLoadRecovery = secondsServerLoadRecovery;
    }

    public int getCounterProbesSend() {
        return this.counterProbesSend;
    }

    public boolean isAttackAborted() {
        return this.attackAborted;
    }

    public boolean isAttackFinished() {
        return this.attackFinished;
    }

    public long getTsAttackStart() {
        return this.tsAttackStart;
    }

    public void setTsAttackStart(long tsAttackStart) {
        this.tsAttackStart = tsAttackStart;
    }

    public String getStartDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        Date resultdate = new Date(this.tsAttackStart);
        return sdf.format(resultdate);
    }

    public String getStopDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        Date resultdate = new Date(this.tsAttackStop);
        return sdf.format(resultdate);
    }

    public long getTsAttackStop() {
        return this.tsAttackStop;
    }

    public void setTsAttackStop(long tsAttackStop) {
        this.tsAttackStop = tsAttackStop;
    }

    public Map<Integer, LogEntryInterval> getMapLogEntryIntervalUntampered() {
        return this.mapLogEntryIntervalUntampered;
    }

    public void setMapLogEntryIntervalUntampered(Map<Integer, LogEntryInterval> mapLogEntryIntervalUntampered) {
        this.mapLogEntryIntervalUntampered = mapLogEntryIntervalUntampered;
    }

    public Map<Integer, LogEntryInterval> getMapLogEntryIntervalTampered() {
        return this.mapLogEntryIntervalTampered;
    }

    public void setMapLogEntryIntervalTampered(Map<Integer, LogEntryInterval> mapLogEntryIntervalTampered) {
        this.mapLogEntryIntervalTampered = mapLogEntryIntervalTampered;
    }

    public Map<Integer, LogEntryInterval> getMapLogEntryIntervalTestProbe() {
        return this.mapLogEntryIntervalTestProbe;
    }

    public void setMapLogEntryIntervalTestProbe(Map<Integer, LogEntryInterval> mapLogEntryIntervalTestProbe) {
        this.mapLogEntryIntervalTestProbe = mapLogEntryIntervalTestProbe;
    }

    public int getRequestSizeUntampered() {
        return this.requestSizeUntampered;
    }

    public void setRequestSizeUntampered(int requestSizeUntampered) {
        this.requestSizeUntampered = requestSizeUntampered;
    }

    public int getRequestSizeTampered() {
        return this.requestSizeTampered;
    }

    public void setRequestSizeTampered(int requestSizeTampered) {
        this.requestSizeTampered = requestSizeTampered;
    }

    public int getRequestSizePaddedTampered() {
        return this.requestSizePaddedTampered;
    }

    public int getRequestSizePaddedUntampered() {
        return this.requestSizePaddedUntampered;
    }

    public int getRequestSizeTestProbe() {
        return this.requestSizeTestProbe;
    }

    public void setRequestSizeTestProbe(int requestSizeTestProbe) {
        this.requestSizeTestProbe = requestSizeTestProbe;
    }

    public void setTsTamperedStart(long ts) {
        this.tsTamperedStart = ts;
    }

    public long getTsUntamperedStart() {
        return this.tsUntamperedStart;
    }

    public void setTsTamperedLastSend(long ts) {
        this.tsTamperedLastSend = ts;
    }

    public long getTsTamperedLastSend() {
        return this.tsTamperedLastSend;
    }

    public void setTsUntamperedStart(long tsUntamperedStart) {
        this.tsUntamperedStart = tsUntamperedStart;
    }

    public String getAttackName() {
        return this.attackName;
    }

    public void setAttackName(String attackName) {
        this.attackName = attackName;
    }

    public String getWsdlUrl() {
        return this.wsdlUrl;
    }

    public void setWsdlUrl(String wsdlUrl) {
        this.wsdlUrl = wsdlUrl;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getAttackDescription() {
        return this.attackDescription;
    }

    public void setAttackDescription(String attackDescription) {
        this.attackDescription = attackDescription;
    }

    public String getAttackCountermeasures() {
        return this.attackCountermeasures;
    }

    public void setAttackCountermeasures(String attackCountermeasures) {
        this.attackCountermeasures = attackCountermeasures;
    }

    public String getWsAttackerResults() {
        return this.wsAttackerResults;
    }

    public void setWsAttackerResults(String wsAttackerResults) {
        this.wsAttackerResults = wsAttackerResults;
    }

    public int getWsAttackerPoints() {
        if (this.getAttackRoundtripTimeRatio() > (double)this.payloadSuccessThreshold) {
            int result = (int)(this.getAttackRoundtripTimeRatio() * 16.0);
            if (result > 100) {
                return 100;
            }
            return result;
        }
        return 1;
    }

    public int getSecondsBetweenRequests() {
        return this.millisecondsBetweenRequests;
    }

    public void setSecondsBetweenRequests(int secondsBetweenRequests) {
        this.millisecondsBetweenRequests = secondsBetweenRequests;
    }

    public int getRequestsTotal() {
        return this.numberRequestsPerThread * this.numberThreads;
    }

    public WsdlRequest getWsdlRequestOriginal() {
        return this.wsdlRequestOriginal;
    }

    public void setWsdlRequestOriginal(WsdlRequest wsdlRequestOriginal) {
        this.wsdlRequestOriginal = wsdlRequestOriginal;
    }

    public WsdlResponse getWsdlResponseOriginal() {
        return this.wsdlResponseOriginal;
    }

    public void setWsdlResponseOriginal(WsdlResponse wsdlResponseOriginal) {
        this.wsdlResponseOriginal = wsdlResponseOriginal;
    }

    public int getIntervalLengthReport() {
        return this.intervalLengthReport;
    }

    public void setIntervalLengthReport(int intervalLengthReport) {
        this.intervalLengthReport = intervalLengthReport;
    }

    public boolean isAutoFinalizeSwitch() {
        return this.autoFinalizeSwitch;
    }

    public void setAutoFinalizeSwitch(boolean autoFinalizeSwitch) {
        this.autoFinalizeSwitch = autoFinalizeSwitch;
    }

    public int getAutoFinalizeSeconds() {
        return this.autoFinalizeMilliSeconds;
    }

    public void setAutoFinalizeSeconds(int autoFinalizeSeconds) {
        this.autoFinalizeMilliSeconds = autoFinalizeSeconds;
    }

    public boolean isNetworkTestEnabled() {
        return this.networkTestEnabled;
    }

    public void setNetworkTestEnabled(boolean networkTestEnabled) {
        this.networkTestEnabled = networkTestEnabled;
    }

    public int getNetworkTestNumberRequests() {
        return this.networkTestNumberRequests;
    }

    public void setNetworkTestNumberRequests(int networkTestNumberRequests) {
        this.networkTestNumberRequests = networkTestNumberRequests;
    }

    public int getNetworkTestRequestInterval() {
        return this.networkTestRequestIntervalInMilliseconds;
    }

    public void setNetworkTestRequestInterval(int networkTestRequestInterval) {
        this.networkTestRequestIntervalInMilliseconds = networkTestRequestInterval;
    }

    public double getNetworkTestResult() {
        return this.networkTestResult;
    }

    public void setNetworkTestResult(double networkTestResult) {
        this.networkTestResult = networkTestResult;
    }

    public Thread getSendProbeRequestsThread() {
        return this.sendProbeRequestsThread;
    }

    public void setSendProbeRequestsThread(Thread sendProbeRequestsThread) {
        this.sendProbeRequestsThread = sendProbeRequestsThread;
    }

    public String getNetworkTestResultString() {
        return this.networkTestResultString;
    }

    public void setNetworkTestResultString(String networkTestResultString) {
        this.networkTestResultString = networkTestResultString;
    }

    public boolean isNetworkTestFinished() {
        return this.networkTestFinished;
    }

    public void setNetworkTestFinished(boolean networkTestFinished) {
        this.networkTestFinished = networkTestFinished;
    }

    public RequestObject getTamperedRequestObject() {
        return this.tamperedRequestObject;
    }

    public void setTamperedRequestObject(RequestObject tamperedRequestObject) {
        this.tamperedRequestObject = tamperedRequestObject;
    }

    public RequestObject getUntamperedRequestObject() {
        return this.untamperedRequestObject;
    }

    public void setUntamperedRequestObject(RequestObject untamperedRequestObject) {
        this.untamperedRequestObject = untamperedRequestObject;
    }

    public Map<String, String> getOriginalRequestHeaderFields() {
        return this.originalRequestHeaderFields;
    }

    public void setOriginalRequestHeaderFields(Map<String, String> originalRequestHeaderFields) {
        this.originalRequestHeaderFields = originalRequestHeaderFields;
    }

    public double getMedianUntampered() {
        return this.medianUntampered;
    }

    public void setMedianUntampered(double medianUntampered) {
        this.medianUntampered = medianUntampered;
    }

    public double getMedianTampered() {
        return this.medianTampered;
    }

    public void setMedianTampered(double medianTampered) {
        this.medianTampered = medianTampered;
    }
}

