/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.dos.dosExtension.abstractPlugin;

import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.support.types.StringToStringsMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import wsattacker.main.composition.plugin.AbstractPlugin;
import wsattacker.main.composition.plugin.PluginFunctionInterface;
import wsattacker.main.composition.plugin.option.AbstractOption;
import wsattacker.main.composition.plugin.option.AbstractOptionInteger;
import wsattacker.main.composition.testsuite.RequestResponsePair;
import wsattacker.main.plugin.PluginState;
import wsattacker.main.plugin.option.OptionLimitedInteger;
import wsattacker.main.plugin.option.OptionSimpleBoolean;
import wsattacker.plugin.dos.dosExtension.function.postanalyze.DOSPostAnalyzeFunction;
import wsattacker.plugin.dos.dosExtension.mvc.AttackMVC;
import wsattacker.plugin.dos.dosExtension.mvc.model.AttackModel;
import wsattacker.plugin.dos.dosExtension.option.OptionTextAreaSoapMessage;
import wsattacker.plugin.dos.dosExtension.requestSender.RequestObject;

public abstract class AbstractDosPlugin
extends AbstractPlugin {
    public static final String PROP_COUNTERMEASURES = "countermeasures";
    public static final String PROP_OPTIONNUMBERTHREADS = "optionNumberThreads";
    public static final String PROP_OPTIONNUMBERREQUESTS = "optionNumberRequests";
    public static final String PROP_OPTIONSECONDSBETWEENPROBES = "optionSecondsBetweenProbes";
    public static final String PROP_OPTIONSECONDSBETWEENREQUESTS = "optionSecondsBetweenRequests";
    public static final String PROP_OPTIONAUTOFINALIZESWITCH = "optionAutoFinalizeSwitch";
    public static final String PROP_OPTIONAUTOFINALIZESECONDS = "optionAutoFinalizeSeconds";
    public static final String PROP_OPTIONNETWORKTESTENABLED = "optionNetworkTestEnabled";
    public static final String PROP_OPTIONNETWORKTESTNUMBERREQUESTS = "optionNetworkTestNumberRequests";
    public static final String PROP_OPTIONNETWORKTESTREQUESTINTERVAL = "optionNetworkTestRequestInterval";
    public static final String PROP_OPTIONTEXTAREASOAPMESSAGE = "optionTextAreaSoapMessage";
    public static final String PROP_ORIGINALREQUESTRESPONSEPAIR = "originalRequestResponsePair";
    public static final String PROP_ORIGINALREQUESTHEADERFIELDS = "originalRequestHeaderFields";
    public static final String PROP_UNTAMPEREDREQUESTOBJECT = "untamperedRequestObject";
    public static final String PROP_TAMPEREDREQUESTOBJECT = "tamperedRequestObject";
    public static final String PROP_ATTACKMODEL = "attackModel";
    public static final String PROP_ATTACKPRECHECK = "attackPrecheck";
    public static final String NUMBER_OF_PARALLEL_THREADS = "Number of parallel threads";
    public static final String NUMBER_OF_REQUESTS_PER_THREAD = "Number of requests per thread";
    public static final String DELAY_BETWEEN_ATTACK_REQUESTS = "Delay between attack requests";
    public static final String DELAY_BETWEEN_CONTINUOUS_TESTPROBE_REQUES = "Delay between continuous testprobe requests";
    public static final String SERVER_RECOVERY_TIME = "Server recovery time";
    public static final String AUTO_STOP = "Auto stop";
    public static final String AUTO_STOP_TIME = "Auto stop: Time";
    public static final String NETWORK_STABILITY_TEST = "Network stability test";
    public static final String NETWORK_STABILITY_TEST_NUMBER_OF_REQUESTS = "Network stability test: Number of requests";
    public static final String NETWORK_STABILITY_TEST_DELAY_BETWEEN_TEST = "Network stability test: Delay between testrequest";
    public static final String MESSAGE = "Message";
    private static final long serialVersionUID = 1L;
    private AbstractOptionInteger optionNumberThreads;
    private AbstractOptionInteger optionNumberRequests;
    private AbstractOptionInteger optionSecondsBetweenProbes;
    private AbstractOptionInteger optionSecondsBetweenRequests;
    private AbstractOptionInteger optionSecondsServerLoadRecovery;
    private OptionSimpleBoolean optionAutoFinalizeSwitch;
    private AbstractOptionInteger optionAutoFinalizeSeconds;
    private OptionSimpleBoolean optionNetworkTestEnabled;
    private AbstractOptionInteger optionNetworkTestNumberRequests;
    private AbstractOptionInteger optionNetworkTestRequestInterval;
    private OptionTextAreaSoapMessage optionTextAreaSoapMessage;
    private RequestResponsePair originalRequestResponsePair;
    private Map<String, String> originalRequestHeaderFields;
    private RequestObject untamperedRequestObject;
    private RequestObject tamperedRequestObject;
    private AttackModel attackModel;
    private boolean attackPrecheck = true;
    private String countermeasures = "";

    public String getCountermeasures() {
        return this.countermeasures;
    }

    public void setCountermeasures(String countermeasures) {
        String oldCountermeasures = this.countermeasures;
        this.countermeasures = countermeasures;
        this.firePropertyChange(PROP_COUNTERMEASURES, oldCountermeasures, countermeasures);
    }

    public boolean attackPrecheck() {
        return true;
    }

    public void initializePlugin() {
        this.preInitPlugin();
        this.initializeDosPlugin();
        this.postInitPlugin();
    }

    public void preInitPlugin() {
        this.setCategory(new String[]{"Denial of Service", "Manual Attacks"});
        this.setAuthor("Andreas Falkenberg");
        this.setVersion("1.1 / 2013-07-26");
        this.setOptionNumberThreads((AbstractOptionInteger)new OptionLimitedInteger(NUMBER_OF_PARALLEL_THREADS, 2, "The number of used threads for attacking the web service", 0, 65536));
        this.setOptionNumberRequests((AbstractOptionInteger)new OptionLimitedInteger(NUMBER_OF_REQUESTS_PER_THREAD, 4, "The total number of requests sent by each thread", 0, 65536));
        this.setOptionSecondsBetweenRequests((AbstractOptionInteger)new OptionLimitedInteger(DELAY_BETWEEN_ATTACK_REQUESTS, 750, "Milliseconds to wait between every attack request", 0, 65536));
        this.setOptionSecondsBetweenProbes((AbstractOptionInteger)new OptionLimitedInteger(DELAY_BETWEEN_CONTINUOUS_TESTPROBE_REQUES, 500, "Milliseconds to wait between every testprobe request (Simulates normal User)", 0, 65536));
        this.setOptionSecondsServerLoadRecovery((AbstractOptionInteger)new OptionLimitedInteger(SERVER_RECOVERY_TIME, 4, "Seconds between receiving last untampered request and sending first untampered request", 0, 65536));
        this.setOptionAutoFinalizeSwitch(new OptionSimpleBoolean(AUTO_STOP, true, "false = manuel stop, true = auto stop after defined sec after last tampered request"));
        this.setOptionAutoFinalizeSeconds((AbstractOptionInteger)new OptionLimitedInteger(AUTO_STOP_TIME, 5, "Seconds between receiving last tampered request and finalization (end) of attack", 0, 655360));
        this.setOptionNetworkTestEnabled(new OptionSimpleBoolean(NETWORK_STABILITY_TEST, false, "false = network stability test disabled, true = enabled"));
        this.setOptionNetworkTestNumberRequests((AbstractOptionInteger)new OptionLimitedInteger(NETWORK_STABILITY_TEST_NUMBER_OF_REQUESTS, 40, "Perform network stability test with defined number of requests", 0, 655360));
        this.setOptionNetworkTestRequestInterval((AbstractOptionInteger)new OptionLimitedInteger(NETWORK_STABILITY_TEST_DELAY_BETWEEN_TEST, 500, "Milliseconds to wait between each Network Stability Testrequest", 0, 655360));
        this.getPluginOptions().add((AbstractOption)this.getOptionNumberThreads());
        this.getPluginOptions().add((AbstractOption)this.getOptionNumberRequests());
        this.getPluginOptions().add((AbstractOption)this.getOptionSecondsBetweenProbes());
        this.getPluginOptions().add((AbstractOption)this.getOptionSecondsBetweenRequests());
        this.getPluginOptions().add((AbstractOption)this.getOptionSecondsServerLoadRecovery());
        this.getPluginOptions().add((AbstractOption)this.getOptionAutoFinalizeSwitch());
        this.getPluginOptions().add((AbstractOption)this.getOptionAutoFinalizeSeconds());
        this.getPluginOptions().add((AbstractOption)this.getOptionNetworkTestEnabled());
        this.getPluginOptions().add((AbstractOption)this.getOptionNetworkTestNumberRequests());
        this.getPluginOptions().add((AbstractOption)this.getOptionNetworkTestRequestInterval());
        this.setState(PluginState.Ready);
        this.setPluginFunctions(new PluginFunctionInterface[]{new DOSPostAnalyzeFunction()});
    }

    public void postInitPlugin() {
        this.setOptionTextAreaSoapMessage(new OptionTextAreaSoapMessage(MESSAGE, "set position of payload placeholder", this.getPayloadPosition()));
        this.getPluginOptions().add((AbstractOption)this.getOptionTextAreaSoapMessage());
    }

    public abstract void initializeDosPlugin();

    public abstract OptionTextAreaSoapMessage.PayloadPosition getPayloadPosition();

    public abstract void createTamperedRequest();

    public void createUntamperedRequest() {
        HashMap<String, String> httpHeaderMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.getOriginalRequestHeaderFields().entrySet()) {
            httpHeaderMap.put(entry.getKey(), entry.getValue());
        }
        this.setUntamperedRequestObject(httpHeaderMap, this.originalRequestResponsePair.getWsdlRequest().getEndpoint(), this.originalRequestResponsePair.getWsdlRequest().getRequestContent());
    }

    public void createRequestPadding() {
        long sizeUntamperedRequest;
        long sizeTamperedRequest = this.tamperedRequestObject.getXmlMessageLength();
        long sizeDelta = sizeTamperedRequest - (sizeUntamperedRequest = (long)this.untamperedRequestObject.getXmlMessageLength());
        if (sizeDelta > 0L) {
            String xmlMessage = this.untamperedRequestObject.getXmlMessage();
            String string = this.createPadding(sizeDelta, xmlMessage);
            this.untamperedRequestObject.setXmlMessage(string);
        } else if (sizeDelta < 0L) {
            String xmlMessage = this.tamperedRequestObject.getXmlMessage();
            String string = this.createPadding(Math.abs(sizeDelta), xmlMessage);
            this.tamperedRequestObject.setXmlMessage(string);
        }
    }

    private String createPadding(long sizeDelta, String xmlMessage) {
        StringBuilder sb = new StringBuilder();
        String comment_start = "<!--";
        String comment_end = "-->";
        int offset = comment_start.length() + comment_end.length();
        int l = (int)sizeDelta - offset;
        sb.append(comment_start);
        for (int i = 0; i < l; ++i) {
            sb.append("c");
        }
        sb.append(comment_end);
        sb.append(xmlMessage);
        String string = sb.toString();
        return string;
    }

    public void createOriginalRequestHeaderFields() {
        HashMap<String, String> httpHeaderMap = new HashMap<String, String>();
        StringToStringsMap originalHeaders = this.originalRequestResponsePair.getWsdlResponse().getRequestHeaders();
        for (Map.Entry entry : originalHeaders.entrySet()) {
            for (String value : (List)entry.getValue()) {
                httpHeaderMap.put((String)entry.getKey(), value);
            }
        }
        this.setOriginalRequestHeaderFields(httpHeaderMap);
    }

    public void attackImplementationHook(RequestResponsePair original) {
        this.setOriginalRequestResponsePair(original);
        this.createOriginalRequestHeaderFields();
        if (this.attackPrecheck()) {
            this.createTamperedRequest();
            this.createUntamperedRequest();
            this.createRequestPadding();
            this.setAttackModel(AttackMVC.runDosAttack(this));
            this.setCurrentPoints(this.attackModel.getWsAttackerPoints());
            if (this.getCurrentPoints() == 0) {
                this.info(this.attackModel.getWsAttackerResults());
                this.setState(PluginState.Failed);
            } else if (this.getCurrentPoints() > 0) {
                this.important(this.attackModel.getWsAttackerResults());
                this.setState(PluginState.Finished);
            }
        } else {
            this.setCurrentPoints(0);
            this.important("Attack not possible - Structure of SOAP Message is not suitable!");
            this.setState(PluginState.Failed);
        }
    }

    public void clean() {
        this.setAttackModel(null);
        this.setCurrentPoints(0);
        this.setState(PluginState.Ready);
        if (this.getPluginFunctions(0) instanceof DOSPostAnalyzeFunction) {
            DOSPostAnalyzeFunction b = (DOSPostAnalyzeFunction)this.getPluginFunctions(0);
            b.setAttackModel(this.attackModel);
        }
    }

    public void stopHook() {
        this.setTamperedRequestObject(null);
        this.setUntamperedRequestObject(null);
    }

    public boolean wasSuccessful() {
        return this.isFinished() && this.getCurrentPoints() > 1;
    }

    public void restoreConfiguration(AbstractPlugin plugin) {
    }

    public AbstractOptionInteger getOptionNumberThreads() {
        return this.optionNumberThreads;
    }

    public AbstractOptionInteger getOptionNumberRequests() {
        return this.optionNumberRequests;
    }

    public AbstractOptionInteger getOptionSecondsBetweenProbes() {
        return this.optionSecondsBetweenProbes;
    }

    public AbstractOptionInteger getOptionSecondsBetweenRequests() {
        return this.optionSecondsBetweenRequests;
    }

    public AbstractOptionInteger getOptionSecondsServerLoadRecovery() {
        return this.optionSecondsServerLoadRecovery;
    }

    public void setOptionSecondsServerLoadRecovery(AbstractOptionInteger optionSecondsServerLoadRecovery) {
        this.optionSecondsServerLoadRecovery = optionSecondsServerLoadRecovery;
    }

    public WsdlRequest getOriginalRequest() {
        return this.originalRequestResponsePair.getWsdlRequest();
    }

    public String getOriginalAction() {
        return this.originalRequestResponsePair.getWsdlRequest().getAction();
    }

    public AttackModel getAttackModel() {
        return this.attackModel;
    }

    public boolean getAttackPrecheck() {
        return this.attackPrecheck;
    }

    public OptionSimpleBoolean getOptionAutoFinalizeSwitch() {
        return this.optionAutoFinalizeSwitch;
    }

    public AbstractOptionInteger getOptionAutoFinalizeSeconds() {
        return this.optionAutoFinalizeSeconds;
    }

    public OptionSimpleBoolean getOptionNetworkTestEnabled() {
        return this.optionNetworkTestEnabled;
    }

    public AbstractOptionInteger getOptionNetworkTestNumberRequests() {
        return this.optionNetworkTestNumberRequests;
    }

    public AbstractOptionInteger getOptionNetworkTestRequestInterval() {
        return this.optionNetworkTestRequestInterval;
    }

    public RequestObject getTamperedRequestObject() {
        return this.tamperedRequestObject;
    }

    public void setTamperedRequestObject(Map<String, String> httpHeaderMap, String endpoint, String msg) {
        this.setTamperedRequestObject(new RequestObject(msg, endpoint, httpHeaderMap));
    }

    public RequestObject getUntamperedRequestObject() {
        return this.untamperedRequestObject;
    }

    public void setUntamperedRequestObject(Map<String, String> httpHeaderMap, String endpoint, String msg) {
        this.setUntamperedRequestObject(new RequestObject(msg, endpoint, httpHeaderMap));
    }

    public OptionTextAreaSoapMessage getOptionTextAreaSoapMessage() {
        return this.optionTextAreaSoapMessage;
    }

    public Map<String, String> getOriginalRequestHeaderFields() {
        if (this.originalRequestHeaderFields == null) {
            this.setOriginalRequestHeaderFields(new HashMap<String, String>());
        }
        return this.originalRequestHeaderFields;
    }

    public RequestResponsePair getOriginalRequestResponsePair() {
        return this.originalRequestResponsePair;
    }

    public void setOptionNumberThreads(AbstractOptionInteger optionNumberThreads) {
        AbstractOptionInteger oldOptionNumberThreads = this.optionNumberThreads;
        this.optionNumberThreads = optionNumberThreads;
        this.firePropertyChange(PROP_OPTIONNUMBERTHREADS, oldOptionNumberThreads, optionNumberThreads);
    }

    public void setOptionNumberRequests(AbstractOptionInteger optionNumberRequests) {
        AbstractOptionInteger oldOptionNumberRequests = this.optionNumberRequests;
        this.optionNumberRequests = optionNumberRequests;
        this.firePropertyChange(PROP_OPTIONNUMBERREQUESTS, oldOptionNumberRequests, optionNumberRequests);
    }

    public void setOptionSecondsBetweenProbes(AbstractOptionInteger optionSecondsBetweenProbes) {
        AbstractOptionInteger oldOptionSecondsBetweenProbes = this.optionSecondsBetweenProbes;
        this.optionSecondsBetweenProbes = optionSecondsBetweenProbes;
        this.firePropertyChange(PROP_OPTIONSECONDSBETWEENPROBES, oldOptionSecondsBetweenProbes, optionSecondsBetweenProbes);
    }

    public void setOptionSecondsBetweenRequests(AbstractOptionInteger optionSecondsBetweenRequests) {
        AbstractOptionInteger oldOptionSecondsBetweenRequests = this.optionSecondsBetweenRequests;
        this.optionSecondsBetweenRequests = optionSecondsBetweenRequests;
        this.firePropertyChange(PROP_OPTIONSECONDSBETWEENREQUESTS, oldOptionSecondsBetweenRequests, optionSecondsBetweenRequests);
    }

    public void setOptionAutoFinalizeSwitch(OptionSimpleBoolean optionAutoFinalizeSwitch) {
        OptionSimpleBoolean oldOptionAutoFinalizeSwitch = this.optionAutoFinalizeSwitch;
        this.optionAutoFinalizeSwitch = optionAutoFinalizeSwitch;
        this.firePropertyChange(PROP_OPTIONAUTOFINALIZESWITCH, oldOptionAutoFinalizeSwitch, optionAutoFinalizeSwitch);
    }

    public void setOptionAutoFinalizeSeconds(AbstractOptionInteger optionAutoFinalizeSeconds) {
        AbstractOptionInteger oldOptionAutoFinalizeSeconds = this.optionAutoFinalizeSeconds;
        this.optionAutoFinalizeSeconds = optionAutoFinalizeSeconds;
        this.firePropertyChange(PROP_OPTIONAUTOFINALIZESECONDS, oldOptionAutoFinalizeSeconds, optionAutoFinalizeSeconds);
    }

    public void setOptionNetworkTestEnabled(OptionSimpleBoolean optionNetworkTestEnabled) {
        OptionSimpleBoolean oldOptionNetworkTestEnabled = this.optionNetworkTestEnabled;
        this.optionNetworkTestEnabled = optionNetworkTestEnabled;
        this.firePropertyChange(PROP_OPTIONNETWORKTESTENABLED, oldOptionNetworkTestEnabled, optionNetworkTestEnabled);
    }

    public void setOptionNetworkTestNumberRequests(AbstractOptionInteger optionNetworkTestNumberRequests) {
        AbstractOptionInteger oldOptionNetworkTestNumberRequests = this.optionNetworkTestNumberRequests;
        this.optionNetworkTestNumberRequests = optionNetworkTestNumberRequests;
        this.firePropertyChange(PROP_OPTIONNETWORKTESTNUMBERREQUESTS, oldOptionNetworkTestNumberRequests, optionNetworkTestNumberRequests);
    }

    public void setOptionNetworkTestRequestInterval(AbstractOptionInteger optionNetworkTestRequestInterval) {
        AbstractOptionInteger oldOptionNetworkTestRequestInterval = this.optionNetworkTestRequestInterval;
        this.optionNetworkTestRequestInterval = optionNetworkTestRequestInterval;
        this.firePropertyChange(PROP_OPTIONNETWORKTESTREQUESTINTERVAL, oldOptionNetworkTestRequestInterval, optionNetworkTestRequestInterval);
    }

    public void setOptionTextAreaSoapMessage(OptionTextAreaSoapMessage optionTextAreaSoapMessage) {
        OptionTextAreaSoapMessage oldOptionTextAreaSoapMessage = this.optionTextAreaSoapMessage;
        this.optionTextAreaSoapMessage = optionTextAreaSoapMessage;
        this.firePropertyChange(PROP_OPTIONTEXTAREASOAPMESSAGE, (Object)oldOptionTextAreaSoapMessage, (Object)optionTextAreaSoapMessage);
    }

    public void setOriginalRequestResponsePair(RequestResponsePair originalRequestResponsePair) {
        RequestResponsePair oldOriginalRequestResponsePair = this.originalRequestResponsePair;
        this.originalRequestResponsePair = originalRequestResponsePair;
        this.firePropertyChange(PROP_ORIGINALREQUESTRESPONSEPAIR, oldOriginalRequestResponsePair, originalRequestResponsePair);
    }

    public void setOriginalRequestHeaderFields(Map<String, String> originalRequestHeaderFields) {
        Map<String, String> oldOriginalRequestHeaderFields = this.originalRequestHeaderFields;
        this.originalRequestHeaderFields = originalRequestHeaderFields;
        this.firePropertyChange(PROP_ORIGINALREQUESTHEADERFIELDS, oldOriginalRequestHeaderFields, originalRequestHeaderFields);
    }

    public void setUntamperedRequestObject(RequestObject untamperedRequestObject) {
        RequestObject oldUntamperedRequestObject = this.untamperedRequestObject;
        this.untamperedRequestObject = untamperedRequestObject;
        this.firePropertyChange(PROP_UNTAMPEREDREQUESTOBJECT, oldUntamperedRequestObject, untamperedRequestObject);
    }

    public void setTamperedRequestObject(RequestObject tamperedRequestObject) {
        RequestObject oldTamperedRequestObject = this.tamperedRequestObject;
        this.tamperedRequestObject = tamperedRequestObject;
        this.firePropertyChange(PROP_TAMPEREDREQUESTOBJECT, oldTamperedRequestObject, tamperedRequestObject);
    }

    public void setAttackModel(AttackModel attackModel) {
        AttackModel oldAttackModel = this.attackModel;
        this.attackModel = attackModel;
        this.firePropertyChange(PROP_ATTACKMODEL, oldAttackModel, attackModel);
    }

    public void setAttackPrecheck(boolean attackPrecheck) {
        boolean oldAttackPrecheck = this.attackPrecheck;
        this.attackPrecheck = attackPrecheck;
        this.firePropertyChange(PROP_ATTACKPRECHECK, oldAttackPrecheck, attackPrecheck);
    }
}

