/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.shef.wit.simmetrics.similaritymetrics;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import uk.ac.shef.wit.simmetrics.similaritymetrics.AbstractStringMetric;
import uk.ac.shef.wit.simmetrics.tokenisers.InterfaceTokeniser;
import uk.ac.shef.wit.simmetrics.tokenisers.TokeniserQGram3Extended;

public final class QGramsDistance
extends AbstractStringMetric
implements Serializable {
    private final float ESTIMATEDTIMINGCONST = 1.34E-4f;
    private final InterfaceTokeniser tokeniser;

    public QGramsDistance() {
        this.tokeniser = new TokeniserQGram3Extended();
    }

    public QGramsDistance(InterfaceTokeniser tokeniserToUse) {
        this.tokeniser = tokeniserToUse;
    }

    public String getShortDescriptionString() {
        return "QGramsDistance";
    }

    public String getLongDescriptionString() {
        return "Implements the Q Grams Distance algorithm providing a similarity measure between two strings using the qGram approach check matching qGrams/possible matching qGrams";
    }

    public String getSimilarityExplained(String string1, String string2) {
        return null;
    }

    public float getSimilarityTimingEstimated(String string1, String string2) {
        float str1Length = string1.length();
        float str2Length = string2.length();
        return str1Length * str2Length * 1.34E-4f;
    }

    public float getSimilarity(String string1, String string2) {
        ArrayList<String> str1Tokens = this.tokeniser.tokenizeToArrayList(string1);
        ArrayList<String> str2Tokens = this.tokeniser.tokenizeToArrayList(string2);
        int maxQGramsMatching = str1Tokens.size() + str2Tokens.size();
        if (maxQGramsMatching == 0) {
            return 0.0f;
        }
        return ((float)maxQGramsMatching - this.getUnNormalisedSimilarity(string1, string2)) / (float)maxQGramsMatching;
    }

    public float getUnNormalisedSimilarity(String string1, String string2) {
        ArrayList<String> str1Tokens = this.tokeniser.tokenizeToArrayList(string1);
        ArrayList<String> str2Tokens = this.tokeniser.tokenizeToArrayList(string2);
        HashSet<String> allTokens = new HashSet<String>();
        allTokens.addAll(str1Tokens);
        allTokens.addAll(str2Tokens);
        Iterator allTokensIt = allTokens.iterator();
        int difference = 0;
        while (allTokensIt.hasNext()) {
            String token = (String)allTokensIt.next();
            int matchingQGrams1 = 0;
            for (String str1Token : str1Tokens) {
                if (!str1Token.equals(token)) continue;
                ++matchingQGrams1;
            }
            int matchingQGrams2 = 0;
            for (String str2Token : str2Tokens) {
                if (!str2Token.equals(token)) continue;
                ++matchingQGrams2;
            }
            if (matchingQGrams1 > matchingQGrams2) {
                difference += matchingQGrams1 - matchingQGrams2;
                continue;
            }
            difference += matchingQGrams2 - matchingQGrams1;
        }
        return difference;
    }
}

