/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.xmlencryptionattack.option;

import com.eviware.soapui.impl.wsdl.WsdlRequest;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;
import wsattacker.gui.component.pluginconfiguration.composition.OptionGUI;
import wsattacker.library.xmlencryptionattack.attackengine.AttackConfig;
import wsattacker.library.xmlencryptionattack.attackengine.CryptoAttackException;
import wsattacker.library.xmlencryptionattack.attackengine.Utility;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.base.mode.OracleResponseCollector;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.base.response.OracleResponse;
import wsattacker.library.xmlencryptionattack.detectionengine.detectionstreams.DetectionReport;
import wsattacker.library.xmlencryptionattack.encryptedelements.AbstractEncryptionElement;
import wsattacker.library.xmlencryptionattack.util.JAXBOResponseHandler;
import wsattacker.main.composition.plugin.option.AbstractOption;
import wsattacker.main.testsuite.TestSuite;
import wsattacker.plugin.xmlencryptionattack.WebServiceSendCommand;
import wsattacker.plugin.xmlencryptionattack.XMLEncryptionAttack;
import wsattacker.plugin.xmlencryptionattack.serverbehaviour.ServerErrMsgSendFunc;
import wsattacker.plugin.xmlencryptionattack.serverbehaviour.gui.ServerBehaviourGUI;

public class OptionServerErrorBehaviour
extends AbstractOption {
    private final OracleResponseCollector m_ServerErrorTab = new OracleResponseCollector();
    private final AttackConfig m_AttackCfg;
    private final DetectionReport m_DetectionReport;
    public static final String PROP_SERVERBEHAVE = "serverBehave";
    private static final long serialVersionUID = 1L;
    private Thread m_MessageThread;
    private ServerBehaviourGUI m_OptionTableGUI;
    private boolean m_IsPKCS1WithEncData = false;
    private ServerErrMsgSendFunc m_ServerErrorFunc = null;

    public OptionServerErrorBehaviour(AttackConfig attackcfg, DetectionReport detectReport) {
        super("Error Table", "Display the error Table.");
        this.m_DetectionReport = detectReport;
        this.m_DetectionReport.setErrorResponseTab(this.m_ServerErrorTab);
        this.m_AttackCfg = attackcfg;
    }

    public AttackConfig getAttackCfg() {
        return this.m_AttackCfg;
    }

    public OptionGUI createOptionGUI() {
        this.m_OptionTableGUI = new ServerBehaviourGUI(this.getCollection().getOwnerPlugin(), this);
        return this.m_OptionTableGUI;
    }

    public void updateProgressBar(int progressStep) {
        this.m_OptionTableGUI.updateProgressBar(progressStep);
    }

    public boolean isValid(String value) {
        return true;
    }

    public void parseValue(String value) {
    }

    public String getValueAsString() {
        return this.getName();
    }

    public List<OracleResponse> getResponseData() {
        return this.m_ServerErrorTab.getData();
    }

    public void SaveDataToFile(File file) throws IOException, JAXBException {
        JAXBOResponseHandler.marshal((List)this.m_ServerErrorTab.getData(), (File)file);
    }

    public void LoadDataFromFile(File file) {
        try {
            this.m_ServerErrorTab.setData(JAXBOResponseHandler.unmarshal((File)file));
            this.m_DetectionReport.setErrorResponseTab(this.m_ServerErrorTab);
            this.m_OptionTableGUI.initTable();
            this.firePropertyChange(PROP_SERVERBEHAVE, null, null);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    public void getServerBehaviour() throws IOException, JAXBException, CryptoAttackException {
        WsdlRequest currentWsdlRequest = TestSuite.getInstance().getCurrentRequest().getWsdlRequest();
        WebServiceSendCommand serCmdnew = new WebServiceSendCommand(currentWsdlRequest);
        this.m_ServerErrorFunc = new ServerErrMsgSendFunc(this.m_AttackCfg, this.m_DetectionReport, this, serCmdnew);
        this.m_ServerErrorTab.setCompareThreshold(this.m_AttackCfg.getStringCmpThresHold());
        this.m_ServerErrorFunc.setIsPKCS1WithEncData(this.m_IsPKCS1WithEncData);
        this.m_MessageThread = new Thread(this.m_ServerErrorFunc);
        this.m_MessageThread.start();
    }

    private Logger log() {
        return Logger.getLogger(((Object)((Object)this)).getClass());
    }

    public void setGUIButtonState(boolean b) {
        this.m_OptionTableGUI.setBtnsState(b);
    }

    public void updateServerErrOption(OracleResponse serverResp, AbstractEncryptionElement pay) throws SAXException, XPathExpressionException {
        boolean isNewError = false;
        if (this.m_ServerErrorTab.isIgnorePayloadResponse()) {
            if (!this.m_ServerErrorTab.checkIsRequestResponse(serverResp, pay)) {
                isNewError = this.m_ServerErrorTab.add(serverResp);
            }
        } else {
            isNewError = this.m_ServerErrorTab.add(serverResp);
        }
        if (isNewError) {
            this.m_OptionTableGUI.updateTable(serverResp);
        }
    }

    public void deleteAllErrorTabDatas() {
        this.m_ServerErrorTab.getData().clear();
        this.m_OptionTableGUI.initTable();
        ((XMLEncryptionAttack)this.getCollection().getOwnerPlugin()).checkState();
    }

    public void setCertServer(File certtificate) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException, CertificateException {
        this.m_AttackCfg.getPKCS1AttackCfg().setServerRSAPubKey((RSAPublicKey)Utility.getPubKeyFromCert((File)certtificate));
    }

    public void setPubKeyServer(File pubKey) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException, CertificateException {
        this.m_AttackCfg.getPKCS1AttackCfg().setServerRSAPubKey((RSAPublicKey)Utility.getPubKeyFromKeyFile((File)pubKey));
    }

    public void stopSendingMessages() {
        if (null != this.m_ServerErrorFunc) {
            this.m_ServerErrorFunc.stop();
            this.m_MessageThread.stop();
        }
        this.setGUIButtonState(true);
    }

    public void abortSendingMessages() {
        if (null != this.m_ServerErrorFunc) {
            this.m_ServerErrorFunc.stop();
        }
    }

    public void setIsPKCS1WithEncData(boolean state) {
        this.m_IsPKCS1WithEncData = state;
    }

    public void setIsIgnoreRequestResponse(boolean state) {
        this.m_ServerErrorTab.setIsIgnorePayloadResponse(state);
    }
}

