/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.xmlencryptionattack.option;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import wsattacker.library.xmlencryptionattack.attackengine.AttackConfig;
import wsattacker.library.xmlencryptionattack.attackengine.attacker.pkcs1.PKCS1AttackConfig;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.concrete.pkcs1.strategy.PKCS1StrategyFactory;
import wsattacker.library.xmlencryptionattack.detectionengine.detectionmanager.DetectFilterEnum;
import wsattacker.library.xmlencryptionattack.detectionengine.detectionmanager.DetectionManager;
import wsattacker.library.xmlencryptionattack.detectionengine.detectionmanager.FactoryFilter;
import wsattacker.library.xmlencryptionattack.detectionengine.detectionmanager.Pipeline;
import wsattacker.library.xmlencryptionattack.detectionengine.detectionstreams.DetectionReport;
import wsattacker.library.xmlencryptionattack.detectionengine.filter.info.EncryptionInfo;
import wsattacker.library.xmlencryptionattack.encryptedelements.AbstractEncryptionElement;
import wsattacker.library.xmlencryptionattack.encryptedelements.ElementAttackProperties;
import wsattacker.library.xmlencryptionattack.encryptedelements.data.EncryptedDataElement;
import wsattacker.library.xmlencryptionattack.encryptedelements.key.DataReferenceElement;
import wsattacker.library.xmlencryptionattack.encryptedelements.key.EncryptedKeyElement;
import wsattacker.library.xmlencryptionattack.util.SimStringStrategyFactory;
import wsattacker.library.xmlencryptionattack.util.XMLEncryptionConstants;
import wsattacker.main.composition.plugin.option.AbstractOption;
import wsattacker.main.composition.plugin.option.AbstractOptionMultiFiles;
import wsattacker.main.composition.testsuite.CurrentRequestContentChangeObserver;
import wsattacker.main.plugin.PluginOptionContainer;
import wsattacker.main.plugin.option.OptionSimpleBoolean;
import wsattacker.main.plugin.option.OptionSimpleMultiFiles;
import wsattacker.main.plugin.option.OptionSoapAction;
import wsattacker.plugin.xmlencryptionattack.XMLEncryptionAttack;
import wsattacker.plugin.xmlencryptionattack.option.OptionPayloadEncryption;
import wsattacker.plugin.xmlencryptionattack.option.OptionServerErrorBehaviour;

public final class OptionManagerEncryption
implements CurrentRequestContentChangeObserver,
PropertyChangeListener {
    private static final Logger LOG;
    private XMLEncryptionAttack m_Plugin;
    private DetectionManager m_DetectionManager;
    private final OptionSoapAction m_OptionSoapAction = new OptionSoapAction("Change\nAction?", "Allows to change the SoapAction Header.");
    private final OptionSimpleBoolean m_OptionNoSchema;
    private final OptionSimpleMultiFiles m_OptionSchemaFiles = new OptionSimpleMultiFiles("Used\nSchema\nfiles", "Set the Schema Files.\nSoap11, Soap12, WSA, WSSE, WSU, DS and XPathFilter2\nare included by default.");
    private OptionServerErrorBehaviour m_OptionServerResponse = null;
    private final List<AbstractEncryptionElement> m_OptionPayloadList;
    private OptionPayloadEncryption m_OptionEncPays = null;
    private final AttackConfig m_AttackCfg;
    private boolean m_IsInProgress = false;
    private static final OptionManagerEncryption INSTANCE;
    private final Pipeline m_PipeLine;

    public static OptionManagerEncryption getInstance() {
        return INSTANCE;
    }

    public XMLEncryptionAttack getPlugin() {
        return this.m_Plugin;
    }

    public void setPlugin(XMLEncryptionAttack plugin) {
        if (this.m_Plugin != null) {
            this.m_Plugin.getPluginOptions().addPropertyChangeListener((PropertyChangeListener)this);
        }
        this.m_Plugin = plugin;
        if (plugin != null) {
            this.m_Plugin.getPluginOptions().addPropertyChangeListener((PropertyChangeListener)this);
            this.m_Plugin.getPluginOptions().setOptions(this.addConfigOptions());
        }
        plugin.setAttackCfg(this.m_AttackCfg);
    }

    public DetectionManager getDetectioManager() {
        return this.m_DetectionManager;
    }

    private OptionManagerEncryption() {
        this.m_OptionNoSchema = new OptionSimpleBoolean("Schema?", false, "Turn on, to not use any XML Schema.");
        this.m_OptionPayloadList = new ArrayList<AbstractEncryptionElement>();
        PKCS1AttackConfig pKCS1AttackCFG = new PKCS1AttackConfig();
        this.m_AttackCfg = new AttackConfig();
        this.m_AttackCfg.setPKCS1AttackCfg(pKCS1AttackCFG);
        this.initAttackCfg();
        this.m_PipeLine = new Pipeline();
    }

    public void initAttackCfg() {
        this.m_AttackCfg.setOracleMode(XMLEncryptionConstants.OracleMode.ERROR_ORACLE);
        this.m_AttackCfg.setWrappingMode(XMLEncryptionConstants.WrappingAttackMode.NO_WRAP);
        this.m_AttackCfg.setXMLEncryptionAttack(XMLEncryptionConstants.XMLEncryptionAttackMode.CBC_ATTACK);
        this.m_AttackCfg.setSimStringStrategyType(SimStringStrategyFactory.SimStringStrategy.DICE_COEFF);
        this.m_AttackCfg.setChosenAttackPayload(null);
        this.m_AttackCfg.setChosenWrapPayload(null);
        this.m_AttackCfg.setStringCmpThresHold(0.9);
        this.m_AttackCfg.setStringCmpWrappThreshold(0.9);
        this.m_AttackCfg.getPKCS1AttackCfg().setServerRSAPubKey(null);
        this.m_AttackCfg.getPKCS1AttackCfg().setPKCS1Strategy(PKCS1StrategyFactory.PKCS1Strategy.CBC_WEAK);
    }

    public OptionServerErrorBehaviour getOptionServerResponse() {
        return this.m_OptionServerResponse;
    }

    private Logger log() {
        return Logger.getLogger(this.getClass());
    }

    public void currentRequestContentChanged(String newContent, String oldContent) {
        if (!this.m_IsInProgress) {
            this.m_IsInProgress = true;
            if (!oldContent.equals("")) {
                this.log().trace((Object)"Current Request Content Changed");
            }
            throw new RuntimeException("Uncompilable source code - exception org.xml.sax.SAXException is never thrown in body of corresponding try statement");
        }
    }

    private void addPayloads(Document domDoc) {
        ElementAttackProperties attackProps;
        DetectionReport detectReport = null;
        this.m_PipeLine.removeAllFilerFromPipline();
        this.m_PipeLine.addFilerToPipline(FactoryFilter.createFilter((DetectFilterEnum)DetectFilterEnum.ENCRYPTIONFILTER));
        this.m_PipeLine.addFilerToPipline(FactoryFilter.createFilter((DetectFilterEnum)DetectFilterEnum.SIGNATUREFILTER));
        this.m_PipeLine.addFilerToPipline(FactoryFilter.createFilter((DetectFilterEnum)DetectFilterEnum.TIMESTAMPFILTER));
        this.m_DetectionManager = this.handleDetection(domDoc);
        detectReport = this.m_DetectionManager.getDetectionReport();
        EncryptionInfo encInfo = (EncryptionInfo)detectReport.getDetectionInfo(DetectFilterEnum.ENCRYPTIONFILTER);
        List encKeyList = encInfo.getEncryptedKeyElements();
        List encDataList = encInfo.getEncryptedDataElements();
        for (int i = 0; i < this.m_OptionPayloadList.size(); ++i) {
            AbstractEncryptionElement option = this.m_OptionPayloadList.get(i);
            attackProps = option.getAttackProperties();
            attackProps.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.m_OptionPayloadList.clear();
        for (EncryptedKeyElement payload : encKeyList) {
            List keyDatas = payload.getReferenceElementList();
            ElementAttackProperties attackProps2 = payload.getAttackProperties();
            if (attackProps2.isSigned()) {
                attackProps2.setWrappingPayloadElement(payload.getEncryptedElement());
            }
            for (int j = 0; keyDatas.size() > j; ++j) {
                EncryptedDataElement encData = ((DataReferenceElement)keyDatas.get(j)).getRefEncData();
                ElementAttackProperties attackPropsData = encData.getAttackProperties();
                if (!attackPropsData.isSigned()) continue;
                attackPropsData.setWrappingPayloadElement(encData.getEncryptedElement());
            }
            attackProps2.addPropertyChangeListener((PropertyChangeListener)this);
            this.m_OptionPayloadList.add((AbstractEncryptionElement)payload);
        }
        for (EncryptedKeyElement payload : encDataList) {
            attackProps = payload.getAttackProperties();
            if (attackProps.isSigned()) {
                attackProps.setWrappingPayloadElement(payload.getEncryptedElement());
            }
            attackProps.addPropertyChangeListener((PropertyChangeListener)this);
            this.m_OptionPayloadList.add((AbstractEncryptionElement)payload);
        }
        this.m_OptionEncPays = new OptionPayloadEncryption(this.m_OptionPayloadList, this);
        this.m_OptionServerResponse = new OptionServerErrorBehaviour(this.m_AttackCfg, detectReport);
        this.m_OptionServerResponse.addPropertyChangeListener("serverBehave", this);
        if (null != this.m_OptionServerResponse) {
            this.m_OptionServerResponse.removePropertyChangeListener("serverBehave", this);
        }
        this.initAttackCfg();
    }

    public DetectionReport getDetectReport() {
        return this.m_DetectionManager.getDetectionReport();
    }

    public void noCurrentRequestcontent() {
        if (this.m_IsInProgress) {
            return;
        }
        this.m_IsInProgress = true;
        this.log().trace((Object)"No Current Message");
        if (null != this.m_DetectionManager) {
            this.m_DetectionManager.setInputFile(null);
        }
        this.clearOptions();
        this.m_IsInProgress = false;
    }

    private List<AbstractOption> addConfigOptions() {
        List<AbstractOption> result;
        if (this.getPlugin() == null) {
            this.log().debug((Object)"No plugin set?");
            result = Collections.emptyList();
        } else {
            ArrayList<AbstractOption> newOptions = new ArrayList<AbstractOption>();
            this.log().info((Object)"Adding OptionSoapAction");
            newOptions.add(0, (AbstractOption)this.m_OptionSoapAction);
            this.log().info((Object)"Adding OptionNoSchema");
            newOptions.add(1, (AbstractOption)this.m_OptionNoSchema);
            this.log().info((Object)"Adding OptionSchemaFiles");
            newOptions.add(2, (AbstractOption)this.m_OptionSchemaFiles);
            if (this.m_OptionPayloadList.size() > 0) {
                this.log().info((Object)"Adding Enc Pays ");
                newOptions.add(3, this.m_OptionEncPays);
                this.log().info((Object)"Adding Server Error Response table ");
                newOptions.add(4, this.m_OptionServerResponse);
            }
            result = newOptions;
        }
        return result;
    }

    public List<AbstractOption> popOptionsUpTo(AbstractOption needle) {
        AbstractOption last;
        ArrayList<AbstractOption> result = new ArrayList<AbstractOption>();
        PluginOptionContainer container = this.getPlugin().getPluginOptions();
        if (!container.contains(needle)) {
            return result;
        }
        while (container.size() > 0 && (last = container.getByIndex(container.size() - 1)) != needle) {
            container.remove(last);
            result.add(last);
        }
        this.log().info((Object)("Popped: " + ((Object)result).toString()));
        return result;
    }

    public void putOptions(List<AbstractOption> optionList) {
        this.log().info((Object)("Put: " + optionList.toString()));
        PluginOptionContainer container = this.getPlugin().getPluginOptions();
        for (int i = optionList.size() - 1; i >= 0; --i) {
            container.add(optionList.get(i));
        }
    }

    public void clearOptions() {
        if (this.getPlugin() == null) {
            this.log().debug((Object)"No plugin set?");
        } else {
            this.log().info((Object)"Clearing Options..");
            PluginOptionContainer container = this.getPlugin().getPluginOptions();
            while (container.size() > 0) {
                container.remove(container.getByIndex(0));
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        PluginOptionContainer container = this.getPlugin().getPluginOptions();
        if (pce.getSource() instanceof OptionPayloadEncryption) {
            this.m_Plugin.checkState();
        } else if (pce.getSource() == this.m_OptionSchemaFiles) {
            this.m_Plugin.setUsedSchemaFiles(this.m_OptionSchemaFiles.getFiles());
        } else if (pce.getSource() == this.m_OptionNoSchema) {
            this.log().info((Object)"Remove Schema Files Option");
            if (this.m_OptionNoSchema.isOn() && container.contains((AbstractOption)this.m_OptionSchemaFiles)) {
                container.remove((AbstractOption)this.m_OptionSchemaFiles);
                this.m_Plugin.setSchemaAnalyzerDepdingOnOption();
            } else if (!container.contains((AbstractOption)this.m_OptionSchemaFiles)) {
                this.log().info((Object)"Add Schema Files Option");
                container.add(1 + container.indexOf((AbstractOption)this.m_OptionNoSchema), (AbstractOption)this.m_OptionSchemaFiles);
            }
        }
        this.getPlugin().checkState();
    }

    public OptionSoapAction getOptionSoapAction() {
        return this.m_OptionSoapAction;
    }

    public AbstractOptionMultiFiles getOptionSchemaFiles() {
        return this.m_OptionSchemaFiles;
    }

    public OptionSimpleBoolean getOptionNoSchema() {
        return this.m_OptionNoSchema;
    }

    private DetectionManager handleDetection(Document attackDoc) {
        DetectionManager detectManager = null;
        detectManager = new DetectionManager(this.m_PipeLine, attackDoc);
        throw new RuntimeException("Uncompilable source code - Erroneous tree type: wsattacker.library.signatureWrapping.util.exception.InvalidPayloadException");
    }

    private void setPayload() {
        DetectionReport detectReport = this.m_DetectionManager.getDetectionReport();
        throw new RuntimeException("Uncompilable source code - Erroneous tree type: wsattacker.library.signatureWrapping.option.Payload");
    }

    static {
        throw new RuntimeException("Uncompilable source code - package wsattacker.library.signatureWrapping.option does not exist");
    }
}

