/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.dos.dosExtension.result;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import wsattacker.main.plugin.result.Result;
import wsattacker.main.plugin.result.ResultEntry;
import wsattacker.main.plugin.result.ResultLevel;
import wsattacker.plugin.dos.dosExtension.chart.ChartObject;
import wsattacker.plugin.dos.dosExtension.desktop.OpenURI;
import wsattacker.plugin.dos.dosExtension.logEntry.LogEntryRequest;
import wsattacker.plugin.dos.dosExtension.mvc.model.AttackModel;
import wsattacker.plugin.dos.dosExtension.zip.Zip;

public class ResultGenerator {
    private String fullPath;
    private String filenameReport;
    private final AttackModel attackModel;
    private ChartPanel chartPanel;

    public ResultGenerator(AttackModel attackModel) {
        this.attackModel = attackModel;
    }

    public AttackModel getAttackModel() {
        return this.attackModel;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public void setFullPath(String fullPath) {
        this.fullPath = fullPath;
    }

    public String getFilenameReport() {
        return this.filenameReport;
    }

    public void setFilenameReport(String filenameReport) {
        this.filenameReport = filenameReport;
    }

    public ChartPanel getJChartPanel() {
        return this.chartPanel;
    }

    public void setJChartPanel(ChartPanel JChartPanel) {
        this.chartPanel = JChartPanel;
    }

    public void openResults() {
        this.saveResult();
        if (this.fullPath != null && this.filenameReport != null) {
            File report = new File(this.fullPath, this.filenameReport);
            new OpenURI(report);
        } else {
            Result.getGlobalResult().add(new ResultEntry(ResultLevel.Critical, "attackModel", "No resultfiles found in the operating system specific temporary folder"));
        }
    }

    public void saveResult() {
        String attackName = "DOS";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HHmm");
        Date resultdate = new Date(this.attackModel.getTsAttackStop());
        String dateString = sdf.format(resultdate);
        String filenameUntampered = dateString + "_" + attackName + "_untamperedRequests.csv";
        String filenameTampered = dateString + "_" + attackName + "_tamperedRequests.csv";
        String filenameTestprobe = dateString + "_" + attackName + "_testprobeRequests.csv";
        String filenameMetadata = dateString + "_" + attackName + "_metaData.txt";
        String filenameImgGraph = dateString + "_" + attackName + "_graph.png";
        String filenameReport = dateString + "_" + attackName + "_results.html";
        String filenameZip = dateString + "_" + attackName + "_results.zip";
        String property = "java.io.tmpdir";
        String tempDir = System.getProperty(property);
        File resultDir = new File(tempDir + "/wsattackerdos");
        if (!resultDir.exists()) {
            resultDir.mkdir();
        }
        File file = new File(tempDir + "/wsattackerdos/" + dateString);
        file.mkdir();
        String fullPath = file.getAbsolutePath();
        try {
            File untamperedRequests = new File(fullPath, filenameUntampered);
            this.saveResponseTimeOfUntamperedRequests(untamperedRequests);
            File tamperedRequests = new File(fullPath, filenameTampered);
            this.saveResponseTimeOfTamperedRequests(tamperedRequests);
            File testRequests = new File(fullPath, filenameTestprobe);
            this.saveResponseTimeOfTestRequests(testRequests);
            File metadata = new File(fullPath, filenameMetadata);
            this.saveMetadata(metadata);
            this.saveFilelocationToReport(dateString, filenameUntampered, filenameTampered, filenameTestprobe, filenameMetadata, filenameImgGraph, filenameReport, filenameZip, fullPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        URL inputUrl = this.getClass().getResource("/IMG/ok.jpg");
        File dest = new File(fullPath + "/ok.jpg");
        try {
            FileUtils.copyURLToFile((URL)inputUrl, (File)dest);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            ChartObject chartObject = new ChartObject(this.attackModel);
            JFreeChart chart = chartObject.createOverlaidChart();
            ChartUtilities.saveChartAsPNG((File)new File(fullPath + filenameImgGraph), (JFreeChart)chart, (int)900, (int)700);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Zip.createZip(fullPath, filenameZip);
        this.setFullPath(fullPath);
        this.setFilenameReport(filenameReport);
    }

    private void saveResponseTimeOfUntamperedRequests(File untamperedRequests) throws IOException {
        FileWriter writer = new FileWriter(untamperedRequests);
        this.saveResponseTime(writer, this.attackModel.getLogListUntamperedRequests());
        writer.flush();
        writer.close();
    }

    private void saveResponseTimeOfTamperedRequests(File tamperedRequests) throws IOException {
        FileWriter writer = new FileWriter(tamperedRequests);
        this.saveResponseTime(writer, this.attackModel.getLogListTamperedRequests());
        writer.flush();
        writer.close();
    }

    private void saveResponseTimeOfTestRequests(File testRequests) throws IOException {
        FileWriter writer = new FileWriter(testRequests);
        this.saveResponseTime(writer, this.attackModel.getLogListTestProbeRequests());
        writer.flush();
        writer.close();
    }

    private void saveResponseTime(Writer writer, List<LogEntryRequest> responseTimes) throws IOException {
        for (LogEntryRequest logEntry : responseTimes) {
            writer.append(String.valueOf(logEntry.getTsReceived()));
            writer.append(',');
            writer.append(String.valueOf(logEntry.getTsSend()));
            writer.append(',');
            writer.append(String.valueOf(logEntry.getDuration()));
            writer.append(',');
            writer.append(String.valueOf(logEntry.getThreadNumber()));
            writer.append(',');
            writer.append(String.valueOf(logEntry.getFaultFlag()));
            writer.append(',');
            writer.append(String.valueOf(logEntry.getErrorFlag()));
            writer.append(',');
            writer.append(String.valueOf(logEntry.getResponseStringCsv()));
            writer.append('\n');
        }
    }

    private void saveMetadata(File metadata) throws IOException {
        FileWriter writer = new FileWriter(metadata);
        writer.append("+++++++++++++++++++++++++++\n");
        writer.append("Attack Summary\n");
        writer.append("+++++++++++++++++++++++++++\n");
        writer.append("attack Name: " + this.attackModel.getAttackName());
        writer.append("\n\n");
        writer.append("Attack Description:\n");
        writer.append("-------------------\n");
        writer.append(this.attackModel.getAttackDescription());
        writer.append("\n\n");
        writer.append("Attack Countermeasures:\n");
        writer.append("-----------------------\n");
        writer.append(this.attackModel.getAttackCountermeasures());
        writer.append("\n\n");
        writer.append("+++++++++++++++++++++++++++\n");
        writer.append("Attack Metadata:");
        writer.append("\n\n");
        writer.append("Attack start: " + this.attackModel.getStartDate() + "\n" + "Attack stop: " + this.attackModel.getStopDate() + "\n" + "Parallel threads: " + this.attackModel.getNumberThreads() + "\n" + "Requests per thread: " + this.attackModel.getNumberRequestsPerThread() + "\n" + "Request repeat interval: " + this.attackModel.getSecondsBetweenRequests() + " ms\n" + "Server recovery time: " + this.attackModel.getSecondsServerLoadRecovery() / 1000 + " sec\n" + "Send testprobes: " + this.attackModel.getCounterProbesSend() + "\n" + "Testprobe repeat interval: " + this.attackModel.getSecondsBetweenProbes() + " ms\n" + "Size testprobe request: " + this.attackModel.getRequestSizeTestProbe() + " Bytes\n" + "Size untampered request: " + this.attackModel.getRequestSizeUntampered() + " Bytes\n" + "Size tampered request: " + this.attackModel.getRequestSizeTampered() + " Bytes\n" + "Size untampered padded request: " + this.attackModel.getRequestSizePaddedUntampered() + " Bytes\n" + "Size tampered padded request: " + this.attackModel.getRequestSizePaddedTampered() + " Bytes\n" + "Median response time untampered requests: " + this.attackModel.getMedianUntampered() + " ms\n" + "Median response time tampered requests: " + this.attackModel.getMedianTampered() + " ms\n" + "Auto finialize attack switch: " + this.attackModel.isAutoFinalizeSwitch() + "\n" + "Auto finialize attack duration: " + this.attackModel.getAutoFinalizeSeconds() + " seconds\n" + "\n");
        writer.append("Custom Attack parameters: \n");
        writer.append(this.attackModel.getCustomAttackParameters());
        writer.append("\n\n");
        writer.append("+++++++++++++++++++++++++++\n");
        writer.append("Attack Success Metric - see help file for more info:");
        writer.append("\n\n");
        writer.append("Attack roundtrip time ratio: " + this.attackModel.getAttackRoundtripTimeRatio() + " Points - " + this.attackModel.getAttackRoundtripTimeRatioDescription("text"));
        writer.append("\n\n");
        writer.append("Request size ratio: " + this.attackModel.getAttackRatioRequestsize() + " Points - " + this.attackModel.getAttackRatioRequestsizeDescription("text"));
        writer.append("\n\n");
        writer.append("testprobe roundtrip time after attack (length " + this.attackModel.getAttackLongevitySeconds() + " sec): " + this.attackModel.getTestProbeAttackRoundtripTime() + " seconds - " + this.attackModel.getTestProbeAttackRoundtripTimeDescription("text"));
        writer.append("\n\n");
        writer.append("+++++++++++++++++++++++++++\n");
        writer.append("Requests:");
        writer.append("\n\n");
        writer.append("target Endpoint: " + this.attackModel.getWsdlUrl());
        writer.append("\n\n");
        writer.append("Testprobe Request:\n");
        writer.append("------------------\n");
        for (String key : this.attackModel.getOriginalRequestHeaderFields().keySet()) {
            String value = this.attackModel.getOriginalRequestHeaderFields().get(key).toString();
            writer.append(key).append(": ").append(value).append("\n");
        }
        writer.append("\n");
        writer.append(this.attackModel.getWsdlRequestOriginal().getRequestContent());
        writer.append("\n\n");
        writer.append("Untampered Request:\n");
        writer.append("-------------------\n");
        writer.append(this.attackModel.getUntamperedRequestObject().getHeaderString("\n"));
        writer.append("\n");
        writer.append(this.attackModel.getUntamperedRequestObject().getXmlMessage());
        writer.append("\n\n");
        writer.append("Tampered Request:\n");
        writer.append("-----------------\n");
        writer.append(this.attackModel.getTamperedRequestObject().getHeaderString("\n"));
        writer.append("\n");
        writer.append(this.attackModel.getTamperedRequestObject().getXmlMessage());
        writer.flush();
        writer.close();
    }

    private void saveFilelocationToReport(String dateString, String filenameUntampered, String filenameTampered, String filenameTestprobe, String filenameMetadata, String filenameImgGraph, String filenameReport, String filenameZip, String fullPath) throws IOException {
        String htmlString = "<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" /></head><body><h1>Attack Report for '" + this.attackModel.getAttackName() + "' - created: " + dateString + "</h1>" + "<p><img src='ok.jpg'/>Attack report generated succesfully</p>" + "<p>The attack report is provided in the following files: " + "<ul>" + "<li><a href='" + filenameMetadata + "'>Attack Summary</a></li>" + "<li><a href='" + filenameImgGraph + "'>Attackgraph via PNG</a></li>" + "<li><a href='" + filenameUntampered + "'>CSV-Dataset Untampered-Requests</a></li>" + "<li><a href='" + filenameTampered + "'>CSV-Dataset Tampered-Requests</a></li>" + "<li><a href='" + filenameTestprobe + "'>CSV-Dataset Testprobe-Requests</a></li>" + "</ul>" + "<p>compressed Version as zip <a href='" + filenameZip + "'>results.zip</a></p>" + "</body>" + "</html>";
        File file = new File(fullPath, filenameReport);
        FileWriter writer = new FileWriter(file);
        writer.append(htmlString);
        writer.flush();
        writer.close();
    }

    public void openHelpmenu() {
        String property = "java.io.tmpdir";
        String tempDir = System.getProperty(property);
        File resultDir = new File(tempDir + "/wsattackerdos");
        if (!resultDir.exists()) {
            resultDir.mkdir();
        }
        URL inputUrl = this.getClass().getResource("/HTML/help.html");
        File dest = new File(resultDir + "/help.html");
        URL inputUrl2 = this.getClass().getResource("/IMG/guiResult.png");
        File dest2 = new File(resultDir + "/guiResult.png");
        URL inputUrl3 = this.getClass().getResource("/IMG/architecture.png");
        File dest3 = new File(resultDir + "/architecture.png");
        try {
            FileUtils.copyURLToFile((URL)inputUrl, (File)dest);
            FileUtils.copyURLToFile((URL)inputUrl2, (File)dest2);
            FileUtils.copyURLToFile((URL)inputUrl3, (File)dest3);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        File report = new File(resultDir, "help.html");
        new OpenURI(report);
    }
}

