/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.signatureWrapping.xpath.weakness.util;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import wsattacker.library.signatureWrapping.util.exception.InvalidWeaknessException;
import wsattacker.library.signatureWrapping.xpath.parts.Step;
import wsattacker.library.xmlutilities.dom.DomUtilities;
import wsattacker.library.xmlutilities.namespace.NamespaceResolver;

public final class XPathWeaknessTools {
    private static final Logger LOG = Logger.getLogger(XPathWeaknessTools.class);

    public static Element createPayloadPostPart(Element signedPostPart, Element signedElement, Element payloadElement) {
        Element payloadPostPart;
        if (signedElement == signedPostPart) {
            return payloadElement;
        }
        ArrayList<Element> parentElements = new ArrayList<Element>();
        ArrayList<Integer> parentIndex = new ArrayList<Integer>();
        for (Node theParent = signedElement; theParent != null && theParent.getNodeType() == 1 && theParent != signedPostPart; theParent = theParent.getParentNode()) {
            parentElements.add((Element)theParent);
            parentIndex.add(DomUtilities.getElementIndex((Element)theParent));
        }
        Element tmp = payloadPostPart = (Element)signedPostPart.cloneNode(true);
        for (int i = parentElements.size() - 1; i >= 0; --i) {
            Element child = (Element)parentElements.get(i);
            int index = (Integer)parentIndex.get(i);
            List children = DomUtilities.findChildren((Node)tmp, (String)child.getLocalName(), (String)child.getNamespaceURI());
            tmp = (Element)children.get(index - 1);
        }
        tmp.getParentNode().replaceChild(payloadElement, tmp);
        return payloadPostPart;
    }

    public static Element detectHashedPostTree(Element signedElement, String postXPath) {
        Element signedPostPart = signedElement;
        Node signedPostPartParent = signedPostPart.getParentNode();
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        Document ownerDocument = signedElement.getOwnerDocument();
        NamespaceResolver nsr = new NamespaceResolver(ownerDocument);
        xpath.setNamespaceContext((NamespaceContext)nsr);
        XPathExpression expr = null;
        try {
            expr = xpath.compile(postXPath);
        }
        catch (XPathExpressionException e1) {
            LOG.warn((Object)("No valid PostXPath: " + postXPath));
            return null;
        }
        while (signedPostPartParent != null && signedPostPartParent.getNodeType() == 1) {
            NodeList nodes;
            try {
                nodes = (NodeList)expr.evaluate(signedPostPartParent, XPathConstants.NODESET);
            }
            catch (XPathExpressionException e) {
                continue;
            }
            if (nodes.getLength() == 1) {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)("Matched with postXPath from Element: " + signedPostPart.getNodeName()));
                break;
            }
            signedPostPart = (Element)signedPostPartParent;
            signedPostPartParent = signedPostPart.getParentNode();
        }
        return signedPostPart;
    }

    public static List<Element> getSignedPostPart(Step step, Element signedElement) throws InvalidWeaknessException {
        List matchList;
        String xpath = step.getPreXPath() + "/" + step.getStep();
        if (xpath.equals("/")) {
            throw new InvalidWeaknessException("Reached root of Document.");
        }
        try {
            matchList = DomUtilities.evaluateXPath((Document)signedElement.getOwnerDocument(), (String)xpath);
        }
        catch (XPathExpressionException e) {
            LOG.warn((Object)e.getLocalizedMessage());
            throw new InvalidWeaknessException(e);
        }
        if (matchList.isEmpty()) {
            throw new InvalidWeaknessException("XPath does not match any Element");
        }
        ArrayList<Element> haveSignedDecendant = new ArrayList<Element>();
        for (Element match : matchList) {
            if (XPathWeaknessTools.isAncestorOf(match, signedElement) < 0) continue;
            haveSignedDecendant.add(match);
        }
        return haveSignedDecendant;
    }

    public static int isAncestorOf(Element ancestor, Element maybeChild) {
        int ret = -1;
        if (ancestor == maybeChild) {
            ret = 0;
        }
        Node parent = maybeChild.getParentNode();
        int i = 1;
        while (parent != null && parent != ancestor) {
            parent = parent.getParentNode();
            ++i;
        }
        if (parent == ancestor) {
            ret = i;
        }
        return ret;
    }

    private XPathWeaknessTools() {
    }
}

