/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.signatureWrapping.xpath.parts.util;

import java.util.List;
import wsattacker.library.signatureWrapping.xpath.interfaces.XPathPartInterface;

public final class XPathInspectorTools {
    public static int nextChar(String s, char needle, int startIndex) {
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        for (int i = startIndex; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!inSingleQuote && !inDoubleQuote && c == needle) {
                return i;
            }
            if (!inSingleQuote && c == '\"') {
                inDoubleQuote ^= true;
                continue;
            }
            if (inDoubleQuote || c != '\'') continue;
            inSingleQuote ^= true;
        }
        return -1;
    }

    public static int nextString(String s, String needle, int startIndex) {
        int next;
        char[] n = needle.toCharArray();
        do {
            int i;
            block3: {
                next = XPathInspectorTools.nextChar(s, n[0], startIndex);
                for (i = 1; i < n.length; ++i) {
                    if (XPathInspectorTools.nextChar(s, n[i], next + i) == next + i) {
                        continue;
                    }
                    break block3;
                }
                return next;
            }
            startIndex = next + i;
        } while (next >= 0);
        return next;
    }

    public static String implodeList(List<? extends XPathPartInterface> list) {
        return XPathInspectorTools.implodeList(list, "", "", "");
    }

    public static String implodeList(List<? extends XPathPartInterface> list, String implode) {
        return XPathInspectorTools.implodeList(list, implode, "", "");
    }

    public static String implodeList(List<? extends XPathPartInterface> list, String implode, String before, String after) {
        StringBuilder buf = new StringBuilder();
        if (list.size() > 0) {
            buf.append(before).append(list.get(0).toFullString()).append(after);
        }
        for (int i = 1; i < list.size(); ++i) {
            buf.append("/").append(before).append(list.get(i).toFullString()).append(after);
        }
        return buf.toString();
    }

    private XPathInspectorTools() {
    }
}

