/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.signatureWrapping.xpath.parts.predicate.concrete;

import java.util.regex.Pattern;
import wsattacker.library.signatureWrapping.util.exception.InvalidTypeException;
import wsattacker.library.signatureWrapping.xpath.parts.predicate.AndExpression;

public class PositionAndExpression
extends AndExpression {
    private String function = "";
    private int position = -1;
    private String positonFunction = "";

    public PositionAndExpression(String expression) throws InvalidTypeException {
        super(expression);
        String POSITION = "position()=";
        String LAST = "last()";
        if (expression.startsWith("position()=")) {
            this.function = "position()=".substring(0, "position()=".length() - 1);
            expression = this.positonFunction = expression.substring("position()=".length()).trim();
        }
        if (this.isPosition(expression)) {
            try {
                this.position = Integer.parseInt(expression);
            }
            catch (NumberFormatException e) {
                throw new InvalidTypeException();
            }
        } else if (expression.startsWith("last()")) {
            this.positonFunction = expression;
        }
        if (this.position < 1 && this.positonFunction.isEmpty()) {
            throw new InvalidTypeException();
        }
    }

    public boolean isPosition(String s) {
        Pattern positionPattern = Pattern.compile("^[1-9][0-9]*$");
        return positionPattern.matcher(s).find();
    }

    public String getFunction() {
        return this.function;
    }

    public int getPosition() {
        return this.position;
    }

    public String getPositonFunction() {
        return this.positonFunction;
    }

    public boolean isSimpleIndex() {
        return this.position > 0;
    }
}

