/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.signatureWrapping.xpath.parts.axis;

import wsattacker.library.signatureWrapping.xpath.interfaces.XPathPartInterface;
import wsattacker.library.signatureWrapping.xpath.parts.axis.AxisName;
import wsattacker.library.signatureWrapping.xpath.parts.axis.NodeName;
import wsattacker.library.signatureWrapping.xpath.parts.axis.NodeType;

public class AxisSpecifier
implements XPathPartInterface {
    private final String axisSpecifier;
    private AxisName axisName;
    private NodeType nodeType;
    private NodeName nodeName;

    public AxisSpecifier(String axisSpecifier) {
        this.axisSpecifier = axisSpecifier;
        this.eval();
    }

    public String getAxisSpecifier() {
        return this.axisSpecifier;
    }

    public AxisName getAxisName() {
        return this.axisName;
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public NodeName getNodeName() {
        return this.nodeName;
    }

    public String toString() {
        return this.axisSpecifier;
    }

    @Override
    public String toFullString() {
        return this.axisName.toFullString() + "::" + (this.nodeName != null ? this.nodeName.toFullString() : this.nodeType.toFullString());
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof String) {
            result = this.equals(new AxisSpecifier((String)o));
        }
        if (o instanceof AxisSpecifier) {
            AxisSpecifier ax = (AxisSpecifier)o;
            result |= ax.getNodeName() == this.getNodeName() || ax.getNodeName() != null && this.getNodeName() != null && ax.getNodeName().equals(this.getNodeName());
            result &= ax.getNodeType() == this.getNodeType() || ax.getNodeType() != null && this.getNodeType() != null && ax.getNodeType().equals(this.getNodeType());
            result &= ax.getAxisName().equals(this.getAxisName());
        }
        return result;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.axisSpecifier != null ? this.axisSpecifier.hashCode() : 0);
        return hash;
    }

    private void eval() {
        this.nodeName = null;
        this.nodeType = null;
        int start = 0;
        if (this.axisSpecifier.isEmpty()) {
            this.axisName = new AxisName("descendant-or-self");
            this.nodeType = new NodeType("node()");
            return;
        }
        if (this.axisSpecifier.equals("..")) {
            this.axisName = new AxisName("parent");
            this.nodeType = new NodeType("node()");
            return;
        }
        if (this.axisSpecifier.equals(".")) {
            this.axisName = new AxisName("self");
            this.nodeType = new NodeType("node()");
            return;
        }
        if (this.axisSpecifier.contains("::")) {
            start = this.axisSpecifier.indexOf("::");
            String axisName = this.axisSpecifier.substring(0, start);
            this.axisName = new AxisName(axisName);
            start += 2;
        } else if (this.axisSpecifier.charAt(0) == '@') {
            this.axisName = new AxisName("@");
            start = 1;
        } else {
            this.axisName = new AxisName("child");
        }
        String rest = this.axisSpecifier.substring(start);
        if (rest.equals("*")) {
            this.nodeType = new NodeType("*");
        } else if (rest.indexOf(40) > 0) {
            this.nodeType = new NodeType(rest);
        } else {
            this.nodeName = new NodeName(rest);
        }
    }
}

