/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.signatureWrapping.util.signature;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import wsattacker.library.signatureWrapping.util.signature.SignatureElement;
import wsattacker.library.signatureWrapping.util.signature.SignatureManager;
import wsattacker.library.xmlutilities.dom.DomUtilities;

public class SignatureRemover {
    Document doc;
    SignatureManager signatureManager;
    private String xmlWithoutSignature;

    public SignatureRemover(String xml) throws IllegalArgumentException {
        try {
            this.doc = DomUtilities.stringToDom((String)xml);
        }
        catch (SAXException ex) {
            throw new IllegalArgumentException("Could not Parse XML Document");
        }
        this.signatureManager = new SignatureManager();
        this.signatureManager.setDocument(this.doc);
        if (this.signatureManager.getSignatureElements().isEmpty()) {
            throw new IllegalArgumentException("XML Document does not contain any XML Signature");
        }
    }

    public SignatureRemover(Document xmlDoc) throws IllegalArgumentException {
        this.doc = DomUtilities.createNewDomFromNode((Node)xmlDoc);
        this.signatureManager = new SignatureManager();
        this.signatureManager.setDocument(this.doc);
        if (this.signatureManager.getSignatureElements().isEmpty()) {
            throw new IllegalArgumentException("XML Document does not contain any XML Signature");
        }
    }

    public String getXmlWithoutSignature() {
        if (this.xmlWithoutSignature == null) {
            for (SignatureElement signature : this.signatureManager.getSignatureElements()) {
                Element element = signature.getSignature();
                if (element.getParentNode() == null) continue;
                element.getParentNode().removeChild(element);
            }
            this.xmlWithoutSignature = DomUtilities.domToString((Document)this.doc);
        }
        return this.xmlWithoutSignature;
    }
}

