/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.signatureWrapping.util.signature;

import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import wsattacker.library.signatureWrapping.option.Payload;
import wsattacker.library.signatureWrapping.option.PayloadOrderingHelper;
import wsattacker.library.signatureWrapping.util.signature.ReferenceElement;
import wsattacker.library.signatureWrapping.util.signature.SignatureElement;
import wsattacker.library.signatureWrapping.util.signature.XPathElement;
import wsattacker.library.xmlutilities.dom.DomUtilities;

public class SignatureManager {
    private Document doc;
    private final List<SignatureElement> sigList = new ArrayList<SignatureElement>();

    public void setDocument(Document doc) {
        this.doc = doc;
        this.eval();
    }

    public Document getDocument() {
        return this.doc;
    }

    public List<SignatureElement> getSignatureElements() {
        return this.sigList;
    }

    private Logger log() {
        return Logger.getLogger(this.getClass());
    }

    private synchronized void eval() {
        this.sigList.clear();
        if (this.doc != null) {
            List signatureList = new ArrayList();
            try {
                signatureList = DomUtilities.evaluateXPath((Document)this.doc, (String)"//*[local-name()='Signature' and namespace-uri()='http://www.w3.org/2000/09/xmldsig#']");
            }
            catch (XPathExpressionException ex) {
                this.log().error((Object)"Could not find any ds:Signature Elements.");
            }
            for (Element signature : signatureList) {
                this.log().trace((Object)("Found Signature Element " + DomUtilities.getFastXPath((Node)signature)));
                this.sigList.add(new SignatureElement(signature));
            }
        }
    }

    public List<Payload> getPayloads() {
        ArrayList<Payload> payloadList = new ArrayList<Payload>();
        for (SignatureElement signature : this.getSignatureElements()) {
            for (ReferenceElement ref : signature.getReferences()) {
                if (ref.getPayload() != null) {
                    payloadList.add(ref.getPayload());
                    continue;
                }
                for (XPathElement xpath : ref.getXPaths()) {
                    for (Payload option : xpath.getPayloads()) {
                        payloadList.add(option);
                    }
                }
            }
        }
        PayloadOrderingHelper.orderOuterToInner(payloadList);
        return payloadList;
    }
}

