/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.signatureWrapping.util.signature;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import wsattacker.library.signatureWrapping.util.signature.ReferenceElement;
import wsattacker.library.xmlutilities.dom.DomUtilities;

public class SignatureElement {
    private final Element signature;
    private List<ReferenceElement> references;

    public SignatureElement(Element signature) {
        this.signature = signature;
        List signedInfo = DomUtilities.findChildren((Node)signature, (String)"SignedInfo", (String)"http://www.w3.org/2000/09/xmldsig#");
        if (signedInfo.size() == 1) {
            this.log().trace((Object)"Searching for Reference Elements");
            List list = DomUtilities.findChildren((Node)((Node)signedInfo.get(0)), (String)"Reference", (String)"http://www.w3.org/2000/09/xmldsig#");
            this.references = new ArrayList<ReferenceElement>();
            for (Element ele : list) {
                this.references.add(new ReferenceElement(ele));
            }
            this.log().trace((Object)("Found: " + this.references));
        }
    }

    public Element getSignature() {
        return this.signature;
    }

    private Logger log() {
        return Logger.getLogger(this.getClass());
    }

    public List<ReferenceElement> getReferences() {
        return this.references;
    }

    public boolean equals(Object o) {
        if (o instanceof SignatureElement) {
            SignatureElement sig = (SignatureElement)o;
            return sig.getReferences().equals(this.getReferences());
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + (this.references != null ? this.references.hashCode() : 0);
        return hash;
    }
}

