/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.signatureWrapping.option;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.ParseException;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import wsattacker.library.signatureWrapping.util.exception.InvalidPayloadException;
import wsattacker.library.signatureWrapping.util.signature.ReferringElementInterface;
import wsattacker.library.signatureWrapping.util.timestamp.TimestampUpdateHelper;
import wsattacker.library.xmlutilities.dom.DomUtilities;

public class Payload {
    public static final String PROP_TIMESTAMP = "timestamp";
    public static final String PROP_WRAPONLY = "wrapOnly";
    public static final String PROP_PAYLOADELEMENT = "payloadElement";
    public static final String PROP_SIGNEDELEMENT = "signedElement";
    public static final String PROP_REFERRINGELEMENT = "referringElement";
    private static final Logger LOG = Logger.getLogger(Payload.class);
    private static final long serialVersionUID = 2L;
    private static final String ASSERTION = "Assertion";
    private static final String CONDITIONS = "Conditions";
    private static final String NOTBEFORE = "NotBefore";
    private static final String NOTONORAFTER = "NotOnOrAfter";
    private boolean timestamp = false;
    private boolean wrapOnly = false;
    private Element payloadElement;
    private Element signedElement;
    private ReferringElementInterface referringElement;
    private final transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public Payload() {
    }

    public Payload(ReferringElementInterface referringElement, Element signedElement) {
        this.setReferringElement(referringElement);
        this.setSignedElement(signedElement);
    }

    public boolean hasPayload() {
        boolean hasPayload = true;
        if (this.payloadElement == null) {
            hasPayload = false;
        } else if (this.payloadElement.isEqualNode(this.signedElement)) {
            hasPayload = false;
        }
        return hasPayload;
    }

    public Element getPayloadElement() throws InvalidPayloadException {
        Element retr = this.payloadElement;
        if (this.timestamp) {
            Element timestamp = (Element)this.signedElement.cloneNode(true);
            if (timestamp.getLocalName().equals("Timestamp")) {
                TimestampUpdateHelper helper;
                String warning;
                Node createdElement = null;
                Node expiresElement = null;
                for (Node cur = timestamp.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
                    if (cur.getNodeType() != 1) continue;
                    if ("Created".equals(cur.getLocalName()) && "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd".equals(cur.getNamespaceURI())) {
                        createdElement = (Element)cur;
                        continue;
                    }
                    if (!"Expires".equals(cur.getLocalName()) || !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd".equals(cur.getNamespaceURI())) continue;
                    expiresElement = (Element)cur;
                }
                if (createdElement == null) {
                    warning = "Could not find Created Element in Timestamp";
                    LOG.warn((Object)warning);
                    throw new InvalidPayloadException(warning);
                }
                if (expiresElement == null) {
                    warning = "Could not find Expires Element in Timestamp";
                    LOG.warn((Object)warning);
                    throw new InvalidPayloadException(warning);
                }
                try {
                    helper = new TimestampUpdateHelper(createdElement.getTextContent(), expiresElement.getTextContent());
                }
                catch (ParseException ex) {
                    String warning2 = "Timestampformat could not be handled";
                    LOG.warn((Object)warning2);
                    throw new InvalidPayloadException(warning2);
                }
                createdElement.setTextContent(helper.getStart());
                expiresElement.setTextContent(helper.getEnd());
                retr = timestamp;
            } else if (timestamp.getLocalName().equals(ASSERTION)) {
                TimestampUpdateHelper helper;
                List conditionElementList = DomUtilities.findChildren((Node)timestamp, (String)CONDITIONS, null);
                if (conditionElementList.isEmpty()) {
                    String warning = "Could not find the Element <Conditions/>";
                    LOG.warn((Object)warning);
                    throw new InvalidPayloadException(warning);
                }
                if (conditionElementList.size() > 1) {
                    String warning = "There are " + conditionElementList.size() + " <" + CONDITIONS + "/> Elements";
                    LOG.warn((Object)warning);
                    throw new InvalidPayloadException(warning);
                }
                Element conditionElement = (Element)conditionElementList.get(0);
                Attr notBefore = conditionElement.getAttributeNode(NOTBEFORE);
                if (notBefore == null) {
                    String warning = "Could not find 'NotBefore' Attribute";
                    LOG.warn((Object)warning);
                    throw new InvalidPayloadException(warning);
                }
                Attr notOnOrAfter = conditionElement.getAttributeNode(NOTONORAFTER);
                if (notOnOrAfter == null) {
                    String warning = "Could not find 'NotOnOrAfter' Attribute";
                    LOG.warn((Object)warning);
                    throw new InvalidPayloadException(warning);
                }
                try {
                    helper = new TimestampUpdateHelper(notBefore.getTextContent(), notOnOrAfter.getTextContent());
                }
                catch (ParseException ex) {
                    String warning = "Timestampformat could not be handled";
                    LOG.warn((Object)warning);
                    throw new InvalidPayloadException(warning);
                }
                notBefore.setTextContent(helper.getStart());
                notOnOrAfter.setTextContent(helper.getEnd());
                retr = timestamp;
            }
        }
        return retr;
    }

    public Element getSignedElement() {
        return this.signedElement;
    }

    public ReferringElementInterface getReferringElement() {
        return this.referringElement;
    }

    public boolean isTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(boolean timestamp) {
        this.log().trace((Object)("Payload.setTimestamp() setTimestamp = " + timestamp));
        boolean oldTimestamp = this.timestamp;
        this.timestamp = timestamp;
        this.propertyChangeSupport.firePropertyChange(PROP_TIMESTAMP, oldTimestamp, timestamp);
    }

    public void setPayloadElement(Element payloadElement) {
        Element oldPayloadElement = this.payloadElement;
        this.payloadElement = payloadElement;
        this.propertyChangeSupport.firePropertyChange(PROP_PAYLOADELEMENT, oldPayloadElement, payloadElement);
    }

    public void setSignedElement(Element signedElement) {
        Element oldSignedElement = this.signedElement;
        this.signedElement = signedElement;
        this.propertyChangeSupport.firePropertyChange(PROP_SIGNEDELEMENT, oldSignedElement, signedElement);
        if (signedElement != null) {
            this.setPayloadElement((Element)signedElement.cloneNode(true));
            this.setTimestamp(this.detectTimestamp());
        }
    }

    public void setReferringElement(ReferringElementInterface referringElement) {
        ReferringElementInterface oldReferringElement = this.referringElement;
        this.referringElement = referringElement;
        this.propertyChangeSupport.firePropertyChange(PROP_REFERRINGELEMENT, oldReferringElement, referringElement);
    }

    private Logger log() {
        return Logger.getLogger(this.getClass());
    }

    public boolean isValid(String value) {
        boolean isValid = true;
        if (value.length() >= 3) {
            try {
                DomUtilities.stringToDom((String)value);
            }
            catch (Exception e) {
                this.log().error((Object)("Payload.isValid() Error: " + e.getLocalizedMessage()));
                isValid = false;
            }
        }
        return isValid;
    }

    public void setValue(String value) throws IllegalArgumentException {
        if (this.isValid(value)) {
            try {
                this.setPayloadElement(DomUtilities.stringToDom((String)value).getDocumentElement());
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
            this.log().info((Object)("Has payload? " + this.hasPayload()));
        }
    }

    public void removeValue() throws IllegalArgumentException {
        this.setPayloadElement(this.signedElement);
        this.log().info((Object)("Has payload? " + this.hasPayload()));
    }

    private boolean detectTimestamp() {
        boolean isT = this.signedElement.getLocalName().equals("Timestamp");
        return isT;
    }

    public String getValue() {
        return DomUtilities.domToString((Node)this.payloadElement);
    }

    public boolean isWrapOnly() {
        return this.wrapOnly;
    }

    public void setWrapOnly(boolean wrapOnly) {
        boolean oldWrapOnly = this.wrapOnly;
        this.wrapOnly = wrapOnly;
        this.propertyChangeSupport.firePropertyChange(PROP_WRAPONLY, oldWrapOnly, wrapOnly);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Payload{");
        sb.append("signedElement=").append(this.signedElement);
        sb.append(", payloadElement=").append(this.payloadElement);
        sb.append(", referringElement=").append(this.referringElement);
        sb.append(", timestamp=").append(this.timestamp);
        sb.append(", wrapOnly=").append(this.wrapOnly);
        sb.append('}');
        return sb.toString();
    }
}

