/*
 * Decompiled with CFR 0.152.
 */
package flex.management.runtime.messaging.services.messaging;

import flex.management.BaseControl;
import flex.management.runtime.messaging.services.messaging.ThrottleManagerControlMBean;
import flex.messaging.services.messaging.ThrottleManager;
import java.util.Date;

public class ThrottleManagerControl
extends BaseControl
implements ThrottleManagerControlMBean {
    private ThrottleManager throttleManager;
    private long clientIncomingMessageThrottleStart;
    private int clientIncomingMessageThrottleCount;
    private Date lastClientIncomingMessageThrottleTimestamp;
    private long clientOutgoingMessageThrottleStart;
    private int clientOutgoingMessageThrottleCount;
    private Date lastClientOutgoingMessageThrottleTimestamp;
    private long destinationIncomingMessageThrottleStart;
    private int destinationIncomingMessageThrottleCount;
    private Date lastDestinationIncomingMessageThrottleTimestamp;
    private long destinationOutgoingMessageThrottleStart;
    private int destinationOutgoingMessageThrottleCount;
    private Date lastDestinationOutgoingMessageThrottleTimestamp;

    public ThrottleManagerControl(ThrottleManager throttleManager, BaseControl parent) {
        super(parent);
        this.throttleManager = throttleManager;
        this.clientOutgoingMessageThrottleStart = this.clientIncomingMessageThrottleStart = System.currentTimeMillis();
        this.destinationIncomingMessageThrottleStart = this.clientIncomingMessageThrottleStart;
        this.destinationOutgoingMessageThrottleStart = this.clientIncomingMessageThrottleStart;
    }

    protected void onRegistrationComplete() {
        String name = this.getObjectName().getCanonicalName();
        String[] attributes = new String[]{"ClientIncomingMessageThrottleCount", "ClientIncomingMessageThrottleFrequency", "ClientOutgoingMessageThrottleCount", "ClientOutgoingMessageThrottleFrequency", "DestinationIncomingMessageThrottleCount", "DestinationIncomingMessageThrottleFrequency", "DestinationOutgoingMessageThrottleCount", "DestinationOutgoingMessageThrottleFrequency", "LastClientIncomingMessageThrottleTimestamp", "LastClientOutgoingMessageThrottleTimestamp", "LastDestinationIncomingMessageThrottleTimestamp", "LastDestinationOutgoingMessageThrottleTimestamp"};
        this.getRegistrar().registerObjects(151, name, attributes);
    }

    public String getId() {
        return this.throttleManager.getId();
    }

    public String getType() {
        return "ThrottleManager";
    }

    public Integer getClientIncomingMessageThrottleCount() {
        return new Integer(this.clientIncomingMessageThrottleCount);
    }

    public void incrementClientIncomingMessageThrottleCount() {
        ++this.clientIncomingMessageThrottleCount;
        this.lastClientIncomingMessageThrottleTimestamp = new Date();
    }

    public void resetClientIncomingMessageThrottleCount() {
        this.clientIncomingMessageThrottleStart = System.currentTimeMillis();
        this.clientIncomingMessageThrottleCount = 0;
        this.lastClientIncomingMessageThrottleTimestamp = null;
    }

    public Date getLastClientIncomingMessageThrottleTimestamp() {
        return this.lastClientIncomingMessageThrottleTimestamp;
    }

    public Double getClientIncomingMessageThrottleFrequency() {
        if (this.clientIncomingMessageThrottleCount > 0) {
            double runtime = this.differenceInMinutes(this.clientIncomingMessageThrottleStart, System.currentTimeMillis());
            return new Double((double)this.clientIncomingMessageThrottleCount / runtime);
        }
        return new Double(0.0);
    }

    public Integer getClientOutgoingMessageThrottleCount() {
        return new Integer(this.clientOutgoingMessageThrottleCount);
    }

    public void incrementClientOutgoingMessageThrottleCount() {
        ++this.clientOutgoingMessageThrottleCount;
        this.lastClientOutgoingMessageThrottleTimestamp = new Date();
    }

    public void resetClientOutgoingMessageThrottleCount() {
        this.clientOutgoingMessageThrottleStart = System.currentTimeMillis();
        this.clientOutgoingMessageThrottleCount = 0;
        this.lastClientOutgoingMessageThrottleTimestamp = null;
    }

    public Date getLastClientOutgoingMessageThrottleTimestamp() {
        return this.lastClientOutgoingMessageThrottleTimestamp;
    }

    public Double getClientOutgoingMessageThrottleFrequency() {
        if (this.clientOutgoingMessageThrottleCount > 0) {
            double runtime = this.differenceInMinutes(this.clientOutgoingMessageThrottleStart, System.currentTimeMillis());
            return new Double((double)this.clientOutgoingMessageThrottleCount / runtime);
        }
        return new Double(0.0);
    }

    public Integer getDestinationIncomingMessageThrottleCount() {
        return new Integer(this.destinationIncomingMessageThrottleCount);
    }

    public void incrementDestinationIncomingMessageThrottleCount() {
        ++this.destinationIncomingMessageThrottleCount;
        this.lastDestinationIncomingMessageThrottleTimestamp = new Date();
    }

    public void resetDestinationIncomingMessageThrottleCount() {
        this.destinationIncomingMessageThrottleStart = System.currentTimeMillis();
        this.destinationIncomingMessageThrottleCount = 0;
        this.lastDestinationIncomingMessageThrottleTimestamp = null;
    }

    public Date getLastDestinationIncomingMessageThrottleTimestamp() {
        return this.lastDestinationIncomingMessageThrottleTimestamp;
    }

    public Double getDestinationIncomingMessageThrottleFrequency() {
        if (this.destinationIncomingMessageThrottleCount > 0) {
            double runtime = this.differenceInMinutes(this.destinationIncomingMessageThrottleStart, System.currentTimeMillis());
            return new Double((double)this.destinationIncomingMessageThrottleCount / runtime);
        }
        return new Double(0.0);
    }

    public Integer getDestinationOutgoingMessageThrottleCount() {
        return new Integer(this.destinationOutgoingMessageThrottleCount);
    }

    public void incrementDestinationOutgoingMessageThrottleCount() {
        ++this.destinationOutgoingMessageThrottleCount;
        this.lastDestinationOutgoingMessageThrottleTimestamp = new Date();
    }

    public void resetDestinationOutgoingMessageThrottleCount() {
        this.destinationOutgoingMessageThrottleStart = System.currentTimeMillis();
        this.destinationOutgoingMessageThrottleCount = 0;
        this.lastDestinationOutgoingMessageThrottleTimestamp = null;
    }

    public Date getLastDestinationOutgoingMessageThrottleTimestamp() {
        return this.lastDestinationOutgoingMessageThrottleTimestamp;
    }

    public Double getDestinationOutgoingMessageThrottleFrequency() {
        if (this.destinationOutgoingMessageThrottleCount > 0) {
            double runtime = this.differenceInMinutes(this.destinationOutgoingMessageThrottleStart, System.currentTimeMillis());
            return new Double((double)this.destinationOutgoingMessageThrottleCount / runtime);
        }
        return new Double(0.0);
    }
}

