/*
 * Decompiled with CFR 0.152.
 */
package it.cnr.imaa.essi.lablib.gui.checkboxtree.examples;

import it.cnr.imaa.essi.lablib.gui.checkboxtree.CheckboxTree;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.TreeCheckingEvent;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.TreeCheckingListener;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.TreeCheckingModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CheckboxTreeExample
extends JFrame {
    private CheckboxTree checkboxTree = null;
    private JPanel jContentPane = null;

    public static void main(String[] args) {
        CheckboxTreeExample test = new CheckboxTreeExample();
        test.setVisible(true);
    }

    public CheckboxTreeExample() {
        this.setDefaultCloseOperation(3);
        this.setSize(300, 600);
        this.setContentPane(this.getJContentPane());
        this.setTitle("CheckboxTree");
    }

    private JScrollPane getCheckboxTree() {
        if (this.checkboxTree == null) {
            this.checkboxTree = new CheckboxTree();
            this.checkboxTree.addKeyListener(new RefreshListener());
            System.out.println(this.checkboxTree.toString());
            this.checkboxTree.getCheckingModel().setCheckingMode(TreeCheckingModel.CheckingMode.PROPAGATE);
            this.checkboxTree.setRootVisible(true);
            this.checkboxTree.setEnabled(true);
            this.checkboxTree.expandAll();
            DefaultMutableTreeNode mn = (DefaultMutableTreeNode)this.checkboxTree.getModel().getRoot();
            mn = (DefaultMutableTreeNode)mn.getChildAt(2);
            mn = (DefaultMutableTreeNode)mn.getChildAt(2);
            System.out.println("row number: " + this.checkboxTree.getRowForPath(new TreePath(mn.getPath())));
            this.checkboxTree.addCheckingPath(new TreePath(mn.getPath()));
            this.checkboxTree.addTreeCheckingListener(new TreeCheckingListener(){

                public void valueChanged(TreeCheckingEvent e) {
                    TreePath[] cr;
                    System.out.println("checking set changed, leading path: " + ((TreeNode)e.getPath().getLastPathComponent()).toString());
                    System.out.println("checking roots: ");
                    for (TreePath path : cr = CheckboxTreeExample.this.checkboxTree.getCheckingRoots()) {
                        System.out.println(path.getLastPathComponent());
                    }
                }
            });
        }
        return new JScrollPane(this.checkboxTree);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getCheckboxTree(), "Center");
        }
        return this.jContentPane;
    }

    private class RefreshListener
    implements KeyListener {
        private RefreshListener() {
        }

        public void keyPressed(KeyEvent e) {
            TreePath p = CheckboxTreeExample.this.checkboxTree.getSelectionPath();
            DefaultMutableTreeNode resource = null;
            if (p != null) {
                System.out.println("selection path: " + p.toString());
                resource = (DefaultMutableTreeNode)p.getLastPathComponent();
            }
            if (e.getKeyChar() == 'r' && resource != null) {
                TreeNode parent = resource.getParent();
                int index = parent.getIndex(resource);
                System.out.println("Removing " + resource.toString());
                resource.removeFromParent();
                DefaultTreeModel dtm = (DefaultTreeModel)CheckboxTreeExample.this.checkboxTree.getModel();
                dtm.nodesWereRemoved(parent, new int[]{index}, new TreeNode[]{resource});
            }
            if (e.getKeyChar() == 'a' && resource != null) {
                System.out.println("Adding to " + resource.toString());
                DefaultTreeModel dtm = (DefaultTreeModel)CheckboxTreeExample.this.checkboxTree.getModel();
                DefaultMutableTreeNode node = new DefaultMutableTreeNode("test");
                resource.add(node);
                dtm.nodesWereInserted(resource, new int[]{resource.getIndex(node)});
                System.out.println("posizione: " + resource.getIndex(node));
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }
    }
}

