/*
 * Decompiled with CFR 0.152.
 */
package skt.swing.tree.check;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import skt.swing.tree.check.CheckTreeCellRenderer;
import skt.swing.tree.check.CheckTreeSelectionModel;
import skt.swing.tree.check.TreePathSelectable;

public class CheckTreeManager
extends MouseAdapter
implements TreeSelectionListener {
    private CheckTreeSelectionModel selectionModel;
    private TreePathSelectable selectable;
    protected JTree tree = new JTree();
    int hotspot;

    public CheckTreeManager(JTree tree, boolean dig, TreePathSelectable selectable) {
        this.hotspot = new JCheckBox().getPreferredSize().width;
        this.tree = tree;
        this.selectionModel = new CheckTreeSelectionModel(tree.getModel(), dig);
        this.selectable = selectable;
        if (selectable != null) {
            tree.setLargeModel(true);
        }
        tree.setCellRenderer(new CheckTreeCellRenderer(tree.getCellRenderer(), this.selectionModel, selectable));
        tree.addMouseListener(this);
        this.selectionModel.addTreeSelectionListener(this);
    }

    public TreePathSelectable getSelectable(TreePathSelectable selectable) {
        return selectable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseClicked(MouseEvent me) {
        TreePath path = this.tree.getPathForLocation(me.getX(), me.getY());
        if (path == null) {
            return;
        }
        if (me.getX() > this.tree.getPathBounds((TreePath)path).x + this.hotspot) {
            return;
        }
        if (this.selectable != null && !this.selectable.isSelectable(path)) {
            return;
        }
        boolean selected = this.selectionModel.isPathSelected(path, this.selectionModel.isDigged());
        this.selectionModel.removeTreeSelectionListener(this);
        try {
            if (selected) {
                this.selectionModel.removeSelectionPath(path);
            } else {
                this.selectionModel.addSelectionPath(path);
            }
        }
        finally {
            this.selectionModel.addTreeSelectionListener(this);
            this.tree.treeDidChange();
        }
    }

    public CheckTreeSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.tree.treeDidChange();
    }
}

