/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.xml;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlInterfaceDefinition;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XPathData;
import com.eviware.soapui.support.xml.XPathModifier;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sf.saxon.expr.Tokenizer;
import org.apache.log4j.Logger;
import org.apache.xerces.util.SecurityManager;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class XmlUtils {
    private static DocumentBuilder documentBuilder;
    private static final Logger log;

    public static synchronized Document parse(InputStream in) {
        try {
            return XmlUtils.ensureDocumentBuilder().parse(in);
        }
        catch (Exception e) {
            log.error((Object)("Error parsing InputStream; " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public static synchronized Document parse(String fileName) throws IOException {
        try {
            return XmlUtils.ensureDocumentBuilder().parse(fileName);
        }
        catch (SAXException e) {
            log.error((Object)("Error parsing fileName [" + fileName + "]; " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public static String entitize(String xml) {
        return xml.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;").replaceAll("'", "&apos;");
    }

    public static String entitizeContent(String xml) {
        return xml.replaceAll("&", "&amp;").replaceAll("\"", "&quot;").replaceAll("'", "&apos;");
    }

    public static synchronized Document parse(InputSource inputSource) throws IOException {
        try {
            return XmlUtils.ensureDocumentBuilder().parse(inputSource);
        }
        catch (SAXException e) {
            throw new IOException(e.toString());
        }
    }

    private static DocumentBuilder ensureDocumentBuilder() {
        if (documentBuilder == null) {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                documentBuilder = dbf.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                log.error((Object)("Error creating DocumentBuilder; " + e.getMessage()));
            }
        }
        return documentBuilder;
    }

    public static String serializePretty(Document document) {
        try {
            StringWriter out = new StringWriter();
            XmlUtils.serializePretty(document, (Writer)out);
            return ((Object)out).toString();
        }
        catch (IOException e) {
            log.error((Object)("Failed to serialize: " + e));
            return null;
        }
    }

    public static void serializePretty(Document dom, Writer writer) throws IOException {
        try {
            XmlObject xmlObject = XmlObject.Factory.parse((Node)dom.getDocumentElement());
            XmlUtils.serializePretty(xmlObject, writer);
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    public static void serializePretty(XmlObject xmlObject, Writer writer) throws IOException {
        XmlOptions options = new XmlOptions();
        options.setSavePrettyPrint();
        options.setSavePrettyPrintIndent(3);
        options.setSaveNoXmlDecl();
        options.setSaveAggressiveNamespaces();
        xmlObject.save(writer, options);
    }

    public static XmlObject createXmlObject(InputStream input, XmlOptions xmlOptions) throws XmlException {
        try {
            return XmlObject.Factory.parse((InputStream)input, (XmlOptions)xmlOptions);
        }
        catch (Exception e) {
            throw new XmlException(e.toString());
        }
    }

    public static XmlObject createXmlObject(String input, XmlOptions xmlOptions) throws XmlException {
        return XmlObject.Factory.parse((String)input, (XmlOptions)xmlOptions);
    }

    public static XmlObject createXmlObject(URL input, XmlOptions xmlOptions) throws XmlException {
        try {
            return XmlObject.Factory.parse((URL)input, (XmlOptions)xmlOptions);
        }
        catch (Exception e) {
            throw new XmlException(e.toString());
        }
    }

    public static XmlObject createXmlObject(Node input, XmlOptions xmlOptions) throws XmlException {
        return XmlObject.Factory.parse((Node)input, (XmlOptions)xmlOptions);
    }

    public static XmlObject createXmlObject(File input, XmlOptions xmlOptions) throws XmlException {
        try {
            return XmlObject.Factory.parse((File)input, (XmlOptions)xmlOptions);
        }
        catch (Exception e) {
            throw new XmlException(e.toString());
        }
    }

    public static XmlObject createXmlObject(InputStream input) throws XmlException {
        try {
            return XmlObject.Factory.parse((InputStream)input);
        }
        catch (Exception e) {
            throw new XmlException(e.toString());
        }
    }

    public static XmlObject createXmlObject(String input) throws XmlException {
        return XmlObject.Factory.parse((String)input);
    }

    public static XmlObject createXmlObject(URL input) throws XmlException {
        try {
            return XmlObject.Factory.parse((URL)input);
        }
        catch (Exception e) {
            throw new XmlException(e.toString());
        }
    }

    public static XmlObject createXmlObject(Node input) throws XmlException {
        return XmlObject.Factory.parse((Node)input);
    }

    public static XmlObject createXmlObject(File input) throws XmlException {
        try {
            return XmlObject.Factory.parse((File)input);
        }
        catch (Exception e) {
            throw new XmlException(e.toString());
        }
    }

    public static XmlOptions createDefaultXmlOptions() {
        XmlOptions xmlOptions;
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            SecurityManager securityManager = new SecurityManager();
            securityManager.setEntityExpansionLimit(16);
            saxParser.setProperty("http://apache.org/xml/properties/security-manager", securityManager);
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlOptions = new XmlOptions().setLoadUseXMLReader(xmlReader);
        }
        catch (Exception e) {
            xmlOptions = new XmlOptions();
            log.error((Object)("Error creating XmlOptions; " + e.getMessage()), (Throwable)e);
        }
        return xmlOptions;
    }

    public static void serialize(Document dom, Writer writer) throws IOException {
        XmlUtils.serialize(dom.getDocumentElement(), writer);
    }

    public static void serialize(Element elm, Writer writer) throws IOException {
        try {
            XmlObject xmlObject = XmlObject.Factory.parse((Node)elm);
            xmlObject.save(writer);
        }
        catch (XmlException e) {
            throw new IOException(e.toString());
        }
    }

    public static String serialize(Node node, boolean prettyPrint) {
        try {
            XmlObject xmlObject = XmlObject.Factory.parse((Node)node);
            return prettyPrint ? xmlObject.xmlText(new XmlOptions().setSavePrettyPrint()) : xmlObject.xmlText();
        }
        catch (XmlException e) {
            return e.toString();
        }
    }

    public static void setElementText(Element elm, String text) {
        Node node = elm.getFirstChild();
        if (node == null) {
            if (text != null) {
                elm.appendChild(elm.getOwnerDocument().createTextNode(text));
            }
        } else if (node.getNodeType() == 3) {
            if (text == null) {
                node.getParentNode().removeChild(node);
            } else {
                node.setNodeValue(text);
            }
        } else if (text != null) {
            Text textNode = node.getOwnerDocument().createTextNode(text);
            elm.insertBefore(textNode, elm.getFirstChild());
        }
    }

    public static String getChildElementText(Element elm, String name) {
        Element child = XmlUtils.getFirstChildElement(elm, name);
        return child == null ? null : XmlUtils.getElementText(child);
    }

    public static Element getFirstChildElement(Element elm) {
        return XmlUtils.getFirstChildElement(elm, null);
    }

    public static Element getFirstChildElement(Element elm, String name) {
        if (elm == null) {
            return null;
        }
        NodeList nl = elm.getChildNodes();
        for (int c = 0; c < nl.getLength(); ++c) {
            Node node = nl.item(c);
            if (node.getNodeType() != 1 || name != null && !node.getNodeName().equals(name)) continue;
            return (Element)node;
        }
        return null;
    }

    public static Element getFirstChildElementIgnoreCase(Element elm, String name) {
        if (elm == null) {
            return null;
        }
        NodeList nl = elm.getChildNodes();
        for (int c = 0; c < nl.getLength(); ++c) {
            Node node = nl.item(c);
            if (node.getNodeType() != 1 || name != null && !node.getNodeName().equalsIgnoreCase(name)) continue;
            return (Element)node;
        }
        return null;
    }

    public static Element getFirstChildElementNS(Element elm, String tns, String localName) {
        if (tns == null && localName == null) {
            return XmlUtils.getFirstChildElement(elm);
        }
        if (tns == null || tns.length() == 0) {
            return XmlUtils.getFirstChildElement(elm, localName);
        }
        NodeList nl = elm.getChildNodes();
        for (int c = 0; c < nl.getLength(); ++c) {
            Node node = nl.item(c);
            if (node.getNodeType() != 1) continue;
            if (localName == null && tns.equals(node.getNamespaceURI())) {
                return (Element)node;
            }
            if (localName == null || !tns.equals(node.getNamespaceURI()) || !localName.equals(node.getLocalName())) continue;
            return (Element)node;
        }
        return null;
    }

    public static String getElementText(Element elm) {
        Node node = elm.getFirstChild();
        if (node != null && node.getNodeType() == 3) {
            return node.getNodeValue();
        }
        return null;
    }

    public static String getFragmentText(DocumentFragment elm) {
        Node node = elm.getFirstChild();
        if (node != null && node.getNodeType() == 3) {
            return node.getNodeValue();
        }
        return null;
    }

    public static String getChildElementText(Element elm, String name, String defaultValue) {
        String result = XmlUtils.getChildElementText(elm, name);
        return result == null ? defaultValue : result;
    }

    public static String getNodeValue(Node node) {
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == 1) {
            return XmlUtils.getElementText((Element)node);
        }
        if (node.getNodeType() == 11) {
            return XmlUtils.getFragmentText((DocumentFragment)node);
        }
        return node.getNodeValue();
    }

    public static Node createNodeFromPath(Element modelElement, String path) {
        Document document = modelElement.getOwnerDocument();
        StringTokenizer st = new StringTokenizer(path, "/");
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (st.hasMoreTokens()) {
                if (t.equals("..")) {
                    modelElement = (Element)modelElement.getParentNode();
                    continue;
                }
                Element elm = XmlUtils.getFirstChildElement(modelElement, t);
                if (elm == null) {
                    modelElement = (Element)modelElement.insertBefore(document.createElement(t), XmlUtils.getFirstChildElement(modelElement, t));
                    continue;
                }
                modelElement = elm;
                continue;
            }
            modelElement = (Element)modelElement.insertBefore(document.createElement(t), XmlUtils.getFirstChildElement(modelElement, t));
        }
        return modelElement;
    }

    public static Element addChildElement(Element element, String name, String text) {
        Document document = element.getOwnerDocument();
        Element result = (Element)element.appendChild(document.createElement(name));
        if (text != null) {
            result.appendChild(document.createTextNode(text));
        }
        return result;
    }

    public static void setChildElementText(Element element, String name, String text) {
        Element elm = XmlUtils.getFirstChildElement(element, name);
        if (elm == null) {
            elm = element.getOwnerDocument().createElement(name);
            element.appendChild(elm);
        }
        XmlUtils.setElementText(elm, text);
    }

    public static Document parseXml(String xmlString) throws IOException {
        return XmlUtils.parse(new InputSource(new StringReader(xmlString)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String transferValues(String source, String dest) {
        if (StringUtils.isNullOrEmpty(source) || StringUtils.isNullOrEmpty(dest)) {
            return dest;
        }
        XmlCursor cursor = null;
        try {
            XmlObject sourceXml = XmlObject.Factory.parse((String)source);
            XmlObject destXml = XmlObject.Factory.parse((String)dest);
            cursor = sourceXml.newCursor();
            cursor.toNextToken();
            while (!cursor.isEnddoc()) {
                while (!cursor.isContainer() && !cursor.isEnddoc()) {
                    cursor.toNextToken();
                }
                if (!cursor.isContainer()) continue;
                Element elm = (Element)cursor.getDomNode();
                String path = XmlUtils.createXPath(elm);
                XmlObject[] paths = destXml.selectPath(path);
                if (paths != null && paths.length > 0) {
                    Element elm2 = (Element)paths[0].getDomNode();
                    XmlUtils.transferAttributes(elm, elm2);
                    XmlUtils.setElementText(elm2, XmlUtils.getElementText(elm));
                    while (elm.getNextSibling() != null && elm2.getNextSibling() != null && elm.getNextSibling().getNodeName().equals(elm.getNodeName()) && !elm2.getNextSibling().getNodeName().equals(elm2.getNodeName())) {
                        elm2 = (Element)elm2.getParentNode().insertBefore(elm2.getOwnerDocument().createElementNS(elm2.getNamespaceURI(), elm2.getLocalName()), elm2.getNextSibling());
                        elm = (Element)elm.getNextSibling();
                        XmlUtils.transferAttributes(elm, elm2);
                        XmlUtils.setElementText(elm2, XmlUtils.getElementText(elm));
                    }
                }
                cursor.toNextToken();
            }
            String string = destXml.xmlText();
            return string;
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
        finally {
            if (cursor != null) {
                cursor.dispose();
            }
        }
        return dest;
    }

    private static void transferAttributes(Element elm, Element elm2) {
        NamedNodeMap attributes = elm.getAttributes();
        for (int c = 0; c < attributes.getLength(); ++c) {
            Attr attr = (Attr)attributes.item(c);
            elm2.setAttributeNodeNS((Attr)elm2.getOwnerDocument().importNode(attr, true));
        }
    }

    public static String getElementPath(Element element) {
        Node elm = element;
        String result = elm.getNodeName() + "[" + XmlUtils.getElementIndex(elm) + "]";
        while (elm.getParentNode() != null && elm.getParentNode().getNodeType() != 9) {
            elm = elm.getParentNode();
            result = elm.getNodeName() + "[" + XmlUtils.getElementIndex(elm) + "]/" + result;
        }
        return "/" + result;
    }

    public static int getElementIndex(Node element) {
        int result = 1;
        for (Node elm = element.getPreviousSibling(); elm != null; elm = elm.getPreviousSibling()) {
            if (elm.getNodeType() != 1 || !elm.getNodeName().equals(element.getNodeName())) continue;
            ++result;
        }
        return result;
    }

    public static String declareXPathNamespaces(String xmlString) throws XmlException {
        return XmlUtils.declareXPathNamespaces(XmlObject.Factory.parse((String)xmlString));
    }

    public static synchronized String prettyPrintXml(String xml) {
        try {
            if (!XmlUtils.seemsToBeXml(xml)) {
                return xml;
            }
            StringWriter writer = new StringWriter();
            XmlUtils.serializePretty(XmlObject.Factory.parse((String)xml), (Writer)writer);
            return writer.toString();
        }
        catch (Exception e) {
            log.warn((Object)("Failed to prettyPrint xml [" + xml + "]: " + e));
            return xml;
        }
    }

    public static synchronized String prettyPrintXml(XmlObject xml) {
        if (xml == null) {
            return null;
        }
        try {
            StringWriter writer = new StringWriter();
            XmlUtils.serializePretty(xml, (Writer)writer);
            return writer.toString();
        }
        catch (Exception e) {
            log.warn((Object)("Failed to prettyPrint xml [" + xml + "]: " + e));
            return xml.xmlText();
        }
    }

    public static String declareXPathNamespaces(WsdlInterface iface) {
        StringBuilder buf = new StringBuilder();
        buf.append("declare namespace soap='");
        buf.append(iface.getSoapVersion().getEnvelopeNamespace());
        buf.append("';\n");
        try {
            Collection<String> namespaces = ((WsdlInterfaceDefinition)iface.getWsdlContext().getInterfaceDefinition()).getDefinedNamespaces();
            int c = 1;
            for (String namespace : namespaces) {
                buf.append("declare namespace ns");
                buf.append(c++);
                buf.append("='");
                buf.append(namespace);
                buf.append("';\n");
            }
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
        return buf.toString();
    }

    public static String createXPath(Node domNode, boolean normalize) {
        return XmlUtils.createXPath(domNode, false, false, false, null, normalize);
    }

    public static String createXPath(Node node) {
        return XmlUtils.createXPath(node, false);
    }

    public static String createAbsoluteXPath(Node node) {
        return XmlUtils.createXPath(node, false, false, true, null);
    }

    public static String createXPath(Node node, boolean anonymous, boolean selectText, XPathModifier modifier) {
        return XmlUtils.createXPath(node, anonymous, selectText, false, modifier);
    }

    public static String createXPath(Node node, boolean anonymous, boolean selectText, boolean absolute, XPathModifier modifier) {
        return XmlUtils.createXPath(node, anonymous, selectText, absolute, modifier, false);
    }

    public static String createXPath(Node node, boolean anonymous, boolean selectText, boolean absolute, XPathModifier modifier, boolean normalize) {
        XPathData xpathData = XmlUtils.createXPathData(node, anonymous, selectText, absolute, normalize);
        if (xpathData == null) {
            return null;
        }
        return xpathData.buildXPath(modifier);
    }

    public static XPathData createXPathData(Node node, boolean anonymous, boolean selectText, boolean absolute) {
        return XmlUtils.createXPathData(node, anonymous, selectText, absolute, false);
    }

    public static XPathData createXPathData(Node node, boolean anonymous, boolean selectText, boolean absolute, boolean normalize) {
        String pc;
        int index;
        StringToStringMap nsMap = new StringToStringMap();
        ArrayList<String> pathComponents = new ArrayList<String>();
        int nsCnt = 1;
        String namespaceURI = node.getNamespaceURI();
        if (node.getNodeType() == 2) {
            if (namespaceURI != null && namespaceURI.length() > 0) {
                String prefix = node.getPrefix();
                if (normalize || prefix == null || prefix.length() == 0) {
                    prefix = "ns" + nsCnt++;
                }
                nsMap.put(namespaceURI, prefix);
                pathComponents.add("@" + prefix + ":" + node.getLocalName());
            } else {
                pathComponents.add("@" + node.getLocalName());
            }
            node = ((Attr)node).getOwnerElement();
        } else if (node.getNodeType() == 9) {
            node = ((Document)node).getDocumentElement();
        }
        if (node.getNodeType() == 1) {
            index = anonymous ? 0 : XmlUtils.findNodeIndex(node);
            namespaceURI = node.getNamespaceURI();
            if (namespaceURI != null && namespaceURI.length() > 0) {
                String prefix = node.getPrefix();
                if (nsMap.containsKey(namespaceURI)) {
                    prefix = (String)nsMap.get(namespaceURI);
                } else {
                    if (normalize || prefix == null || prefix.length() == 0) {
                        prefix = "ns" + nsCnt++;
                    }
                    while (!nsMap.containsKey(namespaceURI) && nsMap.containsValue(prefix)) {
                        prefix = "ns" + nsCnt++;
                    }
                    nsMap.put(namespaceURI, prefix);
                }
                pc = prefix + ":" + node.getLocalName();
            } else {
                pc = node.getLocalName();
            }
            String elementText = XmlUtils.getElementText((Element)node);
            if (selectText && pathComponents.isEmpty() && elementText != null && elementText.trim().length() > 0) {
                pathComponents.add("text()");
            }
        } else {
            return null;
        }
        pathComponents.add(pc + (index == 0 ? "" : "[" + index + "]"));
        namespaceURI = node.getNamespaceURI();
        for (node = node.getParentNode(); node != null && node.getNodeType() == 1 && (absolute || !"Body".equals(node.getNodeName()) && !SoapVersion.Soap11.getEnvelopeNamespace().equals(namespaceURI) && !SoapVersion.Soap12.getEnvelopeNamespace().equals(namespaceURI)); node = node.getParentNode()) {
            String pc2;
            index = anonymous ? 0 : XmlUtils.findNodeIndex(node);
            String ns = (String)nsMap.get(namespaceURI);
            if (ns == null && namespaceURI != null && namespaceURI.length() > 0) {
                String prefix = node.getPrefix();
                if (normalize || prefix == null || prefix.length() == 0) {
                    prefix = "ns" + nsCnt++;
                }
                while (!nsMap.containsKey(namespaceURI) && nsMap.containsValue(prefix)) {
                    prefix = "ns" + nsCnt++;
                }
                nsMap.put(namespaceURI, prefix);
                pc2 = prefix + ":" + node.getLocalName();
            } else {
                pc2 = ns != null ? ns + ":" + node.getLocalName() : node.getLocalName();
            }
            pathComponents.add(pc2 + (index == 0 ? "" : "[" + index + "]"));
            namespaceURI = node.getNamespaceURI();
        }
        return new XPathData(nsMap, pathComponents, absolute);
    }

    private static int findNodeIndex(Node node) {
        String nm = node.getLocalName();
        String ns = node.getNamespaceURI();
        short nt = node.getNodeType();
        Node parentNode = node.getParentNode();
        if (parentNode.getNodeType() != 1) {
            return 1;
        }
        int ix = 0;
        for (Node child = parentNode.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child == node) {
                return ix + 1;
            }
            if (child.getNodeType() != nt || !nm.equals(child.getLocalName()) || (ns != null || child.getNamespaceURI() != null) && (ns == null || !ns.equals(child.getNamespaceURI()))) continue;
            ++ix;
        }
        throw new RuntimeException("Child node not found in parent!?");
    }

    public static boolean setNodeValue(Node domNode, String string) {
        if (domNode == null) {
            return false;
        }
        short nodeType = domNode.getNodeType();
        switch (nodeType) {
            case 1: {
                XmlUtils.setElementText((Element)domNode, string);
                break;
            }
            case 2: 
            case 3: {
                domNode.setNodeValue(string);
                break;
            }
            case 7: {
                ((ProcessingInstruction)domNode).setData(string);
                break;
            }
            case 4: {
                ((CDATASection)domNode).setData(string);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public static String declareXPathNamespaces(XmlObject xmlObject) {
        HashMap<QName, String> map = new HashMap<QName, String>();
        XmlCursor cursor = xmlObject.newCursor();
        while (cursor.hasNextToken()) {
            if (!cursor.toNextToken().isNamespace()) continue;
            map.put(cursor.getName(), cursor.getTextValue());
        }
        cursor.dispose();
        int nsCnt = 0;
        StringBuilder buf = new StringBuilder();
        HashSet<String> prefixes = new HashSet<String>();
        HashSet<String> usedPrefixes = new HashSet<String>();
        for (Map.Entry entry : map.entrySet()) {
            QName name = (QName)entry.getKey();
            String prefix = name.getLocalPart();
            if (prefix.length() == 0) {
                prefix = "ns" + Integer.toString(++nsCnt);
            } else if (prefix.equals("xsd") || prefix.equals("xsi")) continue;
            if (usedPrefixes.contains(prefix)) {
                int c = 1;
                while (usedPrefixes.contains(prefix + c)) {
                    ++c;
                }
                prefix = prefix + Integer.toString(c);
            } else {
                prefixes.add(prefix);
            }
            buf.append("declare namespace ");
            buf.append(prefix);
            buf.append("='");
            buf.append((String)entry.getValue());
            buf.append("';\n");
            usedPrefixes.add(prefix);
        }
        return buf.toString();
    }

    public static String setXPathContent(String xmlText, String xpath, String value) {
        try {
            XmlObject[] path;
            XmlObject xmlObject = XmlObject.Factory.parse((String)xmlText);
            String namespaces = XmlUtils.declareXPathNamespaces(xmlObject);
            if (namespaces != null && namespaces.trim().length() > 0) {
                xpath = namespaces + xpath;
            }
            for (XmlObject xml : path = xmlObject.selectPath(xpath)) {
                XmlUtils.setNodeValue(xml.getDomNode(), value);
            }
            return xmlObject.toString();
        }
        catch (Exception e) {
            SoapUI.logError(e);
            return xmlText;
        }
    }

    public static QName getQName(Node node) {
        if (node == null) {
            return null;
        }
        if (node.getNamespaceURI() == null) {
            return new QName(node.getNodeName());
        }
        return new QName(node.getNamespaceURI(), node.getLocalName());
    }

    public static String removeXPathNamespaceDeclarations(String xpath) {
        int ix;
        while (xpath.startsWith("declare namespace") && (ix = xpath.indexOf(59)) != -1) {
            xpath = xpath.substring(ix + 1).trim();
        }
        return xpath;
    }

    public static String stripWhitespaces(String content) {
        try {
            XmlObject xml = XmlObject.Factory.parse((String)content, (XmlOptions)new XmlOptions().setLoadStripWhitespace().setLoadStripComments());
            content = xml.xmlText();
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
        return content;
    }

    public static NodeList getChildElements(Element elm) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList nl = elm.getChildNodes();
        for (int c = 0; c < nl.getLength(); ++c) {
            Node item = nl.item(c);
            if (item.getParentNode() != elm || item.getNodeType() != 1) continue;
            list.add((Element)item);
        }
        return new ElementNodeList(list);
    }

    public static NodeList getChildElementsByTagName(Element elm, String name) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList nl = elm.getChildNodes();
        for (int c = 0; c < nl.getLength(); ++c) {
            Node item = nl.item(c);
            if (item.getParentNode() != elm || item.getNodeType() != 1 || !name.equals(item.getNodeName())) continue;
            list.add((Element)item);
        }
        return new ElementNodeList(list);
    }

    public static NodeList getChildElementsOfType(Element elm, SchemaType schemaType) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList nl = elm.getChildNodes();
        for (int c = 0; c < nl.getLength(); ++c) {
            Node item = nl.item(c);
            if (item.getParentNode() != elm || item.getNodeType() != 1 || !((Element)item).getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type").endsWith(":" + schemaType.getName().getLocalPart())) continue;
            list.add((Element)item);
        }
        return new ElementNodeList(list);
    }

    public static NodeList getChildElementsNS(Element elm, QName name) {
        return XmlUtils.getChildElementsByTagNameNS(elm, name.getNamespaceURI(), name.getLocalPart());
    }

    public static NodeList getChildElementsByTagNameNS(Element elm, String namespaceUri, String localName) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList nl = elm.getChildNodes();
        for (int c = 0; c < nl.getLength(); ++c) {
            Node item = nl.item(c);
            if (item.getParentNode() != elm || item.getNodeType() != 1 || !localName.equals(item.getLocalName()) || !namespaceUri.equals(item.getNamespaceURI())) continue;
            list.add((Element)item);
        }
        return new ElementNodeList(list);
    }

    public static String serialize(Document document) {
        StringWriter writer = new StringWriter();
        try {
            XmlUtils.serialize(document, (Writer)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return writer.toString();
    }

    public static Element getFirstChildElementNS(Element domNode, QName name) {
        return XmlUtils.getFirstChildElementNS(domNode, name.getNamespaceURI(), name.getLocalPart());
    }

    public static QName findTypeNameForXsiType(String typeName, Element elm) {
        int ix = typeName.indexOf(58);
        if (ix == -1) {
            return null;
        }
        String prefix = typeName.substring(0, ix);
        String localName = typeName.substring(ix + 1);
        String namespaceUri = elm.getAttribute("xmlns:" + prefix);
        if (!StringUtils.hasContent(namespaceUri)) {
            namespaceUri = XmlUtils.findNamespaceForPrefix(elm, prefix);
        }
        if (StringUtils.hasContent(namespaceUri)) {
            return new QName(namespaceUri, localName);
        }
        return null;
    }

    private static String findNamespaceForPrefix(Element elm, String prefix) {
        String namespaceUri = null;
        while (StringUtils.isNullOrEmpty(namespaceUri) && elm != null && elm.getParentNode().getNodeType() == 1) {
            elm = (Element)elm.getParentNode();
            namespaceUri = elm.getAttribute("xmlns:" + prefix);
        }
        return StringUtils.isNullOrEmpty(namespaceUri) ? null : namespaceUri;
    }

    public static String findPrefixForNamespace(Element elm, String namespace) {
        while (elm != null) {
            NamedNodeMap attributes = elm.getAttributes();
            for (int c = 0; c < attributes.getLength(); ++c) {
                if (!attributes.item(c).getNodeValue().equals(namespace) || !attributes.item(c).getNodeName().startsWith("xmlns:")) continue;
                return attributes.item(c).getNodeName().substring(6);
            }
            if (elm.getParentNode().getNodeType() != 1) break;
            elm = (Element)elm.getParentNode();
        }
        return null;
    }

    public static void setXsiType(Element elm, QName name) {
        String prefix = XmlUtils.findPrefixForNamespace(elm, name.getNamespaceURI());
        if (prefix == null) {
            prefix = XmlUtils.generatePrefixForNamespace(name.getNamespaceURI());
            while (XmlUtils.findNamespaceForPrefix(elm, prefix) != null) {
                prefix = XmlUtils.generatePrefixForNamespace(name.getNamespaceURI());
            }
            elm.setAttribute("xmlns:" + prefix, name.getNamespaceURI());
        }
        elm.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type", prefix + ":" + name.getLocalPart());
    }

    private static String generatePrefixForNamespace(String namespaceURI) {
        return "ns" + (int)(Math.random() * 1000.0);
    }

    public static QName createQName(Node node) {
        return new QName(node.getNamespaceURI(), node.getLocalName());
    }

    public static Node getNextElementSibling(Node node) {
        for (node = node.getNextSibling(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
        }
        return node;
    }

    public static Document createDocument(QName element) {
        XmlUtils.ensureDocumentBuilder();
        Document document = documentBuilder.newDocument();
        document.appendChild(document.createElementNS(element.getNamespaceURI(), element.getLocalPart()));
        return document;
    }

    public static String getValueForMatch(XmlCursor cursor) {
        Element elm;
        Node domNode = cursor.getDomNode();
        String stringValue = domNode.getNodeType() == 2 || domNode.getNodeType() == 3 ? domNode.getNodeValue() : (cursor.getObject() instanceof XmlAnySimpleType ? ((XmlAnySimpleType)cursor.getObject()).getStringValue() : (domNode.getNodeType() == 1 ? ((elm = (Element)domNode).getChildNodes().getLength() == 1 && !XmlUtils.hasContentAttributes(elm) ? XmlUtils.getElementText(elm) : cursor.getObject().xmlText(new XmlOptions().setSavePrettyPrint().setSaveOuter().setSaveAggressiveNamespaces())) : domNode.getNodeValue()));
        return stringValue;
    }

    public static boolean hasContentAttributes(Element elm) {
        NamedNodeMap attributes = elm.getAttributes();
        for (int c = 0; c < attributes.getLength(); ++c) {
            Node item = attributes.item(c);
            String ns = item.getNamespaceURI();
            if (ns.equals("http://www.w3.org/2000/xmlns/")) continue;
            return true;
        }
        return false;
    }

    public static String getValueForMatch(Node domNode, boolean prettyPrintXml) {
        Element elm;
        String stringValue = domNode.getNodeType() == 2 || domNode.getNodeType() == 3 ? domNode.getNodeValue() : (domNode.getNodeType() == 1 ? ((elm = (Element)domNode).getChildNodes().getLength() == 1 && !XmlUtils.hasContentAttributes(elm) ? XmlUtils.getElementText(elm) : XmlUtils.serialize(domNode, prettyPrintXml)) : domNode.getNodeValue());
        return stringValue;
    }

    public static String selectFirstNodeValue(XmlObject xmlObject, String xpath) throws XmlException {
        Node domNode = XmlUtils.selectFirstDomNode(xmlObject, xpath);
        return domNode == null ? null : XmlUtils.getNodeValue(domNode);
    }

    public static String[] selectNodeValues(XmlObject xmlObject, String xpath) {
        Node[] nodes = XmlUtils.selectDomNodes(xmlObject, xpath);
        String[] result = new String[nodes.length];
        for (int c = 0; c < nodes.length; ++c) {
            result[c] = XmlUtils.getNodeValue(nodes[c]);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node selectFirstDomNode(XmlObject xmlObject, String xpath) {
        XmlCursor cursor = xmlObject.newCursor();
        try {
            cursor.selectPath(xpath);
            if (cursor.toNextSelection()) {
                Node node = cursor.getDomNode();
                return node;
            }
            Node node = null;
            return node;
        }
        finally {
            cursor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node[] selectDomNodes(XmlObject xmlObject, String xpath) {
        ArrayList<Node> result = new ArrayList<Node>();
        XmlCursor cursor = xmlObject.newCursor();
        try {
            cursor.selectPath(xpath);
            while (cursor.toNextSelection()) {
                result.add(cursor.getDomNode());
            }
        }
        finally {
            cursor.dispose();
        }
        return result.toArray(new Node[result.size()]);
    }

    public static boolean seemsToBeXml(String str) {
        try {
            if (StringUtils.isNullOrEmpty(str)) {
                return false;
            }
            XmlObject.Factory.parse((String)str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String extractNamespaces(String xpath) {
        String result = xpath;
        int ix = xpath.lastIndexOf("declare namespace");
        if (ix != -1) {
            if ((ix = xpath.indexOf(39, ix + 1)) != -1 && (ix = xpath.indexOf(39, ix + 1)) != -1 && (ix = xpath.indexOf(59)) != -1) {
                result = xpath.substring(0, ix + 1);
            }
        } else {
            result = "";
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String removeUnneccessaryNamespaces(String xml) {
        if (StringUtils.isNullOrEmpty(xml)) {
            return xml;
        }
        XmlCursor cursor = null;
        try {
            XmlObject xmlObject = XmlObject.Factory.parse((String)xml);
            cursor = xmlObject.newCursor();
            while (cursor.currentTokenType() != XmlCursor.TokenType.START && cursor.currentTokenType() != XmlCursor.TokenType.ENDDOC) {
                cursor.toNextToken();
            }
            if (cursor.currentTokenType() == XmlCursor.TokenType.START) {
                int c;
                HashMap nsMap = new HashMap();
                cursor.getAllNamespaces(nsMap);
                nsMap.remove(cursor.getDomNode().getPrefix());
                NamedNodeMap attributes = cursor.getDomNode().getAttributes();
                for (c = 0; attributes != null && c < attributes.getLength(); ++c) {
                    nsMap.remove(attributes.item(c).getPrefix());
                }
                if (cursor.toFirstChild()) {
                    while (cursor.getDomNode() != xmlObject.getDomNode()) {
                        attributes = cursor.getDomNode().getAttributes();
                        for (c = 0; attributes != null && c < attributes.getLength(); ++c) {
                            nsMap.remove(attributes.item(c).getPrefix());
                        }
                        nsMap.remove(cursor.getDomNode().getPrefix());
                        cursor.toNextToken();
                    }
                }
                xml = xmlObject.xmlText(new XmlOptions().setSaveOuter().setSavePrettyPrint().setSaveImplicitNamespaces(nsMap));
            }
        }
        catch (XmlException xmlException) {
        }
        finally {
            if (cursor != null) {
                cursor.dispose();
            }
        }
        return xml;
    }

    public static String replaceNameInPathOrQuery(String pathOrQuery, String oldName, String newName) throws Exception {
        Tokenizer t = new Tokenizer();
        t.tokenize(pathOrQuery, 0, -1, 1);
        StringBuffer result = new StringBuffer();
        int lastIx = 0;
        while (t.currentToken != 0) {
            if (t.currentToken == 201 && t.currentTokenValue.equals(oldName)) {
                result.append(pathOrQuery.substring(lastIx, t.currentTokenStartOffset));
                result.append(newName);
                lastIx = t.currentTokenStartOffset + t.currentTokenValue.length();
            }
            t.next();
        }
        if (lastIx < pathOrQuery.length()) {
            result.append(pathOrQuery.substring(lastIx));
        }
        System.out.println("returning " + result.toString());
        return result.toString();
    }

    public static QName getQName(XmlObject contentElement) {
        return contentElement == null ? null : XmlUtils.getQName(contentElement.getDomNode());
    }

    public static String getXPathValue(String value, String xpath) {
        try {
            XmlObject xmlObject = XmlObject.Factory.parse((String)value);
            XmlObject[] nodes = xmlObject.selectPath(xpath);
            if (nodes.length > 0) {
                return XmlUtils.getNodeValue(nodes[0].getDomNode());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String createJdbcXmlResult(Statement statement) throws SQLException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document xmlDocumentResult = builder.newDocument();
        Element resultsElement = xmlDocumentResult.createElement("Results");
        xmlDocumentResult.appendChild(resultsElement);
        if (statement != null) {
            ResultSet resultSet = statement.getResultSet();
            if (resultSet != null) {
                resultSet.setFetchSize(statement.getFetchSize());
                xmlDocumentResult = XmlUtils.addResultSetXmlPart(resultsElement, resultSet, xmlDocumentResult);
                while (statement.getMoreResults()) {
                    xmlDocumentResult = XmlUtils.addResultSetXmlPart(resultsElement, statement.getResultSet(), xmlDocumentResult);
                }
            } else {
                Element errorElement = xmlDocumentResult.createElement("UpdateCount");
                errorElement.appendChild(xmlDocumentResult.createTextNode(String.valueOf(statement.getUpdateCount())));
                resultsElement.appendChild(errorElement);
            }
        }
        StringWriter out = new StringWriter();
        OutputFormat outputFormat = new OutputFormat(xmlDocumentResult);
        outputFormat.setOmitComments(true);
        outputFormat.setOmitDocumentType(true);
        outputFormat.setOmitXMLDeclaration(true);
        outputFormat.setIndent(3);
        outputFormat.setIndenting(true);
        try {
            XMLSerializer serializer = new XMLSerializer((Writer)new PrintWriter(out), outputFormat);
            serializer.asDOMSerializer();
            serializer.serialize(xmlDocumentResult);
        }
        catch (IOException e) {
            SoapUI.logError(e);
        }
        return out.toString();
    }

    public static Document addResultSetXmlPart(Element resultsElement, ResultSet rs, Document xmlDocumentResult) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        Element resultSetElement = xmlDocumentResult.createElement("ResultSet");
        resultSetElement.setAttribute("fetchSize", String.valueOf(rs.getFetchSize()));
        resultsElement.appendChild(resultSetElement);
        int colCount = rsmd.getColumnCount();
        while (rs.next()) {
            Element rowElement = xmlDocumentResult.createElement("Row");
            rowElement.setAttribute("rowNumber", String.valueOf(rs.getRow()));
            resultsElement.appendChild(rowElement);
            for (int ii = 1; ii <= colCount; ++ii) {
                String columnName = "";
                if (!StringUtils.isNullOrEmpty(rsmd.getTableName(ii))) {
                    columnName = columnName + rsmd.getTableName(ii).toUpperCase() + ".";
                }
                columnName = columnName + rsmd.getColumnName(ii).toUpperCase();
                String value = rs.getString(ii);
                Element node = xmlDocumentResult.createElement(StringUtils.createXmlName(columnName));
                if (!StringUtils.isNullOrEmpty(value)) {
                    Text textNode = xmlDocumentResult.createTextNode(value);
                    node.appendChild(textNode);
                }
                rowElement.appendChild(node);
            }
            resultSetElement.appendChild(rowElement);
        }
        return xmlDocumentResult;
    }

    static {
        log = Logger.getLogger(XmlUtils.class);
    }

    private static final class ElementNodeList
    implements NodeList {
        private final List<Element> list;

        public ElementNodeList(List<Element> list) {
            this.list = list;
        }

        @Override
        public int getLength() {
            return this.list.size();
        }

        @Override
        public Node item(int index) {
            return this.list.get(index);
        }
    }
}

