/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.uri;

import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.message.BasicHeader;

public class HttpParser {
    public static String readLine(InputStream inputStream, String charset) throws IOException {
        return IOUtils.toString((InputStream)inputStream, (String)charset);
    }

    public static Header[] parseHeaders(InputStream is, String charset) throws IOException, HttpException {
        String line;
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        String name = null;
        StringBuffer value = null;
        while ((line = HttpParser.readLine(is, charset)) != null && line.trim().length() >= 1) {
            int colon;
            if (line.charAt(0) == ' ' || line.charAt(0) == '\t') {
                if (value == null) continue;
                value.append(' ');
                value.append(line.trim());
                continue;
            }
            if (name != null) {
                headers.add(new BasicHeader(name, value.toString()));
            }
            if ((colon = line.indexOf(":")) < 0) {
                throw new ProtocolException("Unable to parse header: " + line);
            }
            name = line.substring(0, colon).trim();
            value = new StringBuffer(line.substring(colon + 1).trim());
        }
        if (name != null) {
            headers.add(new BasicHeader(name, value.toString()));
        }
        return headers.toArray(new Header[headers.size()]);
    }
}

