/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.swing;

import com.eviware.soapui.support.UISupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;

public abstract class JTableFactory {
    public abstract JTable makeJTable(TableModel var1);

    public abstract JXTable makeJXTable(TableModel var1);

    public static JTableFactory getInstance() {
        return new DefaultJTableFactory();
    }

    public static void setGridAttributes(JTable stripedTable) {
        stripedTable.setShowGrid(false);
        stripedTable.setIntercellSpacing(new Dimension(0, 0));
    }

    public static void applyStripesToRenderer(int row, Component defaultRenderer) {
        if (row % 2 == 0) {
            defaultRenderer.setBackground(new Color(241, 244, 247));
        } else {
            defaultRenderer.setBackground(Color.WHITE);
        }
        defaultRenderer.setForeground(Color.BLACK);
    }

    private static class DefaultJTableFactory
    extends JTableFactory {
        private DefaultJTableFactory() {
        }

        @Override
        public JTable makeJTable(TableModel tableModel) {
            return UISupport.isMac() ? this.makeStripedTable(tableModel) : new JTable(tableModel);
        }

        @Override
        public JXTable makeJXTable(TableModel tableModel) {
            return UISupport.isMac() ? this.makeStripedJXTable(tableModel) : new JXTable(tableModel);
        }

        private JXTable makeStripedJXTable(TableModel tableModel) {
            JXTable stripedJxTable = new JXTable(tableModel){

                public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                    Component defaultRenderer = super.prepareRenderer(renderer, row, column);
                    JTableFactory.applyStripesToRenderer(row, defaultRenderer);
                    return defaultRenderer;
                }

                public boolean getShowVerticalLines() {
                    return false;
                }
            };
            DefaultJTableFactory.setGridAttributes((JTable)stripedJxTable);
            return stripedJxTable;
        }

        private JTable makeStripedTable(TableModel tableModel) {
            JTable stripedTable = new JTable(tableModel){

                @Override
                public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                    Component defaultRenderer = super.prepareRenderer(renderer, row, column);
                    JTableFactory.applyStripesToRenderer(row, defaultRenderer);
                    return defaultRenderer;
                }

                @Override
                public boolean getShowVerticalLines() {
                    return false;
                }
            };
            DefaultJTableFactory.setGridAttributes(stripedTable);
            return stripedTable;
        }
    }
}

