/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.log;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.model.testsuite.LoadTestRunner;
import com.eviware.soapui.monitor.support.TestMonitorListenerAdapter;
import com.eviware.soapui.security.SecurityTestRunner;
import com.eviware.soapui.settings.UISettings;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public final class LogDisablingTestMonitorListener
extends TestMonitorListenerAdapter {
    private Set<LoadTestRunner> loadTestRunners = new HashSet<LoadTestRunner>();
    private Set<SecurityTestRunner> securityTestRunners = new HashSet<SecurityTestRunner>();

    @Override
    public void loadTestStarted(LoadTestRunner runner) {
        if (this.loadTestRunners.isEmpty()) {
            Logger.getLogger(SoapUI.class).info((Object)"Disabling logs during loadtests");
            Logger.getLogger((String)"org.apache.http.wire").setLevel(Level.OFF);
            if (!SoapUI.getSettings().getBoolean(UISettings.DONT_DISABLE_GROOVY_LOG)) {
                Logger.getLogger((String)"groovy.log").setLevel(Level.OFF);
            }
        }
        this.loadTestRunners.add(runner);
    }

    @Override
    public void loadTestFinished(LoadTestRunner runner) {
        this.loadTestRunners.remove(runner);
        if (this.loadTestRunners.isEmpty()) {
            Logger.getLogger((String)"org.apache.http.wire").setLevel(Level.DEBUG);
            Logger.getLogger((String)"groovy.log").setLevel(Level.DEBUG);
            Logger.getLogger(SoapUI.class).info((Object)"Enabled logs after loadtests");
        }
    }

    @Override
    public void securityTestStarted(SecurityTestRunner runner) {
        if (this.securityTestRunners.isEmpty()) {
            // empty if block
        }
        this.securityTestRunners.add(runner);
    }

    @Override
    public void securityTestFinished(SecurityTestRunner runner) {
        this.securityTestRunners.remove(runner);
        if (this.securityTestRunners.isEmpty()) {
            // empty if block
        }
    }
}

