/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.inspectors.auth;

import com.eviware.soapui.config.CredentialsConfig;
import com.eviware.soapui.impl.rest.OAuth2ProfileContainer;
import com.eviware.soapui.impl.rest.RestRequest;
import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.support.MessageSupport;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.components.JUndoableTextField;
import com.eviware.soapui.support.components.SimpleForm;
import com.eviware.soapui.support.editor.inspectors.auth.ProfileSelectionForm;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import com.eviware.x.impl.swing.JComboBoxFormField;
import com.eviware.x.impl.swing.JLabelFormField;
import com.eviware.x.impl.swing.JTextFieldFormField;
import com.jgoodies.forms.layout.FormLayout;
import java.util.List;
import javax.swing.Action;
import javax.swing.JLabel;

public class AuthorizationSelectionDialog<T extends AbstractHttpRequest> {
    private T request;
    private List<String> basicAuthTypes;
    private JTextFieldFormField profileNameField;
    private JLabelFormField hintTextLabel;

    public AuthorizationSelectionDialog(T request, List<String> basicAuthTypes) {
        this.request = request;
        this.basicAuthTypes = basicAuthTypes;
        this.buildAndShowDialog();
    }

    private void buildAndShowDialog() {
        FormLayout layout = new FormLayout("5px,100px,5px,left:default,5px:grow(1.0)");
        XFormDialog dialog = ADialogBuilder.buildDialog(AuthorizationTypeForm.class, null, layout);
        this.profileNameField = (JTextFieldFormField)dialog.getFormField(AuthorizationTypeForm.OAUTH2_PROFILE_NAME_FIELD);
        this.profileNameField.addFormFieldListener(new ProfileNameFieldListener(dialog));
        this.hintTextLabel = (JLabelFormField)dialog.getFormField(AuthorizationTypeForm.OAUTH2_PROFILE_NAME_HINT_TEXT_LABEL);
        this.setHintTextColor();
        this.setProfileNameAndHintTextVisibility(((AbstractHttpRequest)this.request).getAuthType());
        List<String> authTypes = this.getBasicAuthenticationTypes();
        authTypes.removeAll(((AbstractHttpRequest)this.request).getBasicAuthenticationProfiles());
        if (this.request instanceof RestRequest) {
            authTypes.add(CredentialsConfig.AuthType.O_AUTH_2_0.toString());
            int nextProfileIndex = this.getOAuth2ProfileContainer().getOAuth2ProfileList().size() + 1;
            this.profileNameField.setValue("Profile " + nextProfileIndex);
        }
        this.setAuthTypeComboBoxOptions(dialog, authTypes);
        dialog.setValue(AuthorizationTypeForm.AUTHORIZATION_TYPE, ((AbstractHttpRequest)this.request).getAuthType());
        if (dialog.show()) {
            this.createProfileForSelectedAuthType(dialog);
        }
    }

    private void createProfileForSelectedAuthType(XFormDialog dialog) {
        String authType;
        String profileName = authType = dialog.getValue(AuthorizationTypeForm.AUTHORIZATION_TYPE);
        if (CredentialsConfig.AuthType.O_AUTH_2_0.toString().equals(authType)) {
            profileName = dialog.getValue(AuthorizationTypeForm.OAUTH2_PROFILE_NAME_FIELD);
            if (ProfileSelectionForm.isReservedProfileName(profileName)) {
                UISupport.showErrorMessage("'" + profileName + "' is a reserved profile name.");
                return;
            }
            if (this.getOAuth2ProfileContainer().getOAuth2ProfileNameList().contains(profileName)) {
                UISupport.showErrorMessage("There is already a profile named '" + profileName + "'");
                return;
            }
            this.getOAuth2ProfileContainer().addNewOAuth2Profile(profileName);
        }
        CredentialsConfig.AuthType.Enum authTypeEnum = CredentialsConfig.AuthType.O_AUTH_2_0;
        if (!((Object)((Object)CredentialsConfig.AuthType.O_AUTH_2_0)).equals(authType)) {
            authTypeEnum = ((AbstractHttpRequest)this.request).getBasicAuthType(authType);
        }
        ((AbstractHttpRequest)this.request).setSelectedAuthProfileAndAuthType(profileName, authTypeEnum);
    }

    private void setAuthTypeComboBoxOptions(XFormDialog dialog, List<String> options) {
        JComboBoxFormField authTypesComboBox = (JComboBoxFormField)dialog.getFormField(AuthorizationTypeForm.AUTHORIZATION_TYPE);
        authTypesComboBox.setOptions(options.toArray(new String[options.size()]));
        authTypesComboBox.addFormFieldListener(new XFormFieldListener(){

            @Override
            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                AuthorizationSelectionDialog.this.setProfileNameAndHintTextVisibility(newValue);
            }
        });
    }

    private void setHintTextColor() {
        ((JLabel)this.hintTextLabel.getComponent()).setForeground(SimpleForm.HINT_TEXT_COLOR);
    }

    private void setProfileNameAndHintTextVisibility(String authorizationType) {
        if (authorizationType.equals(CredentialsConfig.AuthType.O_AUTH_2_0.toString())) {
            ((JLabel)((JUndoableTextField)this.profileNameField.getComponent()).getClientProperty("labeledBy")).setVisible(true);
            ((JUndoableTextField)this.profileNameField.getComponent()).setVisible(true);
            ((JLabel)this.hintTextLabel.getComponent()).setVisible(true);
        } else {
            ((JLabel)((JUndoableTextField)this.profileNameField.getComponent()).getClientProperty("labeledBy")).setVisible(false);
            ((JUndoableTextField)this.profileNameField.getComponent()).setVisible(false);
            ((JLabel)this.hintTextLabel.getComponent()).setVisible(false);
        }
    }

    private OAuth2ProfileContainer getOAuth2ProfileContainer() {
        return ((AbstractHttpRequest)this.request).getOperation().getInterface().getProject().getOAuth2ProfileContainer();
    }

    public List<String> getBasicAuthenticationTypes() {
        return this.basicAuthTypes;
    }

    @AForm(name="AuthorizationTypeForm.Title", description="AuthorizationTypeForm.Description", helpUrl="http://www.soapui.org/OAuth/add-authorization.html")
    public static interface AuthorizationTypeForm {
        public static final MessageSupport messages = MessageSupport.getMessages(AuthorizationTypeForm.class);
        @AField(description="AuthorizationTypeForm.AuthorizationType.Description", type=AField.AFieldType.COMBOBOX)
        public static final String AUTHORIZATION_TYPE = messages.get("AuthorizationTypeForm.AuthorizationType.Label");
        @AField(description="AuthorizationTypeForm.OAuth2ProfileName.Description", type=AField.AFieldType.STRING)
        public static final String OAUTH2_PROFILE_NAME_FIELD = messages.get("AuthorizationTypeForm.OAuth2ProfileName.Label");
        @AField(description="AuthorizationTypeForm.OAuth2ProfileNameHintText.Description", type=AField.AFieldType.LABEL)
        public static final String OAUTH2_PROFILE_NAME_HINT_TEXT_LABEL = messages.get("AuthorizationTypeForm.OAuth2ProfileNameHintText.Label");
    }

    private static class ProfileNameFieldListener
    implements XFormFieldListener {
        private final XFormDialog dialog;

        public ProfileNameFieldListener(XFormDialog dialog) {
            this.dialog = dialog;
        }

        @Override
        public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
            ActionList actionsList = this.dialog.getActionsList();
            for (int actionIndex = 0; actionIndex < actionsList.getActionCount(); ++actionIndex) {
                Action action = actionsList.getActionAt(actionIndex);
                if (!action.getValue("Name").equals("OK")) continue;
                if (StringUtils.isNullOrEmpty(newValue)) {
                    action.setEnabled(false);
                    continue;
                }
                action.setEnabled(true);
            }
        }
    }
}

