/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.inspectors.attachments;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.editor.inspectors.attachments.AttachmentTableModel;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public class FileTransferHandler
extends TransferHandler {
    private DataFlavor fileFlavor = DataFlavor.javaFileListFlavor;
    private AttachmentTableModel attachmentModel;

    public FileTransferHandler(AttachmentTableModel attachmentModel) {
        this.attachmentModel = attachmentModel;
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        return this.hasFileFlavor(flavors);
    }

    private boolean hasFileFlavor(DataFlavor[] flavors) {
        for (int i = 0; i < flavors.length; ++i) {
            if (!this.fileFlavor.equals(flavors[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean importData(JComponent c, Transferable t) {
        try {
            List files = (List)t.getTransferData(this.fileFlavor);
            for (File f : files) {
                System.out.println("Got a file: " + f.getName());
                Boolean retval = UISupport.confirmOrCancel("Cache attachment in request?", "Att Attachment");
                if (retval == null) {
                    return false;
                }
                this.attachmentModel.addFile(f, retval);
            }
        }
        catch (IOException ex) {
            SoapUI.logError(ex);
        }
        catch (UnsupportedFlavorException ex) {
            SoapUI.logError(ex);
        }
        return false;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }
}

