/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.action.swing;

import com.eviware.soapui.actions.UpdateableAction;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.ActionSupport;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.KeyStroke;

public class DefaultActionList
implements ActionList {
    private List<Action> actions = new ArrayList<Action>();
    private Action defaultAction;
    private final String label;

    public DefaultActionList() {
        this(null);
    }

    public DefaultActionList(String label) {
        this.label = label;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public int getActionCount() {
        return this.actions.size();
    }

    @Override
    public Action getActionAt(int index) {
        return this.actions.get(index);
    }

    @Override
    public Action getDefaultAction() {
        return this.defaultAction;
    }

    @Override
    public void setDefaultAction(Action defaultAction) {
        this.defaultAction = defaultAction;
    }

    @Override
    public void addAction(Action action) {
        this.actions.add(action);
    }

    public void addAction(Action action, boolean isDefault) {
        this.actions.add(action);
        if (isDefault) {
            this.setDefaultAction(action);
        }
    }

    @Override
    public void addSeparator() {
        this.actions.add(ActionSupport.SEPARATOR_ACTION);
    }

    @Override
    public void insertAction(Action action, int index) {
        this.actions.add(index, action);
    }

    @Override
    public void insertSeparator(int index) {
        this.actions.add(index, ActionSupport.SEPARATOR_ACTION);
    }

    @Override
    public boolean hasDefaultAction() {
        return this.defaultAction != null;
    }

    @Override
    public void performDefaultAction(ActionEvent event) {
        if (this.defaultAction != null) {
            this.defaultAction.actionPerformed(event);
        }
    }

    @Override
    public void clear() {
        this.actions.clear();
        this.defaultAction = null;
    }

    @Override
    public void dispatchKeyEvent(KeyEvent e) {
        if (e.getKeyChar() == '\n' && this.defaultAction != null) {
            this.performDefaultAction(new ActionEvent(e.getSource(), 0, null));
            e.consume();
        } else {
            for (int c = 0; c < this.actions.size(); ++c) {
                Action action = this.actions.get(c);
                KeyStroke acc = (KeyStroke)action.getValue("AcceleratorKey");
                if (acc == null || !acc.equals(KeyStroke.getKeyStrokeForEvent(e))) continue;
                action.actionPerformed(new ActionEvent(e.getSource(), 0, null));
                e.consume();
                return;
            }
        }
    }

    @Override
    public void addActions(ActionList defaultActions) {
        for (int c = 0; c < defaultActions.getActionCount(); ++c) {
            this.addAction(defaultActions.getActionAt(c));
        }
    }

    public void setEnabled(boolean b) {
        for (int c = 0; c < this.actions.size(); ++c) {
            Action action = this.actions.get(c);
            action.setEnabled(b);
        }
    }

    @Override
    public void removeAction(int index) {
        this.actions.remove(index);
    }

    public void update() {
        for (Action a : this.actions) {
            if (!(a instanceof UpdateableAction)) continue;
            ((UpdateableAction)((Object)a)).update();
        }
    }
}

