/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.result;

import com.eviware.soapui.impl.wsdl.teststeps.actions.ShowMessageExchangeAction;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.security.SecurityScan;
import com.eviware.soapui.security.result.SecurityResult;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.DefaultActionList;
import com.eviware.soapui.support.types.StringToStringMap;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class SecurityScanRequestResult
implements SecurityResult {
    private static final String[] EMPTY_MESSAGES = new String[0];
    public static final String TYPE = "SecurityScanRequestResult";
    private SecurityResult.ResultStatus status = SecurityResult.ResultStatus.UNKNOWN;
    private SecurityScan securityCheck;
    private List<String> messages = new ArrayList<String>();
    private long timeTaken;
    private long startTime;
    private long timeStamp;
    private long size;
    private boolean discarded;
    private MessageExchange messageExchange;
    private DefaultActionList actionList;
    private boolean addedAction;

    public SecurityScanRequestResult(SecurityScan securityCheck) {
        this.securityCheck = securityCheck;
        this.timeStamp = System.currentTimeMillis();
    }

    @Override
    public SecurityResult.ResultStatus getStatus() {
        return this.status;
    }

    public void setStatus(SecurityResult.ResultStatus status) {
        this.status = status;
    }

    public SecurityScan getSecurityScan() {
        return this.securityCheck;
    }

    @Override
    public ActionList getActions() {
        if (this.actionList == null) {
            this.actionList = new DefaultActionList(this.getSecurityScan().getName());
        }
        if (!this.addedAction) {
            this.actionList.addAction(new ShowMessageExchangeAction(this.getMessageExchange(), "SecurityScanRequest"), true);
            this.addedAction = true;
        }
        return this.actionList;
    }

    public String[] getMessages() {
        return this.messages == null ? EMPTY_MESSAGES : this.messages.toArray(new String[this.messages.size()]);
    }

    public void addMessage(String message) {
        if (this.messages != null) {
            this.messages.add(message);
        }
    }

    public long getTimeTaken() {
        return this.timeTaken;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public long getSize() {
        return this.size;
    }

    public void writeTo(PrintWriter writer) {
    }

    public void discard() {
    }

    public boolean isDiscarded() {
        return this.discarded;
    }

    public MessageExchange getMessageExchange() {
        return this.messageExchange;
    }

    public void setMessageExchange(MessageExchange messageExchange) {
        this.messageExchange = messageExchange;
    }

    public void setTimeTaken(long timeTaken) {
        this.timeTaken = timeTaken;
    }

    public void startTimer() {
        this.startTime = System.nanoTime();
    }

    public void stopTimer() {
        this.timeTaken = (System.nanoTime() - this.startTime) / 1000000L;
    }

    @Override
    public String getResultType() {
        return TYPE;
    }

    @Override
    public SecurityResult.ResultStatus getExecutionProgressStatus() {
        return null;
    }

    @Override
    public SecurityResult.ResultStatus getLogIconStatus() {
        return null;
    }

    public String getChangedParamsInfo(int requestCount) {
        StringToStringMap changedParams = null;
        changedParams = this.getMessageExchange() != null && this.getMessageExchange().getProperties() != null ? StringToStringMap.fromXml((String)this.getMessageExchange().getProperties().get("SecurityChangedParameters")) : new StringToStringMap();
        StringBuilder changedParamsInfo = new StringBuilder();
        changedParamsInfo.append("[");
        for (String param : changedParams.keySet()) {
            String value = (String)changedParams.get(param);
            if (value.length() > 100) {
                value = value.substring(0, 100);
            }
            changedParamsInfo.append(param + "=" + value + ",");
        }
        changedParamsInfo.replace(changedParamsInfo.length() - 1, changedParamsInfo.length(), "]");
        StringBuilder checkRequestResultStr = new StringBuilder("[" + this.getSecurityScan().getName() + "] Request " + requestCount + " - " + (Object)((Object)this.getStatus()));
        if (changedParamsInfo.length() > 1) {
            checkRequestResultStr.append(" - " + changedParamsInfo.toString());
        }
        checkRequestResultStr.append(": took ").append(this.getTimeTaken()).append(" ms");
        return checkRequestResultStr.toString();
    }

    public void release() {
        this.securityCheck = null;
    }
}

