/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.tree.nodes.support;

import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.model.support.TestSuiteListenerAdapter;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestSuiteListener;
import com.eviware.soapui.model.tree.nodes.support.EmptyModelItem;
import com.eviware.soapui.security.SecurityTest;
import com.eviware.soapui.support.UISupport;

public class SecurityTestsModelItem
extends EmptyModelItem {
    private TestCase testCase;
    private TestSuiteListener listener = new InternalTestSuiteListener();

    public SecurityTestsModelItem(TestCase testCase) {
        super(SecurityTestsModelItem.createLabel(testCase), UISupport.createImageIcon("/security_tests.gif"));
        this.testCase = testCase;
        testCase.getTestSuite().addTestSuiteListener(this.listener);
    }

    private static String createLabel(TestCase testCase) {
        return "Security Tests (" + testCase.getSecurityTestCount() + ")";
    }

    @Override
    public Settings getSettings() {
        return this.testCase.getSettings();
    }

    @Override
    public void release() {
        super.release();
        this.testCase.getTestSuite().removeTestSuiteListener(this.listener);
    }

    @Override
    public String getName() {
        return SecurityTestsModelItem.createLabel(this.testCase);
    }

    public void updateLabel() {
        this.setName(SecurityTestsModelItem.createLabel(this.testCase));
    }

    public class InternalTestSuiteListener
    extends TestSuiteListenerAdapter
    implements TestSuiteListener {
        @Override
        public void securityTestAdded(SecurityTest securityTest) {
            if (securityTest.getTestCase() == SecurityTestsModelItem.this.testCase) {
                SecurityTestsModelItem.this.updateLabel();
            }
        }

        @Override
        public void securityTestRemoved(SecurityTest securityTest) {
            if (securityTest.getTestCase() == SecurityTestsModelItem.this.testCase) {
                SecurityTestsModelItem.this.updateLabel();
            }
        }

        @Override
        public void testCaseRemoved(TestCase testCase) {
            if (testCase == SecurityTestsModelItem.this.testCase) {
                testCase.getTestSuite().removeTestSuiteListener(SecurityTestsModelItem.this.listener);
            }
        }
    }
}

