/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.assertions.basic;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.TestAssertionConfig;
import com.eviware.soapui.impl.rest.RestResource;
import com.eviware.soapui.impl.rest.RestService;
import com.eviware.soapui.impl.support.AbstractInterface;
import com.eviware.soapui.impl.support.DefinitionContext;
import com.eviware.soapui.impl.wadl.WadlDefinitionContext;
import com.eviware.soapui.impl.wadl.support.WadlValidator;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.panels.assertions.AssertionListEntry;
import com.eviware.soapui.impl.wsdl.submit.RestMessageExchange;
import com.eviware.soapui.impl.wsdl.submit.WsdlMessageExchange;
import com.eviware.soapui.impl.wsdl.support.PathUtils;
import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlContext;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlValidator;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.AbstractTestAssertionFactory;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.model.testsuite.AssertionException;
import com.eviware.soapui.model.testsuite.RequestAssertion;
import com.eviware.soapui.model.testsuite.ResponseAssertion;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.xmlbeans.XmlObject;

public class SchemaComplianceAssertion
extends WsdlMessageAssertion
implements RequestAssertion,
ResponseAssertion {
    public static final String ID = "Schema Compliance";
    public static final String LABEL = "Schema Compliance";
    private String definition;
    private DefinitionContext<?> definitionContext;
    private String wsdlContextDef;
    private static Map<String, WsdlContext> wsdlContextMap = new HashMap<String, WsdlContext>();
    private static final String SCHEMA_COMPLIANCE_HAS_CLEARED_CACHE_FLAG = SchemaComplianceAssertion.class.getName() + "@SchemaComplianceHasClearedCacheFlag";
    public static final String DESCRIPTION = "Validates that the last received message is compliant with the associated WSDL or WADL schema definition. Applicable to SOAP and REST TestSteps.";

    public SchemaComplianceAssertion(TestAssertionConfig assertionConfig, Assertable assertable) {
        super(assertionConfig, assertable, false, true, false, true);
        XmlObjectConfigurationReader reader = new XmlObjectConfigurationReader(this.getConfiguration());
        this.definition = reader.readString("definition", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare(TestCaseRunner testRunner, TestCaseRunContext testRunContext) throws Exception {
        TestCaseRunContext context;
        super.prepare(testRunner, testRunContext);
        this.definitionContext = null;
        this.wsdlContextDef = null;
        TestCaseRunContext testCaseRunContext = context = testRunContext.hasProperty("LoadTestContext") ? (PropertyExpansionContext)testRunContext.getProperty("LoadTestContext") : testRunContext;
        synchronized (testCaseRunContext) {
            if (!context.hasProperty(SCHEMA_COMPLIANCE_HAS_CLEARED_CACHE_FLAG)) {
                wsdlContextMap.clear();
                context.setProperty(SCHEMA_COMPLIANCE_HAS_CLEARED_CACHE_FLAG, "yep!");
            }
        }
    }

    @Override
    protected String internalAssertResponse(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        if (messageExchange instanceof WsdlMessageExchange) {
            return this.assertWsdlResponse((WsdlMessageExchange)messageExchange, context);
        }
        if (messageExchange instanceof RestMessageExchange) {
            return this.assertWadlResponse((RestMessageExchange)messageExchange, context);
        }
        throw new AssertionException(new AssertionError("Unknown MessageExchange type"));
    }

    @Override
    protected String internalAssertProperty(TestPropertyHolder source, String propertyName, MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        return null;
    }

    private String assertWadlResponse(RestMessageExchange messageExchange, SubmitContext context) throws AssertionException {
        WadlDefinitionContext wadlContext = null;
        try {
            this.definitionContext = this.getWadlContext(messageExchange, context);
        }
        catch (Exception e1) {
            throw new AssertionException(new AssertionError(e1.getMessage()));
        }
        WadlValidator validator = new WadlValidator(wadlContext);
        try {
            AssertionError[] errors = validator.assertResponse(messageExchange);
            if (errors.length > 0) {
                throw new AssertionException(errors);
            }
        }
        catch (AssertionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AssertionException(new AssertionError(e.getMessage()));
        }
        return "Schema compliance OK";
    }

    private String assertWsdlResponse(WsdlMessageExchange messageExchange, SubmitContext context) throws AssertionException {
        WsdlContext wsdlContext;
        try {
            wsdlContext = (WsdlContext)this.getWsdlContext(messageExchange, context);
        }
        catch (Exception e1) {
            throw new AssertionException(new AssertionError(e1.getMessage()));
        }
        WsdlValidator validator = new WsdlValidator(wsdlContext);
        try {
            AssertionError[] errors = validator.assertResponse(messageExchange, false);
            if (errors.length > 0) {
                throw new AssertionException(errors);
            }
        }
        catch (AssertionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AssertionException(new AssertionError(e.getMessage()));
        }
        return "Schema compliance OK";
    }

    private DefinitionContext<?> getWsdlContext(WsdlMessageExchange messageExchange, SubmitContext context) throws Exception {
        WsdlOperation operation = messageExchange.getOperation();
        WsdlInterface iface = operation.getInterface();
        String def = PathUtils.expandPath(this.definition, iface, context);
        if (StringUtils.isNullOrEmpty(def) || def.equals(iface.getDefinition())) {
            this.definitionContext = iface.getWsdlContext();
            this.definitionContext.loadIfNecessary();
        } else if (this.definitionContext == null || !def.equals(this.wsdlContextDef)) {
            this.definitionContext = this.getContext(def, iface.getSoapVersion());
            ((WsdlContext)this.definitionContext).setInterface(iface);
            this.wsdlContextDef = def;
        }
        return this.definitionContext;
    }

    private synchronized WsdlContext getContext(String wsdlLocation, SoapVersion soapVersion) throws Exception {
        if (wsdlContextMap.containsKey(wsdlLocation)) {
            return wsdlContextMap.get(wsdlLocation);
        }
        WsdlContext newWsdlContext = new WsdlContext(wsdlLocation, soapVersion);
        newWsdlContext.load();
        wsdlContextMap.put(wsdlLocation, newWsdlContext);
        return newWsdlContext;
    }

    private DefinitionContext<?> getWadlContext(RestMessageExchange messageExchange, SubmitContext context) throws Exception {
        RestResource operation = messageExchange.getResource();
        RestService service = operation.getService();
        if (StringUtils.isNullOrEmpty(this.definition) || this.definition.equals(PathUtils.expandPath(service.getDefinition(), service, context))) {
            this.definitionContext = service.getWadlContext();
            this.definitionContext.loadIfNecessary();
        } else {
            String def = PathUtils.expandPath(this.definition, service, context);
            if (this.definitionContext == null || !def.equals(this.wsdlContextDef)) {
                this.definitionContext = new WadlDefinitionContext(def);
                ((WadlDefinitionContext)this.definitionContext).load();
                ((WadlDefinitionContext)this.definitionContext).setInterface(service);
                this.wsdlContextDef = def;
            }
        }
        return this.definitionContext;
    }

    @Override
    public boolean configure() {
        String orgDef;
        String definitionURL = this.definition;
        AbstractInterface iface = (AbstractInterface)this.getAssertable().getInterface();
        String string = orgDef = iface == null ? null : iface.getDefinition();
        if (StringUtils.isNullOrEmpty(definitionURL)) {
            definitionURL = orgDef;
        }
        if ((definitionURL = UISupport.prompt("Specify definition url to validate by", "Configure Schema Compliance Assertion", definitionURL)) == null) {
            return false;
        }
        if (!this.canLoadDefinitionFrom(definitionURL)) {
            UISupport.showErrorMessage("No valid definition found in " + definitionURL + ". Only WSDL and WADL are supported");
            return false;
        }
        this.definition = StringUtils.isNullOrEmpty(definitionURL) || definitionURL.equals(orgDef) ? "" : definitionURL;
        this.setConfiguration(this.createConfiguration());
        return true;
    }

    private boolean canLoadDefinitionFrom(String definitionURL) {
        try {
            new WsdlContext(definitionURL).load();
            return true;
        }
        catch (Exception e) {
            try {
                new WadlDefinitionContext(definitionURL).load();
                return true;
            }
            catch (Exception e1) {
                return false;
            }
        }
    }

    protected XmlObject createConfiguration() {
        XmlObjectConfigurationBuilder builder = new XmlObjectConfigurationBuilder();
        return builder.add("definition", this.definition).finish();
    }

    @Override
    protected String internalAssertRequest(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        WsdlContext wsdlContext;
        try {
            wsdlContext = (WsdlContext)this.getWsdlContext((WsdlMessageExchange)messageExchange, context);
        }
        catch (Exception e1) {
            throw new AssertionException(new AssertionError(e1.getMessage()));
        }
        WsdlValidator validator = new WsdlValidator(wsdlContext);
        try {
            AssertionError[] errors = validator.assertRequest((WsdlMessageExchange)messageExchange, false);
            if (errors.length > 0) {
                throw new AssertionException(errors);
            }
        }
        catch (AssertionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AssertionException(new AssertionError(e.getMessage()));
        }
        return "Schema compliance OK";
    }

    public static class Factory
    extends AbstractTestAssertionFactory {
        public Factory() {
            super("Schema Compliance", "Schema Compliance", SchemaComplianceAssertion.class);
        }

        @Override
        public String getCategory() {
            return "Compliance, Status and Standards";
        }

        @Override
        public boolean canAssert(Assertable assertable) {
            try {
                return super.canAssert(assertable) && assertable.getInterface() instanceof AbstractInterface && ((AbstractInterface)assertable.getInterface()).getDefinitionContext().hasSchemaTypes();
            }
            catch (Throwable e) {
                SoapUI.logError(e);
                return false;
            }
        }

        @Override
        public Class<? extends WsdlMessageAssertion> getAssertionClassType() {
            return SchemaComplianceAssertion.class;
        }

        @Override
        public AssertionListEntry getAssertionListEntry() {
            return new AssertionListEntry("Schema Compliance", "Schema Compliance", SchemaComplianceAssertion.DESCRIPTION);
        }
    }
}

