/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.assertions.basic;

import com.eviware.soapui.config.TestAssertionConfig;
import com.eviware.soapui.impl.wsdl.panels.assertions.AssertionListEntry;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.AbstractTestAssertionFactory;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.iface.Response;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.model.testsuite.AssertionException;
import com.eviware.soapui.model.testsuite.ResponseAssertion;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import org.apache.xmlbeans.XmlObject;

public class ResponseSLAAssertion
extends WsdlMessageAssertion
implements ResponseAssertion {
    public static final String ID = "Response SLA Assertion";
    public static final String LABEL = "Response SLA";
    public static final String DESCRIPTION = "Validates that the last received response time was within the defined limit. Applicable to Script TestSteps and TestSteps that send requests and receive responses.";
    private String SLA;

    public ResponseSLAAssertion(TestAssertionConfig assertionConfig, Assertable modelItem) {
        super(assertionConfig, modelItem, false, true, false, false);
        XmlObjectConfigurationReader reader = new XmlObjectConfigurationReader(this.getConfiguration());
        this.SLA = reader.readString("SLA", "200");
    }

    @Override
    protected String internalAssertRequest(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        return null;
    }

    @Override
    protected String internalAssertResponse(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        long timeTaken;
        Response response = messageExchange.getResponse();
        long l = timeTaken = response == null ? messageExchange.getTimeTaken() : response.getTimeTaken();
        if (timeTaken > Long.parseLong(PropertyExpander.expandProperties(context, this.SLA))) {
            throw new AssertionException(new AssertionError("Response did not meet SLA " + timeTaken + "/" + this.SLA));
        }
        return "Response meets SLA";
    }

    @Override
    protected String internalAssertProperty(TestPropertyHolder source, String propertyName, MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        return null;
    }

    @Override
    public boolean configure() {
        String value = this.SLA;
        if (value == null || value.trim().length() == 0) {
            value = "200";
        }
        value = UISupport.prompt("Specify maximum response time (ms)", "Configure Response SLA Assertion", value);
        try {
            Long.parseLong(value);
            this.SLA = value;
        }
        catch (Exception e) {
            return false;
        }
        this.setConfiguration(this.createConfiguration());
        return true;
    }

    public String getSLA() {
        return this.SLA;
    }

    public void setSLA(String sla) {
        this.SLA = sla;
        this.setConfiguration(this.createConfiguration());
    }

    protected XmlObject createConfiguration() {
        XmlObjectConfigurationBuilder builder = new XmlObjectConfigurationBuilder();
        return builder.add("SLA", this.SLA).finish();
    }

    public static class Factory
    extends AbstractTestAssertionFactory {
        public Factory() {
            super(ResponseSLAAssertion.ID, ResponseSLAAssertion.LABEL, ResponseSLAAssertion.class);
        }

        @Override
        public String getCategory() {
            return "SLA";
        }

        @Override
        public Class<? extends WsdlMessageAssertion> getAssertionClassType() {
            return ResponseSLAAssertion.class;
        }

        @Override
        public AssertionListEntry getAssertionListEntry() {
            return new AssertionListEntry(ResponseSLAAssertion.ID, ResponseSLAAssertion.LABEL, ResponseSLAAssertion.DESCRIPTION);
        }
    }
}

