/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.actions;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.teststeps.PropertyTransfersTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepResult;
import com.eviware.soapui.support.DescriptionPanel;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.swing.JTableFactory;
import com.eviware.soapui.ui.desktop.DesktopPanel;
import com.eviware.soapui.ui.support.DefaultDesktopPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.AbstractTableModel;
import org.jdesktop.swingx.JXTable;

public class ShowTransferValuesResultsAction
extends AbstractAction {
    private final PropertyTransfersTestStep.PropertyTransferResult result;
    private DefaultDesktopPanel desktopPanel;

    public ShowTransferValuesResultsAction(WsdlTestStepResult result) {
        this.result = (PropertyTransfersTestStep.PropertyTransferResult)result;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (this.result.isDiscarded()) {
                UISupport.showInfoMessage("Request has been discarded..");
            } else {
                this.showDesktopPanel();
            }
        }
        catch (Exception ex) {
            SoapUI.logError(ex);
        }
    }

    public DesktopPanel showDesktopPanel() {
        return UISupport.showDesktopPanel(this.buildFrame());
    }

    private DesktopPanel buildFrame() {
        if (this.desktopPanel == null) {
            this.desktopPanel = new DefaultDesktopPanel("TestStep Result", "TestStep result for " + this.result.getTestStep().getName(), this.buildContent());
        }
        return this.desktopPanel;
    }

    private JComponent buildContent() {
        JPanel panel = new JPanel(new BorderLayout());
        JXTable table = JTableFactory.getInstance().makeJXTable(new TransfersTableModel());
        table.setHorizontalScrollEnabled(true);
        table.packAll();
        DescriptionPanel descriptionPanel = UISupport.buildDescription("PropertyTransfer Results", "See the result of each performed transfer below", null);
        panel.add((Component)descriptionPanel, "North");
        JScrollPane scrollPane = new JScrollPane((Component)table);
        scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), scrollPane.getBorder()));
        panel.add((Component)scrollPane, "Center");
        panel.setPreferredSize(new Dimension(550, 300));
        return panel;
    }

    private class TransfersTableModel
    extends AbstractTableModel {
        private TransfersTableModel() {
        }

        @Override
        public int getRowCount() {
            return ShowTransferValuesResultsAction.this.result.getTransferCount();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Transfer Name";
                }
                case 1: {
                    return "Transferred Values";
                }
            }
            return null;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ShowTransferValuesResultsAction.this.result.getTransferAt(rowIndex).getName();
                }
                case 1: {
                    return Arrays.toString(ShowTransferValuesResultsAction.this.result.getTransferredValuesAt(rowIndex));
                }
            }
            return null;
        }
    }
}

