/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.actions;

import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequest;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStep;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.soapui.support.xml.XmlUtils;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;

public class ChangeOperationAction
extends AbstractSoapUIAction<WsdlTestRequestStep> {
    private XFormDialog dialog;
    private WsdlTestRequestStep testStep;

    public ChangeOperationAction() {
        super("Change Operation", "Changes the Interface Operation for this Test Request");
    }

    @Override
    public void perform(WsdlTestRequestStep target, Object param) {
        this.testStep = target;
        if (this.dialog == null) {
            this.dialog = ADialogBuilder.buildDialog(Form.class);
            this.dialog.getFormField("Interface").addFormFieldListener(new XFormFieldListener(){

                @Override
                public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                    WsdlProject project = ChangeOperationAction.this.testStep.getTestCase().getTestSuite().getProject();
                    ChangeOperationAction.this.dialog.setOptions("Operation", ModelSupport.getNames(project.getInterfaceByName(newValue).getOperationList()));
                    ChangeOperationAction.this.dialog.setValue("Operation", ChangeOperationAction.this.testStep.getOperationName());
                }
            });
            this.dialog.getFormField("Recreate Request").addFormFieldListener(new XFormFieldListener(){

                @Override
                public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                    boolean enabled = Boolean.parseBoolean(newValue);
                    ChangeOperationAction.this.dialog.getFormField("Create Optional").setEnabled(enabled);
                    ChangeOperationAction.this.dialog.getFormField("Keep Existing").setEnabled(enabled);
                }
            });
            this.dialog.getFormField("Create Optional").setEnabled(false);
            this.dialog.getFormField("Keep Existing").setEnabled(false);
        }
        WsdlProject project = target.getTestCase().getTestSuite().getProject();
        this.dialog.setOptions("Interface", ModelSupport.getNames(project.getInterfaceList(), new ModelSupport.InterfaceTypeFilter("wsdl")));
        this.dialog.setValue("Interface", target.getInterfaceName());
        this.dialog.setOptions("Operation", ModelSupport.getNames(project.getInterfaceByName(target.getInterfaceName()).getOperationList()));
        this.dialog.setValue("Operation", target.getOperationName());
        this.dialog.setValue("Name", target.getName());
        if (this.dialog.show()) {
            String ifaceName = this.dialog.getValue("Interface");
            String operationName = this.dialog.getValue("Operation");
            WsdlInterface iface = (WsdlInterface)project.getInterfaceByName(ifaceName);
            WsdlOperation operation = iface.getOperationByName(operationName);
            target.setOperation(operation);
            String name = this.dialog.getValue("Name").trim();
            if (name.length() > 0 && !target.getName().equals(name)) {
                target.setName(name);
            }
            if (this.dialog.getBooleanValue("Recreate Request")) {
                String req = operation.createRequest(this.dialog.getBooleanValue("Create Optional"));
                if (req == null) {
                    UISupport.showErrorMessage("Request creation failed");
                    return;
                }
                WsdlTestRequest request = target.getTestRequest();
                if (this.dialog.getBooleanValue("Keep Existing")) {
                    req = XmlUtils.transferValues(request.getRequestContent(), req);
                }
                request.setRequestContent(req);
            }
        }
    }

    @AForm(description="Specify Interface/Operation for TestRequest", name="Change Operation", helpUrl="http://www.soapui.org/Functional-Testing/testrequest-editor.html", icon="/applications-system.png")
    protected static interface Form {
        @AField(name="Name", description="The Name of the TestRequests", type=AField.AFieldType.STRING)
        public static final String NAME = "Name";
        @AField(name="Interface", description="The TestRequests' Interface", type=AField.AFieldType.ENUMERATION)
        public static final String INTERFACE = "Interface";
        @AField(name="Operation", description="The TestRequests' Operation", type=AField.AFieldType.ENUMERATION)
        public static final String OPERATION = "Operation";
        @AField(name="Recreate Request", description="Recreates the request content from the new Operations Definition", type=AField.AFieldType.BOOLEAN)
        public static final String RECREATE_REQUEST = "Recreate Request";
        @AField(name="Create Optional", description="Creates optional content when recreating the request", type=AField.AFieldType.BOOLEAN)
        public static final String CREATE_OPTIONAL = "Create Optional";
        @AField(name="Keep Existing", description="Tries to keep existing values when recreating the request", type=AField.AFieldType.BOOLEAN)
        public static final String KEEP_EXISTING = "Keep Existing";
    }
}

