/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.ManualTestStepConfig;
import com.eviware.soapui.config.TestStepConfig;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.ManualTestStepResult;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequest;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepWithProperties;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContainer;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionUtils;
import com.eviware.soapui.model.support.DefaultTestStepProperty;
import com.eviware.soapui.model.support.TestStepBeanProperty;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormOptionsField;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import com.eviware.x.impl.swing.JFormDialog;
import java.awt.Dialog;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ManualTestStep
extends WsdlTestStepWithProperties
implements PropertyExpansionContainer {
    private static final Logger log = Logger.getLogger(WsdlTestRequestStep.class);
    protected ManualTestStepConfig manualTestStepConfig;
    private ManualTestStepResult testStepResult;
    public static final String MANUAL_STEP = ManualTestStep.class.getName() + "@manualstep";
    public static final String STATUS_PROPERTY = WsdlTestRequest.class.getName() + "@status";
    private final boolean forLoadTest;

    public ManualTestStep(WsdlTestCase testCase, TestStepConfig config, boolean forLoadTest) {
        super(testCase, config, true, forLoadTest);
        this.forLoadTest = forLoadTest;
        if (!forLoadTest) {
            this.setIcon(UISupport.createImageIcon("/manualteststep.gif"));
        }
        this.manualTestStepConfig = ((TestStepConfig)this.getConfig()).getConfig() != null ? (ManualTestStepConfig)((TestStepConfig)this.getConfig()).getConfig().changeType(ManualTestStepConfig.type) : (ManualTestStepConfig)((TestStepConfig)this.getConfig()).addNewConfig().changeType(ManualTestStepConfig.type);
        this.addProperty(new DefaultTestStepProperty("Result", true, new DefaultTestStepProperty.PropertyHandlerAdapter(){

            @Override
            public String getValue(DefaultTestStepProperty property) {
                return ManualTestStep.this.getLastResult() == null ? null : ManualTestStep.this.getLastResult().getResult();
            }
        }, this));
        this.addProperty(new TestStepBeanProperty("ExpectedResult", false, this, "expectedResult", this));
    }

    protected ManualTestStepResult getLastResult() {
        return this.testStepResult;
    }

    public ManualTestStepConfig getManualTestStepConfig() {
        return this.manualTestStepConfig;
    }

    @Override
    public WsdlTestStep clone(WsdlTestCase targetTestCase, String name) {
        this.beforeSave();
        TestStepConfig config = (TestStepConfig)((TestStepConfig)this.getConfig()).copy();
        ManualTestStep result = (ManualTestStep)targetTestCase.addTestStep(config);
        return result;
    }

    @Override
    public void release() {
        super.release();
    }

    @Override
    public TestStepResult run(TestCaseRunner runner, TestCaseRunContext runContext) {
        this.testStepResult = new ManualTestStepResult(this);
        this.testStepResult.startTimer();
        if (!this.forLoadTest && SoapUI.usingGraphicalEnvironment()) {
            XFormDialog dialog = ADialogBuilder.buildDialog(Form.class);
            dialog.setSize(450, 550);
            ((JFormDialog)dialog).getDialog().setModalityType(Dialog.ModalityType.MODELESS);
            dialog.setValue("Description", runContext.expand(this.getDescription()));
            dialog.setValue("Expected Result", runContext.expand(this.getExpectedResult()));
            dialog.setValue("Result Status", "Unknown");
            UISupport.select(this);
            while (!dialog.show()) {
                if (!UISupport.confirm("Are you sure? This will stop the entire test", "Cancel TestStep")) continue;
                this.testStepResult.setStatus(TestStepResult.TestStepStatus.CANCELED);
                runner.cancel("Canceled by user");
                break;
            }
            if (dialog.getValue("Result Status").equals("Pass")) {
                this.testStepResult.setStatus(TestStepResult.TestStepStatus.OK);
            } else if (dialog.getValue("Result Status").equals("Fail")) {
                this.testStepResult.setStatus(TestStepResult.TestStepStatus.FAILED);
            }
            String result = dialog.getValue("Result");
            if (StringUtils.hasContent(result)) {
                this.testStepResult.setResult(result);
            }
            this.testStepResult.setUrls(((XFormOptionsField)dialog.getFormField("URLs")).getOptions());
            dialog.release();
        }
        this.testStepResult.stopTimer();
        return this.testStepResult;
    }

    @Override
    public boolean cancel() {
        return true;
    }

    @Override
    public String getDefaultSourcePropertyName() {
        return "Result";
    }

    @Override
    public String getDefaultTargetPropertyName() {
        return "ExpectedResult";
    }

    @Override
    public PropertyExpansion[] getPropertyExpansions() {
        ArrayList<PropertyExpansion> result = new ArrayList<PropertyExpansion>();
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(this, this, "description"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(this, this, "expectedResult"));
        return result.toArray(new PropertyExpansion[result.size()]);
    }

    public String getExpectedResult() {
        return this.manualTestStepConfig.getExpectedResult();
    }

    public void setExpectedResult(String expectedResult) {
        String old = this.getExpectedResult();
        if (String.valueOf(old).equals(expectedResult)) {
            return;
        }
        this.manualTestStepConfig.setExpectedResult(expectedResult);
        this.notifyPropertyChanged("expectedResult", old, expectedResult);
        this.firePropertyValueChanged("ExpectedResult", old, expectedResult);
    }

    @Override
    public void resetConfigOnMove(TestStepConfig config) {
        super.resetConfigOnMove(config);
        this.manualTestStepConfig = (ManualTestStepConfig)config.getConfig().changeType(ManualTestStepConfig.type);
    }

    @AForm(description="", name="Run Manual TestStep", helpUrl="http://www.soapui.org/functional-testing/manual-teststep.html")
    protected static interface Form {
        @AField(name="Description", description="Describes the actions to perform", type=AField.AFieldType.INFORMATION)
        public static final String DESCRIPTION = "Description";
        @AField(name="Expected Result", description="Describes the actions to perform", type=AField.AFieldType.INFORMATION)
        public static final String EXPECTED_DESULT = "Expected Result";
        @AField(name="Result", description="an optional result description or value", type=AField.AFieldType.STRINGAREA)
        public static final String RESULT = "Result";
        @AField(name="URLs", description="A list of URLs related to the result", type=AField.AFieldType.STRINGLIST)
        public static final String URLS = "URLs";
        @AField(name="Result Status", description="The result status", type=AField.AFieldType.ENUMERATION, values={"Pass", "Fail", "Unknown"})
        public static final String STATUS = "Result Status";
    }
}

