/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.wsa;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.AnonymousTypeConfig;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.WsaAssertionConfiguration;
import com.eviware.soapui.impl.wsdl.submit.WsdlMessageExchange;
import com.eviware.soapui.impl.wsdl.support.soap.SoapUtils;
import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import com.eviware.soapui.impl.wsdl.support.wsa.WsaUtils;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlUtils;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.model.testsuite.AssertionException;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.xml.XmlUtils;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WsaValidator {
    WsdlMessageExchange messageExchange;
    Element header;
    String wsaVersionNameSpace;
    StringBuilder cumulativeErrorMsg;
    WsaAssertionConfiguration wsaAssertionConfiguration;

    public WsaValidator(WsdlMessageExchange messageExchange, WsaAssertionConfiguration wsaAssertionConfiguration) {
        this.messageExchange = messageExchange;
        this.wsaAssertionConfiguration = wsaAssertionConfiguration;
        this.cumulativeErrorMsg = new StringBuilder();
    }

    public static String getWsaVersion(XmlObject contentObject, SoapVersion soapVersion) {
        String wsaVns;
        block7: {
            wsaVns = null;
            try {
                XmlObject[] envS = contentObject.selectChildren(soapVersion.getEnvelopeQName());
                Element envelope = (Element)envS[0].getDomNode();
                Element hdr = (Element)SoapUtils.getHeaderElement(contentObject, soapVersion, true).getDomNode();
                if (!hdr.hasChildNodes()) {
                    return null;
                }
                String wsaNameSpace = XmlUtils.findPrefixForNamespace(hdr, "http://www.w3.org/2005/08/addressing");
                if (wsaNameSpace != null) {
                    wsaVns = "http://www.w3.org/2005/08/addressing";
                    break block7;
                }
                wsaNameSpace = XmlUtils.findPrefixForNamespace(hdr, "http://schemas.xmlsoap.org/ws/2004/08/addressing");
                if (wsaNameSpace != null) {
                    wsaVns = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
                    break block7;
                }
                wsaNameSpace = XmlUtils.findPrefixForNamespace(envelope, "http://www.w3.org/2005/08/addressing");
                if (wsaNameSpace != null) {
                    wsaVns = "http://www.w3.org/2005/08/addressing";
                    break block7;
                }
                wsaNameSpace = XmlUtils.findPrefixForNamespace(envelope, "http://schemas.xmlsoap.org/ws/2004/08/addressing");
                if (wsaNameSpace != null) {
                    wsaVns = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
                    break block7;
                }
                return null;
            }
            catch (XmlException e) {
                SoapUI.logError(e);
            }
        }
        return wsaVns;
    }

    private void validateWsAddressingCommon(String content) {
        String faultToAddressValue;
        Element addressNode;
        Element faultToNode;
        if (this.wsaAssertionConfiguration.isAssertTo()) {
            Element toNode;
            if (this.wsaVersionNameSpace != null) {
                toNode = XmlUtils.getFirstChildElementNS(this.header, this.wsaVersionNameSpace, "To");
                this.parseToNode(toNode);
            } else {
                toNode = XmlUtils.getFirstChildElementNS(this.header, "http://www.w3.org/2005/08/addressing", "To");
                if (toNode == null) {
                    toNode = XmlUtils.getFirstChildElementNS(this.header, "http://schemas.xmlsoap.org/ws/2004/08/addressing", "To");
                }
                this.parseToNode(toNode);
            }
        }
        if ((faultToNode = XmlUtils.getFirstChildElementNS(this.header, this.wsaVersionNameSpace, "FaultTo")) != null && (addressNode = XmlUtils.getFirstChildElementNS(faultToNode, this.wsaVersionNameSpace, "Address")) != null && !StringUtils.isNullOrEmpty(faultToAddressValue = XmlUtils.getElementText(addressNode))) {
            if (AnonymousTypeConfig.PROHIBITED.toString().equals(this.messageExchange.getOperation().getAnonymous()) && WsaUtils.isAnonymousAddress(faultToAddressValue, this.wsaVersionNameSpace)) {
                this.cumulativeErrorMsg.append("WS-A InvalidAddressingHeader FaultTo , Anonymous addresses are prohibited. ");
            } else if (AnonymousTypeConfig.REQUIRED.toString().equals(this.messageExchange.getOperation().getAnonymous()) && !WsaUtils.isAnonymousAddress(faultToAddressValue, this.wsaVersionNameSpace) && !WsaUtils.isNoneAddress(faultToAddressValue, this.wsaVersionNameSpace)) {
                this.cumulativeErrorMsg.append("WS-A InvalidAddressingHeader FaultTo , Anonymous addresses are required. ");
            }
        }
    }

    private void parseToNode(Element toNode) {
        if (toNode == null) {
            this.cumulativeErrorMsg.append("WS-A To property is not specified. ");
        } else {
            String toAddressValue = XmlUtils.getElementText(toNode);
            if (StringUtils.isNullOrEmpty(toAddressValue)) {
                this.cumulativeErrorMsg.append("WS-A To property is empty. ");
            } else if (AnonymousTypeConfig.PROHIBITED.toString().equals(this.messageExchange.getOperation().getAnonymous()) && WsaUtils.isAnonymousAddress(toAddressValue, this.wsaVersionNameSpace)) {
                this.cumulativeErrorMsg.append("WS-A InvalidAddressingHeader To , Anonymous addresses are prohibited. ");
            }
        }
    }

    public void validateWsAddressingRequest() throws AssertionException, XmlException {
        String cumulativeError;
        String content = this.messageExchange.getRequestContent();
        SoapVersion soapVersion = this.messageExchange.getOperation().getInterface().getSoapVersion();
        XmlObject xmlObject = XmlUtils.createXmlObject(content);
        this.header = (Element)SoapUtils.getHeaderElement(xmlObject, soapVersion, true).getDomNode();
        this.wsaVersionNameSpace = WsaValidator.getWsaVersion(xmlObject, soapVersion);
        WsdlOperation operation = this.messageExchange.getOperation();
        if (this.wsaAssertionConfiguration.isAssertAction()) {
            this.assertProperty("Wsa:Action", "Action");
        }
        this.validateWsAddressingCommon(content);
        if (operation.isRequestResponse()) {
            if (this.wsaAssertionConfiguration.isAssertMessageId()) {
                this.assertProperty("Wsa:MessageId", "MessageId");
            }
            if (this.wsaAssertionConfiguration.isAssertReplyTo()) {
                Element replyToNode;
                if (!StringUtils.isNullOrEmpty(this.wsaVersionNameSpace)) {
                    replyToNode = XmlUtils.getFirstChildElementNS(this.header, this.wsaVersionNameSpace, "ReplyTo");
                    this.parseReplyToNode(replyToNode, this.wsaVersionNameSpace);
                } else {
                    replyToNode = XmlUtils.getFirstChildElementNS(this.header, "http://www.w3.org/2005/08/addressing", "ReplyTo");
                    String currentTagWsaNs = "http://www.w3.org/2005/08/addressing";
                    if (replyToNode == null) {
                        replyToNode = XmlUtils.getFirstChildElementNS(this.header, "http://schemas.xmlsoap.org/ws/2004/08/addressing", "ReplyTo");
                        currentTagWsaNs = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
                    }
                    this.parseReplyToNode(replyToNode, currentTagWsaNs);
                }
            }
        }
        if (!StringUtils.isNullOrEmpty(cumulativeError = this.cumulativeErrorMsg.toString())) {
            throw new AssertionException(new AssertionError(cumulativeError));
        }
    }

    private void parseReplyToNode(Element replyToNode, String wsaNsStr) {
        if (replyToNode == null) {
            this.cumulativeErrorMsg.append("WS-A ReplyTo property is not specified. ");
        } else {
            Element addressNode = XmlUtils.getFirstChildElementNS(replyToNode, wsaNsStr, "Address");
            if (addressNode == null) {
                this.cumulativeErrorMsg.append("WS-A ReplyTo Address property is not specified. ");
            } else {
                String replyToAddressValue = XmlUtils.getElementText(addressNode);
                if (StringUtils.isNullOrEmpty(replyToAddressValue)) {
                    this.cumulativeErrorMsg.append("WS-A ReplyTo Address property is empty. ");
                } else if (AnonymousTypeConfig.PROHIBITED.toString().equals(this.messageExchange.getOperation().getAnonymous()) && WsaUtils.isAnonymousAddress(replyToAddressValue, wsaNsStr)) {
                    this.cumulativeErrorMsg.append("WS-A InvalidAddressingHeader ReplyTo , Anonymous addresses are prohibited. ");
                } else if (AnonymousTypeConfig.REQUIRED.toString().equals(this.messageExchange.getOperation().getAnonymous()) && !WsaUtils.isAnonymousAddress(replyToAddressValue, wsaNsStr) && !WsaUtils.isNoneAddress(replyToAddressValue, wsaNsStr)) {
                    this.cumulativeErrorMsg.append("WS-A InvalidAddressingHeader ReplyTo , Anonymous addresses are required. ");
                }
            }
        }
    }

    public void validateWsAddressingResponse() throws AssertionException, XmlException {
        String cumulativeError;
        NodeList existingResponseRefs;
        String refPropName;
        Node refProp;
        String replyToAddressValue;
        Element addressNode;
        Element replyToNode;
        String content = this.messageExchange.getResponseContent();
        SoapVersion soapVersion = this.messageExchange.getOperation().getInterface().getSoapVersion();
        XmlObject requestXmlObject = XmlUtils.createXmlObject(this.messageExchange.getRequestContent());
        XmlObject xmlObject = XmlUtils.createXmlObject(content);
        this.header = (Element)SoapUtils.getHeaderElement(xmlObject, soapVersion, true).getDomNode();
        this.wsaVersionNameSpace = WsaValidator.getWsaVersion(xmlObject, soapVersion);
        if (this.wsaAssertionConfiguration.isAssertAction()) {
            String defaultWsdlAction = WsdlUtils.getDefaultWsaAction(this.messageExchange.getOperation(), true);
            this.assertProperty("Wsa:Action", "Action", defaultWsdlAction);
        }
        this.validateWsAddressingCommon(content);
        if (this.wsaAssertionConfiguration.isAssertRelatesTo()) {
            Element relatesToNode;
            if (!StringUtils.isNullOrEmpty(this.wsaVersionNameSpace)) {
                relatesToNode = XmlUtils.getFirstChildElementNS(this.header, this.wsaVersionNameSpace, "RelatesTo");
                this.parseRelatesToNode(soapVersion, requestXmlObject, relatesToNode);
            } else {
                relatesToNode = XmlUtils.getFirstChildElementNS(this.header, "http://www.w3.org/2005/08/addressing", "RelatesTo");
                if (relatesToNode == null) {
                    relatesToNode = XmlUtils.getFirstChildElementNS(this.header, "http://schemas.xmlsoap.org/ws/2004/08/addressing", "RelatesTo");
                }
                this.parseRelatesToNode(soapVersion, requestXmlObject, relatesToNode);
            }
        }
        if ((replyToNode = XmlUtils.getFirstChildElementNS(this.header, this.wsaVersionNameSpace, "ReplyTo")) != null && (addressNode = XmlUtils.getFirstChildElementNS(replyToNode, this.wsaVersionNameSpace, "Address")) != null && !StringUtils.isNullOrEmpty(replyToAddressValue = XmlUtils.getElementText(addressNode))) {
            if (AnonymousTypeConfig.PROHIBITED.toString().equals(this.messageExchange.getOperation().getAnonymous()) && WsaUtils.isAnonymousAddress(replyToAddressValue, this.wsaVersionNameSpace)) {
                this.cumulativeErrorMsg.append("WS-A InvalidAddressingHeader ReplyTo , Anonymous addresses are prohibited. ");
            } else if (AnonymousTypeConfig.REQUIRED.toString().equals(this.messageExchange.getOperation().getAnonymous()) && !WsaUtils.isAnonymousAddress(replyToAddressValue, this.wsaVersionNameSpace) && !WsaUtils.isNoneAddress(replyToAddressValue, this.wsaVersionNameSpace)) {
                this.cumulativeErrorMsg.append("WS-A InvalidAddressingHeader ReplyTo , Anonymous addresses are required. ");
            }
        }
        if (this.wsaAssertionConfiguration.isAssertReplyToRefParams()) {
            NodeList requestReplyToRefProps = WsdlUtils.getRequestReplyToRefProps(this.messageExchange, WsaValidator.getWsaVersion(requestXmlObject, soapVersion));
            for (int i = 0; i < requestReplyToRefProps.getLength(); ++i) {
                refProp = requestReplyToRefProps.item(i);
                refPropName = refProp.getNodeName();
                existingResponseRefs = XmlUtils.getChildElementsByTagName(this.header, refPropName);
                if (existingResponseRefs != null && existingResponseRefs.getLength() > 0) continue;
                this.cumulativeErrorMsg.append("Response does not have request ReferenceProperty " + refPropName + ". ");
            }
        }
        if (this.wsaAssertionConfiguration.isAssertFaultToRefParams()) {
            NodeList requestFaultToRefProps = WsdlUtils.getRequestFaultToRefProps(this.messageExchange, WsaValidator.getWsaVersion(requestXmlObject, soapVersion));
            for (int i = 0; i < requestFaultToRefProps.getLength(); ++i) {
                refProp = requestFaultToRefProps.item(i);
                refPropName = refProp.getNodeName();
                existingResponseRefs = XmlUtils.getChildElementsByTagName(this.header, refPropName);
                if (existingResponseRefs != null && existingResponseRefs.getLength() > 0) continue;
                this.cumulativeErrorMsg.append("Response does not have request ReferenceProperty " + refPropName + ". ");
            }
        }
        if (!StringUtils.isNullOrEmpty(cumulativeError = this.cumulativeErrorMsg.toString())) {
            throw new AssertionException(new AssertionError(cumulativeError));
        }
    }

    private void parseRelatesToNode(SoapVersion soapVersion, XmlObject requestXmlObject, Element relatesToNode) {
        if (relatesToNode == null) {
            this.cumulativeErrorMsg.append("WS-A RelatesTo property is not specified. ");
        } else {
            String relatesToValue = XmlUtils.getElementText(relatesToNode);
            if (StringUtils.isNullOrEmpty(relatesToValue)) {
                this.cumulativeErrorMsg.append("WS-A RelatesTo property is empty. ");
            } else {
                String requestMsgId = WsdlUtils.getRequestWsaMessageId(this.messageExchange, WsaValidator.getWsaVersion(requestXmlObject, soapVersion));
                if (!relatesToValue.equals(requestMsgId)) {
                    this.cumulativeErrorMsg.append("WS-A RelatesTo property is not equal to request wsa:MessageId. ");
                }
            }
        }
    }

    private void assertProperty(String propertyName, String wsaProperty, String expectedValue) {
        if (this.wsaVersionNameSpace != null) {
            Element propertyNode = XmlUtils.getFirstChildElementNS(this.header, this.wsaVersionNameSpace, wsaProperty);
            this.parsePropertyNode(propertyName, propertyNode, expectedValue);
        } else {
            Element propertyNode = XmlUtils.getFirstChildElementNS(this.header, "http://www.w3.org/2005/08/addressing", wsaProperty);
            if (propertyNode == null) {
                propertyNode = XmlUtils.getFirstChildElementNS(this.header, "http://schemas.xmlsoap.org/ws/2004/08/addressing", wsaProperty);
            }
            this.parsePropertyNode(propertyName, propertyNode, expectedValue);
        }
    }

    private void assertProperty(String propertyName, String wsaProperty) {
        this.assertProperty(propertyName, wsaProperty, null);
    }

    private void parsePropertyNode(String propertyName, Element propertyNode, String expectedValue) {
        if (propertyNode == null) {
            this.cumulativeErrorMsg.append(propertyName + " property is not specified. ");
        } else {
            String actionValue = XmlUtils.getElementText(propertyNode);
            if (StringUtils.isNullOrEmpty(actionValue)) {
                this.cumulativeErrorMsg.append(propertyName + " property is empty. ");
            } else if (!StringUtils.isNullOrEmpty(expectedValue) && !actionValue.equals(expectedValue)) {
                this.cumulativeErrorMsg.append(propertyName + " expecting [" + expectedValue + "], actual value is [" + actionValue + "].");
            }
        }
    }
}

