/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.http;

import com.btr.proxy.selector.whitelist.ProxyBypassListSelector;
import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.support.http.HttpClientSupport;
import com.eviware.soapui.impl.wsdl.support.http.ManualProxySelector;
import com.eviware.soapui.impl.wsdl.support.http.OverridableProxySelectorRoutePlanner;
import com.eviware.soapui.impl.wsdl.support.http.ProxyVoleUtil;
import com.eviware.soapui.impl.wsdl.support.http.SchemeProxyFilter;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.settings.ProxySettings;
import com.eviware.soapui.support.StringUtils;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.ProxySelector;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.params.HttpParams;
import org.apache.log4j.Logger;

public class ProxyUtils {
    private static final Logger logger = Logger.getLogger(ProxyUtils.class);
    private static boolean proxyEnabled;
    private static boolean autoProxy;

    private static String getExpandedProperty(PropertyExpansionContext context, Settings settings, String property) {
        String content = settings.getString(property, null);
        return context != null ? PropertyExpander.expandProperties(context, content) : PropertyExpander.expandProperties(content);
    }

    private static CredentialsProvider getProxyCredentials(Settings settings) {
        String proxyUsername = ProxyUtils.getExpandedProperty(null, settings, ProxySettings.USERNAME);
        String proxyPassword = ProxyUtils.getExpandedProperty(null, settings, ProxySettings.PASSWORD);
        if (!StringUtils.isNullOrEmpty(proxyUsername) && !StringUtils.isNullOrEmpty(proxyPassword)) {
            UsernamePasswordCredentials proxyCreds = new UsernamePasswordCredentials(proxyUsername, proxyPassword);
            int ix = proxyUsername.indexOf(92);
            if (ix > 0) {
                String domain = proxyUsername.substring(0, ix);
                if (proxyUsername.length() > ix + 1) {
                    String user = proxyUsername.substring(ix + 1);
                    proxyCreds = new NTCredentials(user, proxyPassword, ProxyUtils.getWorkstationName(), domain);
                }
            }
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(AuthScope.ANY, (Credentials)proxyCreds);
            return credsProvider;
        }
        return null;
    }

    private static String getWorkstationName() {
        String workstation = "";
        try {
            workstation = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            logger.warn((Object)"Workstation name could not be fetched.", (Throwable)e);
        }
        return workstation;
    }

    public static boolean excludes(String[] excludes, String proxyHost, int proxyPort) {
        for (String excludeString : excludes) {
            String exclude = excludeString.trim();
            if (exclude.length() == 0) continue;
            int ix = exclude.indexOf(58);
            if (ix >= 0 && exclude.length() > ix + 1) {
                String excludePort = exclude.substring(ix + 1);
                if (proxyPort == -1 || !excludePort.equals(String.valueOf(proxyPort))) continue;
                exclude = exclude.substring(0, ix);
            }
            String excludeIp = exclude.indexOf(42) >= 0 ? exclude : ProxyUtils.nslookup(exclude, true);
            String ip = ProxyUtils.nslookup(proxyHost, true);
            Pattern pattern = Pattern.compile(excludeIp);
            Matcher matcher = pattern.matcher(ip);
            Matcher matcher2 = pattern.matcher(proxyHost);
            if (!matcher.find() && !matcher2.find()) continue;
            return true;
        }
        return false;
    }

    private static String nslookup(String s, boolean ip) {
        String address;
        try {
            InetAddress host = InetAddress.getByName(s);
            address = ip ? host.getHostAddress() : host.getHostName();
        }
        catch (UnknownHostException ue) {
            return s;
        }
        return address;
    }

    public static boolean isProxyEnabled() {
        return proxyEnabled;
    }

    public static void setProxyEnabled(boolean proxyEnabled) {
        ProxyUtils.proxyEnabled = proxyEnabled;
    }

    public static boolean isAutoProxy() {
        return autoProxy;
    }

    public static void setAutoProxy(boolean autoProxy) {
        ProxyUtils.autoProxy = autoProxy;
    }

    public static void setGlobalProxy(Settings settings) {
        ProxySelector proxySelector = null;
        ProxySettingsAuthenticator authenticator = null;
        if (proxyEnabled) {
            proxySelector = autoProxy ? new ProxyVoleUtil().createAutoProxySearch().getProxySelector() : ProxyUtils.getManualProxySelector(settings);
            if (proxySelector != null) {
                proxySelector = ProxyUtils.filterHttpHttpsProxy(proxySelector);
            }
            authenticator = new ProxySettingsAuthenticator();
        }
        ProxySelector.setDefault(proxySelector);
        Authenticator.setDefault(authenticator);
        HttpClientSupport.setProxySelector(proxySelector);
        HttpClientSupport.getHttpClient().setCredentialsProvider(ProxyUtils.getProxyCredentials(settings));
    }

    public static ProxySelector filterHttpHttpsProxy(ProxySelector proxySelector) {
        return new ProxyBypassListSelector(Arrays.asList(new SchemeProxyFilter("http", "https")), proxySelector);
    }

    private static ProxySelector getManualProxySelector(Settings settings) {
        try {
            String proxyHost = ProxyUtils.getExpandedProperty(null, settings, ProxySettings.HOST);
            String proxyPort = ProxyUtils.getExpandedProperty(null, settings, ProxySettings.PORT);
            if (!StringUtils.isNullOrEmpty(proxyHost) && !StringUtils.isNullOrEmpty(proxyPort)) {
                String[] excludes = PropertyExpander.expandProperties(settings.getString(ProxySettings.EXCLUDES, "")).split(",");
                return new ManualProxySelector(proxyHost, Integer.valueOf(proxyPort), excludes);
            }
        }
        catch (Exception e) {
            SoapUI.logError(e, "Unable to expand proxy settings");
        }
        return null;
    }

    public static void setForceDirectConnection(HttpParams params) {
        OverridableProxySelectorRoutePlanner.setForceDirectConnection(params);
    }

    static {
        ProxyUtils.setProxyEnabled(SoapUI.getSettings().getBoolean(ProxySettings.ENABLE_PROXY));
        ProxyUtils.setAutoProxy(SoapUI.getSettings().getBoolean(ProxySettings.AUTO_PROXY));
    }

    private static class ProxySettingsAuthenticator
    extends Authenticator {
        private ProxySettingsAuthenticator() {
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            if (this.getRequestorType() != Authenticator.RequestorType.PROXY) {
                return null;
            }
            Settings settings = SoapUI.getSettings();
            try {
                String proxyUsername = PropertyExpander.expandProperties(settings.getString(ProxySettings.USERNAME, null));
                String proxyPassword = PropertyExpander.expandProperties(settings.getString(ProxySettings.PASSWORD, null));
                return new PasswordAuthentication(proxyUsername, proxyPassword.toCharArray());
            }
            catch (Exception e) {
                SoapUI.logError(e, "Unable to expand proxy settings");
                return null;
            }
        }
    }
}

