/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.transports.http;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.AbstractHttpRequestInterface;
import com.eviware.soapui.impl.support.HttpUtils;
import com.eviware.soapui.impl.support.http.HttpRequestInterface;
import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.submit.RequestFilter;
import com.eviware.soapui.impl.wsdl.submit.transports.http.BaseHttpRequestTransport;
import com.eviware.soapui.impl.wsdl.submit.transports.http.BaseHttpResponse;
import com.eviware.soapui.impl.wsdl.submit.transports.http.ExtendedHttpMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.SinglePartHttpResponse;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.MimeMessageResponse;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.ExtendedDeleteMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.ExtendedGetMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.ExtendedHeadMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.ExtendedOptionsMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.ExtendedPatchMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.ExtendedPostMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.ExtendedPutMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.ExtendedTraceMethod;
import com.eviware.soapui.impl.wsdl.support.PathUtils;
import com.eviware.soapui.impl.wsdl.support.http.HttpClientSupport;
import com.eviware.soapui.impl.wsdl.support.wss.WssCrypto;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.Response;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.settings.HttpSettings;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.types.StringToStringsMap;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import org.apache.commons.httpclient.URI;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class HttpClientRequestTransport
implements BaseHttpRequestTransport {
    private List<RequestFilter> filters = new ArrayList<RequestFilter>();

    @Override
    public void addRequestFilter(RequestFilter filter) {
        this.filters.add(filter);
    }

    @Override
    public void removeRequestFilter(RequestFilter filterToRemove) {
        if (!this.filters.remove(filterToRemove)) {
            for (RequestFilter requestFilter : this.filters) {
                if (!requestFilter.getClass().equals(filterToRemove.getClass())) continue;
                this.filters.remove(requestFilter);
                break;
            }
        }
    }

    @Override
    public void insertRequestFilter(RequestFilter filter, RequestFilter refFilter) {
        int ix = this.filters.indexOf(refFilter);
        if (ix == -1) {
            this.filters.add(filter);
        } else {
            this.filters.add(ix, filter);
        }
    }

    public <T> void removeRequestFilter(Class<T> filterClass) {
        RequestFilter filter = this.findFilterByType(filterClass);
        if (filter != null) {
            this.removeRequestFilter(filter);
        }
    }

    public <T> void replaceRequestFilter(Class<T> filterClass, RequestFilter newFilter) {
        RequestFilter filter = this.findFilterByType(filterClass);
        if (filter != null) {
            for (int i = 0; i < this.filters.size(); ++i) {
                RequestFilter oldFilter = this.filters.get(i);
                if (oldFilter != filter) continue;
                this.filters.remove(i);
                this.filters.add(i, newFilter);
                break;
            }
        }
    }

    @CheckForNull
    public <T> RequestFilter findFilterByType(Class<T> filterType) {
        for (int i = 0; i < this.filters.size(); ++i) {
            RequestFilter filter = this.filters.get(i);
            if (filter.getClass() != filterType) continue;
            return filter;
        }
        return null;
    }

    @Override
    public void abortRequest(SubmitContext submitContext) {
        HttpRequestBase postMethod = (HttpRequestBase)submitContext.getProperty("httpMethod");
        if (postMethod != null) {
            postMethod.abort();
        }
    }

    @Override
    public Response sendRequest(SubmitContext submitContext, Request request) throws Exception {
        String localAddress;
        AbstractHttpRequestInterface httpRequest = (AbstractHttpRequestInterface)request;
        HttpClientSupport.SoapUIHttpClient httpClient = this.getSoapUIHttpClient();
        ExtendedHttpMethod httpMethod = this.createHttpMethod(httpRequest);
        boolean createdContext = false;
        HttpContext httpContext = (HttpContext)submitContext.getProperty("#HTTP_STATE");
        if (httpContext == null) {
            httpContext = HttpClientSupport.createEmptyContext();
            submitContext.setProperty("#HTTP_STATE", httpContext);
            createdContext = true;
        }
        if ((localAddress = System.getProperty("soapui.bind.address", httpRequest.getBindAddress())) == null || localAddress.trim().length() == 0) {
            localAddress = SoapUI.getSettings().getString(HttpSettings.BIND_ADDRESS, null);
        }
        if (localAddress != null && localAddress.trim().length() > 0) {
            try {
                httpMethod.getParams().setParameter("http.route.local-address", (Object)InetAddress.getByName(localAddress));
            }
            catch (Exception e) {
                SoapUI.logError(e, "Failed to set localAddress to [" + localAddress + "]");
            }
        }
        submitContext.removeProperty("httpResponse");
        submitContext.setProperty("httpMethod", httpMethod);
        submitContext.setProperty("postMethod", httpMethod);
        submitContext.setProperty("httpClient", (Object)httpClient);
        submitContext.setProperty("requestContent", httpRequest.getRequestContent());
        submitContext.setProperty("wsdlRequest", httpRequest);
        submitContext.setProperty("httpResponseProperties", new StringToStringMap());
        for (RequestFilter filter : this.filters) {
            filter.filterRequest(submitContext, httpRequest);
        }
        try {
            Settings settings = httpRequest.getSettings();
            StringToStringsMap headers = httpRequest.getRequestHeaders();
            for (String headerName : headers.keySet()) {
                String expandedHeaderName = PropertyExpander.expandProperties(submitContext, headerName);
                httpMethod.removeHeaders(expandedHeaderName);
                for (String headerValue : (List)headers.get(headerName)) {
                    headerValue = PropertyExpander.expandProperties(submitContext, headerValue);
                    httpMethod.addHeader(expandedHeaderName, headerValue);
                }
            }
            WsdlProject project = (WsdlProject)ModelSupport.getModelItemProject(httpRequest);
            WssCrypto crypto = null;
            if (project != null && project.getWssContainer() != null) {
                crypto = project.getWssContainer().getCryptoByName(PropertyExpander.expandProperties(submitContext, httpRequest.getSslKeystore()));
            }
            if (crypto != null && "OK".equals(crypto.getStatus())) {
                httpMethod.getParams().setParameter("soapui.sslConfig", (Object)(crypto.getSource() + " " + crypto.getPassword()));
            }
            httpMethod.setDumpFile(PathUtils.expandPath(httpRequest.getDumpFile(), (AbstractWsdlModelItem)((Object)httpRequest), submitContext));
            if (settings.getBoolean(HttpSettings.INCLUDE_REQUEST_IN_TIME_TAKEN)) {
                httpMethod.initStartTime();
            }
            if (httpMethod.getMetrics() != null) {
                httpMethod.getMetrics().setHttpMethod(httpMethod.getMethod());
                this.captureMetrics(httpMethod, (HttpClient)httpClient);
                httpMethod.getMetrics().getTotalTimer().start();
            }
            HttpResponse httpResponse = this.submitRequest(httpMethod, httpContext);
            this.saveRequestHeaders(httpMethod, httpContext);
            if (httpMethod.getMetrics() != null) {
                httpMethod.getMetrics().getReadTimer().stop();
                httpMethod.getMetrics().getTotalTimer().stop();
            }
            if (this.isRedirectResponse(httpResponse.getStatusLine().getStatusCode()) && httpRequest.isFollowRedirects()) {
                if (httpResponse.getEntity() != null) {
                    EntityUtils.consume((HttpEntity)httpResponse.getEntity());
                }
                httpMethod = this.followRedirects((HttpClient)httpClient, 0, httpMethod, httpResponse, httpContext);
                submitContext.setProperty("httpMethod", httpMethod);
            }
        }
        catch (Throwable t) {
            httpMethod.setFailed(t);
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            SoapUI.logError(t);
            throw new Exception(t);
        }
        finally {
            if (!httpMethod.isFailed()) {
                if (httpMethod.getMetrics() != null) {
                    if (httpMethod.getMetrics().getReadTimer().getStop() == 0L) {
                        httpMethod.getMetrics().getReadTimer().stop();
                    }
                    if (httpMethod.getMetrics().getTotalTimer().getStop() == 0L) {
                        httpMethod.getMetrics().getTotalTimer().stop();
                    }
                }
            } else {
                httpMethod.getMetrics().reset();
                httpMethod.getMetrics().setTimestamp(System.currentTimeMillis());
                this.captureMetrics(httpMethod, (HttpClient)httpClient);
            }
            for (int c = this.filters.size() - 1; c >= 0; --c) {
                RequestFilter filter;
                filter = this.filters.get(c);
                filter.afterRequest(submitContext, httpRequest);
            }
            if (!submitContext.hasProperty("httpResponse")) {
                this.createDefaultResponse(submitContext, httpRequest, httpMethod);
            }
            Response response = (Response)submitContext.getProperty("httpResponse");
            StringToStringMap responseProperties = (StringToStringMap)submitContext.getProperty("httpResponseProperties");
            for (String key : responseProperties.keySet()) {
                response.setProperty(key, (String)responseProperties.get(key));
            }
            if (createdContext) {
                submitContext.setProperty("#HTTP_STATE", null);
            }
        }
        return (Response)submitContext.getProperty("httpResponse");
    }

    protected HttpResponse submitRequest(ExtendedHttpMethod httpMethod, HttpContext httpContext) throws IOException {
        return HttpClientSupport.execute(httpMethod, httpContext);
    }

    protected HttpClientSupport.SoapUIHttpClient getSoapUIHttpClient() {
        return HttpClientSupport.getHttpClient();
    }

    private boolean isRedirectResponse(int statusCode) {
        switch (statusCode) {
            case 301: 
            case 302: 
            case 303: 
            case 307: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExtendedGetMethod followRedirects(HttpClient httpClient, int redirectCount, ExtendedHttpMethod httpMethod, HttpResponse httpResponse, HttpContext httpContext) throws Exception {
        ExtendedGetMethod getMethod = new ExtendedGetMethod();
        getMethod.getMetrics().getTotalTimer().set(httpMethod.getMetrics().getTotalTimer().getStart(), httpMethod.getMetrics().getTotalTimer().getStop());
        getMethod.getMetrics().setHttpMethod(httpMethod.getMethod());
        this.captureMetrics(httpMethod, httpClient);
        String location = httpResponse.getFirstHeader("Location").getValue();
        URI uri = new URI(new URI(httpMethod.getURI().toString(), true), location, true);
        java.net.URI newUri = HttpUtils.createUri(uri.getScheme(), uri.getEscapedUserinfo(), uri.getHost(), uri.getPort(), uri.getEscapedPath(), uri.getEscapedQuery(), uri.getEscapedFragment());
        getMethod.setURI(newUri);
        HttpResponse response = this.submitRequest(getMethod, httpContext);
        if (this.isRedirectResponse(response.getStatusLine().getStatusCode())) {
            if (redirectCount == 10) {
                throw new Exception("Maximum number of Redirects reached [10]");
            }
            getMethod = this.followRedirects(httpClient, redirectCount + 1, getMethod, response, httpContext);
        }
        for (Header header : httpMethod.getAllHeaders()) {
            getMethod.addHeader(header);
        }
        return getMethod;
    }

    private void createDefaultResponse(SubmitContext submitContext, AbstractHttpRequestInterface<?> httpRequest, ExtendedHttpMethod httpMethod) {
        String requestContent = (String)submitContext.getProperty("requestContent");
        String responseContentTypeHeader = null;
        if (httpMethod.hasHttpResponse() && httpMethod.getHttpResponse().getEntity() != null) {
            Header h = httpMethod.getHttpResponse().getEntity().getContentType();
            responseContentTypeHeader = h.toString();
        }
        BaseHttpResponse response = responseContentTypeHeader != null && responseContentTypeHeader.toUpperCase().startsWith("MULTIPART") ? new MimeMessageResponse(httpRequest, httpMethod, requestContent, submitContext) : new SinglePartHttpResponse(httpRequest, httpMethod, requestContent, submitContext);
        submitContext.setProperty("httpResponse", response);
    }

    private ExtendedHttpMethod createHttpMethod(AbstractHttpRequestInterface<?> httpRequest) {
        if (httpRequest instanceof HttpRequestInterface) {
            HttpRequestInterface restRequest = (HttpRequestInterface)httpRequest;
            switch (restRequest.getMethod()) {
                case GET: {
                    return new ExtendedGetMethod();
                }
                case HEAD: {
                    return new ExtendedHeadMethod();
                }
                case DELETE: {
                    return new ExtendedDeleteMethod();
                }
                case PUT: {
                    return new ExtendedPutMethod();
                }
                case OPTIONS: {
                    return new ExtendedOptionsMethod();
                }
                case TRACE: {
                    return new ExtendedTraceMethod();
                }
                case PATCH: {
                    return new ExtendedPatchMethod();
                }
            }
        }
        ExtendedPostMethod extendedPostMethod = new ExtendedPostMethod();
        extendedPostMethod.setAfterRequestInjection(httpRequest.getAfterRequestInjection());
        return extendedPostMethod;
    }

    private void captureMetrics(ExtendedHttpMethod httpMethod, HttpClient httpClient) {
        try {
            httpMethod.getMetrics().setIpAddress(InetAddress.getByName(httpMethod.getURI().getHost()).getHostAddress());
            httpMethod.getMetrics().setPort(httpMethod.getURI().getPort(), this.getDefaultHttpPort(httpMethod, httpClient));
        }
        catch (UnknownHostException uhe) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected int getDefaultHttpPort(ExtendedHttpMethod httpMethod, HttpClient httpClient) {
        return httpClient.getConnectionManager().getSchemeRegistry().getScheme(httpMethod.getURI().getScheme()).getDefaultPort();
    }

    private void saveRequestHeaders(ExtendedHttpMethod httpMethod, HttpContext httpContext) {
        List requestHeaders = (List)httpContext.getAttribute("soapui.request.headers");
        if (requestHeaders != null) {
            for (Header header : requestHeaders) {
                int c;
                Header[] existingHeaders = httpMethod.getHeaders(header.getName());
                for (c = 0; c < existingHeaders.length && !existingHeaders[c].getValue().equals(header.getValue()); ++c) {
                }
                if (c != existingHeaders.length) continue;
                httpMethod.addHeader(header);
            }
        }
    }
}

