/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.filters;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.settings.XmlBeansSettingsImpl;
import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.wsdl.submit.filters.AbstractRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.transports.http.ExtendedHttpMethod;
import com.eviware.soapui.impl.wsdl.support.CompressionSupport;
import com.eviware.soapui.impl.wsdl.support.http.HttpClientSupport;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.settings.HttpSettings;
import com.eviware.soapui.support.StringUtils;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpVersion;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class HttpSettingsRequestFilter
extends AbstractRequestFilter {
    @Override
    public void filterAbstractHttpRequest(SubmitContext context, AbstractHttpRequest<?> httpRequest) {
        String httpVersion;
        String compressionAlg;
        ExtendedHttpMethod httpMethod = (ExtendedHttpMethod)context.getProperty("httpMethod");
        XmlBeansSettingsImpl settings = httpRequest.getSettings();
        if (settings.getBoolean(HttpSettings.CLOSE_CONNECTIONS)) {
            httpMethod.setHeader("Connection", "close");
        }
        if (settings.getBoolean(HttpSettings.EXPECT_CONTINUE) && httpMethod instanceof HttpEntityEnclosingRequest) {
            httpMethod.getParams().setParameter("http.protocol.expect-continue", (Object)Boolean.TRUE);
        }
        if (!"None".equals(compressionAlg = settings.getString(HttpSettings.REQUEST_COMPRESSION, "None"))) {
            httpMethod.setHeader("Content-Encoding", compressionAlg);
        }
        if (settings.getBoolean(HttpSettings.RESPONSE_COMPRESSION)) {
            httpMethod.setHeader("Accept-Encoding", CompressionSupport.getAvailableAlgorithms(","));
        }
        if ((httpVersion = settings.getString(HttpSettings.HTTP_VERSION, "1.1")).equals("1.1")) {
            httpMethod.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
        } else if (httpVersion.equals("1.0")) {
            httpMethod.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_0);
        } else if (httpVersion.equals("0.9")) {
            httpMethod.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
        }
        long maxSize = httpRequest.getMaxSize();
        if (maxSize == 0L) {
            maxSize = settings.getLong(HttpSettings.MAX_RESPONSE_SIZE, 0L);
        }
        if (maxSize > 0L) {
            httpMethod.setMaxSize(maxSize);
        }
        httpMethod.getParams().setParameter("http.protocol.handle-redirects", (Object)false);
        HttpClientSupport.applyHttpSettings(httpMethod, settings);
        String timeout = context.expand(httpRequest.getTimeout());
        if (StringUtils.hasContent(timeout)) {
            try {
                HttpConnectionParams.setSoTimeout((HttpParams)httpMethod.getParams(), (int)Integer.parseInt(timeout));
            }
            catch (NumberFormatException e) {
                SoapUI.logError(e);
            }
        }
    }
}

