/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.filters;

import com.eviware.soapui.config.CredentialsConfig;
import com.eviware.soapui.impl.settings.XmlBeansSettingsImpl;
import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.submit.filters.AbstractRequestFilter;
import com.eviware.soapui.impl.wsdl.support.http.HttpClientSupport;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.settings.HttpSettings;
import com.eviware.soapui.support.StringUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.http.Header;
import org.apache.http.auth.AuthSchemeFactory;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.auth.NTLMSchemeFactory;
import org.apache.http.impl.auth.NegotiateSchemeFactory;
import org.apache.http.protocol.HttpContext;
import org.apache.log4j.Logger;

public class HttpAuthenticationRequestFilter
extends AbstractRequestFilter {
    @Override
    public void filterAbstractHttpRequest(SubmitContext context, AbstractHttpRequest<?> wsdlRequest) {
        String username = PropertyExpander.expandProperties(context, wsdlRequest.getUsername());
        if (username == null || username.length() == 0) {
            return;
        }
        XmlBeansSettingsImpl settings = wsdlRequest.getSettings();
        String password = PropertyExpander.expandProperties(context, wsdlRequest.getPassword());
        String domain = PropertyExpander.expandProperties(context, wsdlRequest.getDomain());
        CredentialsConfig.AuthType.Enum authType = CredentialsConfig.AuthType.Enum.forString(wsdlRequest.getAuthType());
        this.registerSpnegoAuthSchemeFactory(authType);
        String wssPasswordType = null;
        if (wsdlRequest instanceof WsdlRequest) {
            wssPasswordType = PropertyExpander.expandProperties(context, ((WsdlRequest)wsdlRequest).getWssPasswordType());
        }
        if (StringUtils.isNullOrEmpty(wssPasswordType)) {
            HttpAuthenticationRequestFilter.initRequestCredentials(context, username, settings, password, domain, authType);
        }
    }

    private void registerSpnegoAuthSchemeFactory(CredentialsConfig.AuthType.Enum authtype) {
        if (authtype == CredentialsConfig.AuthType.NTLM) {
            HttpClientSupport.getHttpClient().getAuthSchemes().register("negotiate", (AuthSchemeFactory)new NTLMSchemeFactory());
        } else if (authtype == CredentialsConfig.AuthType.SPNEGO_KERBEROS) {
            HttpClientSupport.getHttpClient().getAuthSchemes().register("negotiate", (AuthSchemeFactory)new NegotiateSchemeFactory(null, true));
        }
    }

    public static void initRequestCredentials(SubmitContext context, String username, Settings settings, String password, String domain, CredentialsConfig.AuthType.Enum authType) {
        HttpRequestBase httpMethod = (HttpRequestBase)context.getProperty("httpMethod");
        HttpContext httpContext = (HttpContext)context.getProperty("#HTTP_STATE");
        if (!StringUtils.isNullOrEmpty(username) && !StringUtils.isNullOrEmpty(password) && (((Object)((Object)authType)).equals((Object)CredentialsConfig.AuthType.GLOBAL_HTTP_SETTINGS) && settings.getBoolean(HttpSettings.AUTHENTICATE_PREEMPTIVELY) || ((Object)((Object)authType)).equals((Object)CredentialsConfig.AuthType.PREEMPTIVE))) {
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(username, password);
            Header header = BasicScheme.authenticate((Credentials)creds, (String)"utf-8", (boolean)false);
            httpMethod.removeHeaders("Authorization");
            httpMethod.addHeader(header);
        }
        httpContext.setAttribute("http.auth.credentials-provider", (Object)new UPDCredentialsProvider(username, password, domain));
    }

    public static class UPDCredentialsProvider
    implements CredentialsProvider {
        private boolean checkedCredentials;
        private static final Logger logger = Logger.getLogger(UPDCredentialsProvider.class);
        private final String username;
        private final String password;
        private final String domain;

        public UPDCredentialsProvider(String username, String password, String domain) {
            this.username = username;
            this.password = password == null ? "" : password;
            this.domain = domain;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Credentials getCredentials(AuthScope authScope) {
            if (this.checkedCredentials) {
                return null;
            }
            if (authScope == null) {
                throw new IllegalArgumentException("Authentication scope may not be null");
            }
            try {
                if ("NTLM".equalsIgnoreCase(authScope.getScheme())) {
                    logger.info((Object)(authScope.getHost() + ":" + authScope.getPort() + " requires Windows authentication"));
                    String workstation = "";
                    try {
                        workstation = InetAddress.getLocalHost().getHostName();
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                    NTCredentials nTCredentials = new NTCredentials(this.username, this.password, workstation, this.domain);
                    return nTCredentials;
                }
                if ("Basic".equalsIgnoreCase(authScope.getScheme()) || "Digest".equalsIgnoreCase(authScope.getScheme()) || "negotiate".equalsIgnoreCase(authScope.getScheme())) {
                    logger.info((Object)(authScope.getHost() + ":" + authScope.getPort() + " requires authentication with the realm '" + authScope.getRealm() + "'"));
                    UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(this.username, this.password);
                    return usernamePasswordCredentials;
                }
            }
            finally {
                this.checkedCredentials = true;
            }
            return null;
        }

        public void clear() {
        }

        public void setCredentials(AuthScope authscope, Credentials credentials) {
        }
    }
}

