/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.teststeps.support;

import com.eviware.soapui.impl.wsdl.MutableTestPropertyHolder;
import com.eviware.soapui.support.UISupport;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

public class AddParamAction
extends AbstractAction {
    public static final String EMPTY_STRING = "";
    public static final String ADD_PARAM_ACTION_NAME = "Add Param";
    private MutableTestPropertyHolder propertyHolder;
    private JTable parameterTable;

    public AddParamAction(JTable parameterTable, MutableTestPropertyHolder propertyHolder, String description) {
        super(ADD_PARAM_ACTION_NAME);
        this.parameterTable = parameterTable;
        this.propertyHolder = propertyHolder;
        this.putValue("SmallIcon", UISupport.createImageIcon("/add_property.gif"));
        this.putValue("ShortDescription", description);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.propertyHolder.getProperty(EMPTY_STRING) != null) {
            return;
        }
        this.propertyHolder.addProperty(EMPTY_STRING);
        final int row = this.parameterTable.getModel().getRowCount() - 1;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AddParamAction.this.editTableCell(row, 0);
                final TableCellEditor cellEditor1 = AddParamAction.this.parameterTable.getCellEditor(row, 0);
                cellEditor1.addCellEditorListener(new CellEditorListener(){

                    @Override
                    public void editingStopped(ChangeEvent e) {
                        cellEditor1.removeCellEditorListener(this);
                        if (AddParamAction.this.parameterTable.getRowCount() > row && AddParamAction.this.parameterTable.getValueAt(row, 0).toString().equals(AddParamAction.EMPTY_STRING)) {
                            AddParamAction.this.propertyHolder.removeProperty(AddParamAction.EMPTY_STRING);
                            return;
                        }
                        AddParamAction.this.editTableCell(row, 1);
                    }

                    @Override
                    public void editingCanceled(ChangeEvent e) {
                        cellEditor1.removeCellEditorListener(this);
                        AddParamAction.this.propertyHolder.removeProperty(AddParamAction.EMPTY_STRING);
                    }
                });
            }
        });
    }

    private void editTableCell(final int row, final int column) {
        TableCellEditor cellEditor = this.parameterTable.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AddParamAction.this.parameterTable.requestFocusInWindow();
                if (AddParamAction.this.parameterTable.getRowCount() > row) {
                    AddParamAction.this.parameterTable.setRowSelectionInterval(row, row);
                }
                AddParamAction.this.parameterTable.scrollRectToVisible(AddParamAction.this.parameterTable.getCellRect(row, column, true));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AddParamAction.this.parameterTable.editCellAt(row, column);
                        Component editorComponent = AddParamAction.this.parameterTable.getEditorComponent();
                        if (editorComponent != null) {
                            editorComponent.requestFocusInWindow();
                        }
                    }
                });
            }
        });
    }
}

