/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.teststeps.amf;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.panels.teststeps.amf.AMFResponse;
import com.eviware.soapui.impl.wsdl.panels.teststeps.amf.AMFSubmit;
import com.eviware.soapui.impl.wsdl.support.IconAnimator;
import com.eviware.soapui.impl.wsdl.teststeps.AMFRequestTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.TestRequest;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepWithProperties;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.TestAssertionRegistry;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.iface.MessagePart;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.Submit;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.iface.SubmitListener;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.model.support.AbstractModelItem;
import com.eviware.soapui.model.support.AnimatableItem;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionsListener;
import com.eviware.soapui.model.testsuite.TestAssertion;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.monitor.TestMonitor;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.scripting.SoapUIScriptEngine;
import com.eviware.soapui.support.types.StringToObjectMap;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.types.StringToStringsMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;

public class AMFRequest
extends AbstractModelItem
implements Assertable,
TestRequest,
AnimatableItem {
    public static final String AMF_SCRIPT_HEADERS = "AMF_SCRIPT_HEADERS";
    public static final String AMF_SCRIPT_PARAMETERS = "AMF_SCRIPT_PARAMETERS";
    public static final String AMF_SCRIPT_ERROR = "AMF_SCRIPT_ERROR";
    public static final String AMF_RESPONSE_CONTENT = "AMF_RESPONSE_CONTENT";
    public static final String AMF_REQUEST = "AMF_REQUEST";
    public static final String RAW_AMF_REQUEST = "RAW_AMF_REQUEST";
    public static final String AMF_RESPONSE_PROPERTY = "response";
    private final AMFRequestTestStep testStep;
    private Set<SubmitListener> submitListeners = new HashSet<SubmitListener>();
    private AMFResponse response;
    private SoapUIScriptEngine scriptEngine;
    private String endpoint;
    private String amfCall;
    private String script;
    private HashMap<String, TestProperty> propertyMap;
    private String[] propertyNames;
    private List<Object> arguments = new ArrayList<Object>();
    private StringToStringsMap httpHeaders;
    private StringToObjectMap amfHeaders;
    private StringToStringMap amfHeadersString;
    private boolean forLoadTest;
    private Assertable.AssertionStatus currentStatus;
    private RequestIconAnimator<?> iconAnimator;
    private ImageIcon validRequestIcon;
    private ImageIcon failedRequestIcon;
    private ImageIcon disabledRequestIcon;
    private ImageIcon unknownRequestIcon;

    public AMFRequest(AMFRequestTestStep testStep, boolean forLoadTest) {
        this.testStep = testStep;
        if (!forLoadTest) {
            this.initIcons();
        }
    }

    @Override
    public AMFSubmit submit(SubmitContext submitContext, boolean async) throws Request.SubmitException {
        return new AMFSubmit(this, submitContext, async);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeAmfScript(SubmitContext context) {
        boolean scriptOK = true;
        HashMap parameters = new HashMap();
        HashMap amfHeadersTemp = new HashMap();
        try {
            this.scriptEngine.setScript(this.script);
            this.scriptEngine.setVariable("parameters", parameters);
            this.scriptEngine.setVariable("amfHeaders", amfHeadersTemp);
            this.scriptEngine.setVariable("log", SoapUI.ensureGroovyLog());
            this.scriptEngine.setVariable("context", context);
            this.scriptEngine.run();
            context.setProperty(AMF_SCRIPT_PARAMETERS, parameters);
            context.setProperty(AMF_SCRIPT_HEADERS, amfHeadersTemp);
            for (String name : this.propertyNames) {
                if (name.equals(WsdlTestStepWithProperties.RESPONSE_AS_XML)) continue;
                TestProperty propertyValue = this.propertyMap.get(name);
                if (parameters.containsKey(name)) {
                    this.addArgument(parameters.get(name));
                    continue;
                }
                this.addArgument(PropertyExpander.expandProperties(context, propertyValue.getValue()));
            }
            StringToObjectMap stringToObjectMap = new StringToObjectMap();
            for (String key : this.getAmfHeadersString().getKeys()) {
                if (amfHeadersTemp.containsKey(key)) {
                    stringToObjectMap.put(key, amfHeadersTemp.get(key));
                    continue;
                }
                stringToObjectMap.put(key, PropertyExpander.expandProperties(context, (String)this.getAmfHeadersString().get(key)));
            }
            this.setAmfHeaders(stringToObjectMap);
        }
        catch (Throwable e) {
            SoapUI.logError(e);
            scriptOK = false;
            context.setProperty(AMF_SCRIPT_ERROR, e);
        }
        finally {
            this.scriptEngine.clearVariables();
        }
        return scriptOK;
    }

    @Override
    public Assertable.AssertionStatus getAssertionStatus() {
        this.currentStatus = Assertable.AssertionStatus.UNKNOWN;
        if (this.getResponse() == null) {
            return this.currentStatus;
        }
        int cnt = this.getAssertionCount();
        if (cnt == 0) {
            return this.currentStatus;
        }
        boolean hasEnabled = false;
        for (int c = 0; c < cnt; ++c) {
            if (!this.getAssertionAt(c).isDisabled()) {
                hasEnabled = true;
            }
            if (this.getAssertionAt(c).getStatus() != Assertable.AssertionStatus.FAILED) continue;
            this.currentStatus = Assertable.AssertionStatus.FAILED;
            break;
        }
        if (this.currentStatus == Assertable.AssertionStatus.UNKNOWN && hasEnabled) {
            this.currentStatus = Assertable.AssertionStatus.VALID;
        }
        return this.currentStatus;
    }

    @Override
    public Map<String, TestAssertion> getAssertions() {
        return this.testStep.getAssertions();
    }

    @Override
    public String getDefaultAssertableContent() {
        return this.testStep.getDefaultAssertableContent();
    }

    @Override
    public Interface getInterface() {
        return this.testStep.getInterface();
    }

    @Override
    public ModelItem getModelItem() {
        return this.testStep.getModelItem();
    }

    @Override
    public TestAssertion moveAssertion(int ix, int offset) {
        return this.testStep.moveAssertion(ix, offset);
    }

    @Override
    public void removeAssertion(TestAssertion assertion) {
        this.testStep.removeAssertion(assertion);
    }

    @Override
    public void removeAssertionsListener(AssertionsListener listener) {
        this.testStep.removeAssertionsListener(listener);
    }

    public void setResponse(AMFResponse response) {
        AMFResponse old = this.response;
        this.response = response;
        this.notifyPropertyChanged(AMF_RESPONSE_PROPERTY, old, response);
    }

    @Override
    public AMFResponse getResponse() {
        return this.response;
    }

    public String getResponseContent() {
        if (this.response != null) {
            return this.response.getResponseContentXML();
        }
        return "";
    }

    public void initIcons() {
        if (this.validRequestIcon == null) {
            this.validRequestIcon = UISupport.createImageIcon("/valid_amf_request.gif");
        }
        if (this.failedRequestIcon == null) {
            this.failedRequestIcon = UISupport.createImageIcon("/invalid_amf_request.gif");
        }
        if (this.unknownRequestIcon == null) {
            this.unknownRequestIcon = UISupport.createImageIcon("/unknown_amf_request.gif");
        }
        if (this.disabledRequestIcon == null) {
            this.disabledRequestIcon = UISupport.createImageIcon("/disabled_amf_request.gif");
        }
        this.setIconAnimator(new RequestIconAnimator<AMFRequest>(this, "/amf_request.gif", "/exec_amf_request.gif", 3));
    }

    protected RequestIconAnimator<?> initIconAnimator() {
        return new RequestIconAnimator<AMFRequest>(this, "/amf_request.gif", "/exec_amf_request.gif", 3);
    }

    public RequestIconAnimator<?> getIconAnimator() {
        return this.iconAnimator;
    }

    public void setIconAnimator(RequestIconAnimator<?> iconAnimator) {
        if (this.iconAnimator != null) {
            this.removeSubmitListener(this.iconAnimator);
        }
        this.iconAnimator = iconAnimator;
        this.addSubmitListener(this.iconAnimator);
    }

    @Override
    public ImageIcon getIcon() {
        if (this.forLoadTest || this.getIconAnimator() == null) {
            return null;
        }
        TestMonitor testMonitor = SoapUI.getTestMonitor();
        if (testMonitor != null && (testMonitor.hasRunningLoadTest(this.getTestStep().getTestCase()) || testMonitor.hasRunningSecurityTest(this.getTestStep().getTestCase()))) {
            return this.disabledRequestIcon;
        }
        ImageIcon icon = this.getIconAnimator().getIcon();
        if (icon == this.getIconAnimator().getBaseIcon()) {
            Assertable.AssertionStatus status = this.getAssertionStatus();
            if (status == Assertable.AssertionStatus.VALID) {
                return this.validRequestIcon;
            }
            if (status == Assertable.AssertionStatus.FAILED) {
                return this.failedRequestIcon;
            }
            if (status == Assertable.AssertionStatus.UNKNOWN) {
                return this.unknownRequestIcon;
            }
        }
        return icon;
    }

    @Override
    public void setIcon(ImageIcon icon) {
        this.getTestStep().setIcon(icon);
    }

    public void setPropertyNames(String[] propertyNames) {
        this.propertyNames = propertyNames;
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    public void setScriptEngine(SoapUIScriptEngine scriptEngine) {
        this.scriptEngine = scriptEngine;
    }

    public SoapUIScriptEngine getScriptEngine() {
        return this.scriptEngine;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getAmfCall() {
        return this.amfCall;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String getScript() {
        return this.script;
    }

    public void setAmfCall(String amfCall) {
        this.amfCall = amfCall;
    }

    public HashMap<String, TestProperty> getPropertyMap() {
        return this.propertyMap;
    }

    public void setPropertyMap(HashMap<String, TestProperty> map) {
        this.propertyMap = map;
    }

    public void setArguments(List<Object> arguments) {
        this.arguments = arguments;
    }

    public void clearArguments() {
        this.arguments.clear();
    }

    public List<Object> getArguments() {
        return this.arguments;
    }

    public List<Object> addArgument(Object obj) {
        this.arguments.add(obj);
        return this.arguments;
    }

    public Object[] argumentsToArray() {
        return this.arguments.toArray();
    }

    @Override
    public void addSubmitListener(SubmitListener listener) {
        this.submitListeners.add(listener);
    }

    @Override
    public boolean dependsOn(ModelItem modelItem) {
        return ModelSupport.dependsOn(this.testStep, modelItem);
    }

    @Override
    public Attachment[] getAttachments() {
        return null;
    }

    @Override
    public String getEncoding() {
        return null;
    }

    @Override
    public Operation getOperation() {
        return null;
    }

    @Override
    public String getRequestContent() {
        return this.requestAsXML();
    }

    @Override
    public MessagePart[] getRequestParts() {
        return null;
    }

    @Override
    public MessagePart[] getResponseParts() {
        return null;
    }

    @Override
    public String getTimeout() {
        return null;
    }

    @Override
    public void removeSubmitListener(SubmitListener listener) {
        this.submitListeners.remove(listener);
    }

    @Override
    public void setEncoding(String string) {
    }

    @Override
    public List<? extends ModelItem> getChildren() {
        return null;
    }

    @Override
    public String getDescription() {
        return this.testStep.getDescription();
    }

    @Override
    public String getId() {
        return this.testStep.getId();
    }

    @Override
    public String getName() {
        return this.testStep.getName();
    }

    @Override
    public ModelItem getParent() {
        return this.testStep.getParent();
    }

    @Override
    public Settings getSettings() {
        return this.testStep.getSettings();
    }

    public SubmitListener[] getSubmitListeners() {
        return this.submitListeners.toArray(new SubmitListener[this.submitListeners.size()]);
    }

    @Override
    public AMFRequestTestStep getTestStep() {
        return this.testStep;
    }

    @Override
    public WsdlMessageAssertion importAssertion(WsdlMessageAssertion source, boolean overwrite2, boolean createCopy, String newName) {
        return this.testStep.importAssertion(source, overwrite2, createCopy, newName);
    }

    @Override
    public TestAssertion addAssertion(String selection) {
        return this.testStep.addAssertion(selection);
    }

    @Override
    public void addAssertionsListener(AssertionsListener listener) {
        this.testStep.addAssertionsListener(listener);
    }

    @Override
    public TestAssertion cloneAssertion(TestAssertion source, String name) {
        return this.testStep.cloneAssertion(source, name);
    }

    @Override
    public String getAssertableContentAsXml() {
        return this.testStep.getAssertableContentAsXml();
    }

    @Override
    public String getAssertableContent() {
        return this.testStep.getAssertableContent();
    }

    @Override
    public TestAssertionRegistry.AssertableType getAssertableType() {
        return this.testStep.getAssertableType();
    }

    @Override
    public TestAssertion getAssertionAt(int c) {
        return this.testStep.getAssertionAt(c);
    }

    @Override
    public TestAssertion getAssertionByName(String name) {
        return this.testStep.getAssertionByName(name);
    }

    @Override
    public int getAssertionCount() {
        return this.testStep.getAssertionCount();
    }

    @Override
    public List<TestAssertion> getAssertionList() {
        return this.testStep.getAssertionList();
    }

    public String requestAsXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<AMFRequest>\n");
        sb.append(" <endpoint>" + this.getEndpoint() + "</endpoint>\n");
        sb.append(" <amfcall>" + this.getAmfCall() + "</amfcall>\n");
        if (this.getPropertyNames() != null) {
            sb.append(" <parameters>\n");
            for (String name : this.getPropertyNames()) {
                if (name.equals(WsdlTestStepWithProperties.RESPONSE_AS_XML)) continue;
                sb.append("  <parameter>\n");
                sb.append("   <name>" + name + "</name>\n");
                sb.append("   <value>" + this.getPropertyMap().get(name).getValue() + "</value>\n");
                sb.append("  </parameter>\n");
            }
            sb.append(" </parameters>\n");
        }
        sb.append(" <script>" + this.getScript() + "</script>\n");
        sb.append("</AMFRequest>");
        return sb.toString();
    }

    public void setHttpHeaders(StringToStringsMap httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    public StringToStringsMap getHttpHeaders() {
        return this.httpHeaders;
    }

    public void setAmfHeaders(StringToObjectMap amfHeaders) {
        this.amfHeaders = amfHeaders;
    }

    public StringToObjectMap getAmfHeaders() {
        return this.amfHeaders;
    }

    public void setAmfHeadersString(StringToStringMap amfHeadersString) {
        this.amfHeadersString = amfHeadersString;
    }

    public StringToStringMap getAmfHeadersString() {
        return this.amfHeadersString;
    }

    @Override
    public String getPassword() {
        return null;
    }

    @Override
    public String getUsername() {
        return null;
    }

    @Override
    public String getAuthType() {
        return null;
    }

    @Override
    public boolean isDiscardResponse() {
        return this.getSettings().getBoolean("discardResponse");
    }

    public void setDiscardResponse(boolean discardResponse) {
        this.getSettings().setBoolean("discardResponse", discardResponse);
    }

    public static class RequestIconAnimator<T extends AMFRequest>
    extends IconAnimator<T>
    implements SubmitListener {
        public RequestIconAnimator(T modelItem, String baseIcon, String baseAnimateIcon, int iconCount) {
            super(modelItem, baseIcon, baseAnimateIcon, iconCount);
        }

        @Override
        public boolean beforeSubmit(Submit submit, SubmitContext context) {
            if (this.isEnabled() && submit.getRequest() == this.getTarget()) {
                this.start();
            }
            return true;
        }

        @Override
        public void afterSubmit(Submit submit, SubmitContext context) {
            if (submit.getRequest() == this.getTarget()) {
                this.stop();
            }
        }
    }
}

