/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.teststeps;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.teststeps.actions.AddAssertionAction;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.model.testsuite.AssertionsListener;
import com.eviware.soapui.model.testsuite.TestAssertion;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.ActionListBuilder;
import com.eviware.soapui.support.action.swing.ActionSupport;
import com.eviware.soapui.support.components.JXToolBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class AssertionsPanel
extends JPanel {
    protected AssertionListModel assertionListModel;
    protected JList assertionList;
    private JPopupMenu assertionListPopup;
    private Assertable assertable;
    private AddAssertionAction addAssertionAction;
    private ConfigureAssertionAction configureAssertionAction;
    private RemoveAssertionAction removeAssertionAction;
    private MoveAssertionUpAction moveAssertionUpAction;
    private MoveAssertionDownAction moveAssertionDownAction;

    public AssertionsPanel(Assertable assertable) {
        super(new BorderLayout());
        this.assertable = assertable;
        this.initListAndModel();
        this.assertionList.setSelectionMode(2);
        this.assertionListPopup = new JPopupMenu();
        this.addAssertionAction = new AddAssertionAction(assertable);
        this.assertionListPopup.add(this.addAssertionAction);
        this.assertionListPopup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                while (AssertionsPanel.this.assertionListPopup.getComponentCount() > 1) {
                    AssertionsPanel.this.assertionListPopup.remove(1);
                }
                int ix = AssertionsPanel.this.assertionList.getSelectedIndex();
                if (ix == -1) {
                    AssertionsPanel.this.assertionListPopup.addSeparator();
                    AssertionsPanel.this.assertionListPopup.add(new ShowOnlineHelpAction(AssertionsPanel.this.getHelpUrl()));
                    return;
                }
                int[] indices = AssertionsPanel.this.assertionList.getSelectedIndices();
                if (indices.length == 1) {
                    TestAssertion assertion = AssertionsPanel.this.assertionListModel.getAssertionAt(ix);
                    ActionSupport.addActions(ActionListBuilder.buildActions(assertion), AssertionsPanel.this.assertionListPopup);
                } else {
                    ModelItem[] testAssertion = new TestAssertion[indices.length];
                    for (int c = 0; c < indices.length; ++c) {
                        testAssertion[c] = AssertionsPanel.this.assertionListModel.getAssertionAt(indices[c]);
                    }
                    ActionSupport.addActions(ActionListBuilder.buildMultiActions(testAssertion), AssertionsPanel.this.assertionListPopup);
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.assertionList.setComponentPopupMenu(this.assertionListPopup);
        this.assertionList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() < 2) {
                    return;
                }
                int ix = AssertionsPanel.this.assertionList.getSelectedIndex();
                if (ix == -1) {
                    return;
                }
                Object obj = AssertionsPanel.this.assertionList.getModel().getElementAt(ix);
                if (obj instanceof TestAssertion) {
                    TestAssertion assertion = (TestAssertion)obj;
                    if (assertion.isConfigurable()) {
                        assertion.configure();
                    }
                    return;
                }
                if (obj instanceof AssertionError) {
                    AssertionError error = (AssertionError)obj;
                    if (error.getLineNumber() >= 0) {
                        AssertionsPanel.this.selectError(error);
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        });
        this.assertionList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int ix = AssertionsPanel.this.assertionList.getSelectedIndex();
                if (ix == -1) {
                    return;
                }
                int[] indices = AssertionsPanel.this.assertionList.getSelectedIndices();
                if (indices.length == 1) {
                    TestAssertion assertion = AssertionsPanel.this.assertionListModel.getAssertionAt(ix);
                    if (e.getKeyChar() == '\n') {
                        if (assertion.isConfigurable()) {
                            assertion.configure();
                        }
                    } else {
                        ActionList actions = ActionListBuilder.buildActions(assertion);
                        if (actions != null) {
                            actions.dispatchKeyEvent(e);
                        }
                    }
                } else {
                    ModelItem[] testAssertion = new TestAssertion[indices.length];
                    for (int c = 0; c < indices.length; ++c) {
                        testAssertion[c] = AssertionsPanel.this.assertionListModel.getAssertionAt(indices[c]);
                    }
                    ActionList actions = ActionListBuilder.buildMultiActions(testAssertion);
                    ActionSupport.addActions(actions, AssertionsPanel.this.assertionListPopup);
                    if (actions != null) {
                        actions.dispatchKeyEvent(e);
                    }
                }
            }
        });
        this.add((Component)new JScrollPane(this.assertionList), "Center");
        this.add((Component)this.buildToolbar(), "North");
    }

    protected void initListAndModel() {
        this.assertionListModel = new AssertionListModel();
        this.assertionList = new JList(this.assertionListModel);
        this.assertionList.setToolTipText("Assertions for this request");
        this.assertionList.setCellRenderer(new AssertionCellRenderer());
    }

    private JComponent buildToolbar() {
        this.configureAssertionAction = new ConfigureAssertionAction();
        this.removeAssertionAction = new RemoveAssertionAction();
        this.moveAssertionUpAction = new MoveAssertionUpAction();
        this.moveAssertionDownAction = new MoveAssertionDownAction();
        JXToolBar toolbar = UISupport.createToolbar();
        this.addToolbarButtons(toolbar);
        toolbar.addGlue();
        toolbar.add(new ShowOnlineHelpAction(this.getHelpUrl()));
        this.assertionList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int ix = AssertionsPanel.this.assertionList.getSelectedIndex();
                AssertionsPanel.this.configureAssertionAction.setEnabled(ix >= 0);
                AssertionsPanel.this.removeAssertionAction.setEnabled(ix >= 0);
                AssertionsPanel.this.moveAssertionUpAction.setEnabled(ix >= 0);
                AssertionsPanel.this.moveAssertionDownAction.setEnabled(ix >= 0);
                if (ix == -1) {
                    return;
                }
                TestAssertion assertion = AssertionsPanel.this.assertionListModel.getAssertionAt(ix);
                AssertionsPanel.this.configureAssertionAction.setEnabled(assertion != null && assertion.isConfigurable());
            }
        });
        return toolbar;
    }

    protected void addToolbarButtons(JXToolBar toolbar) {
        toolbar.addFixed(UISupport.createToolbarButton(this.addAssertionAction));
        toolbar.addFixed(UISupport.createToolbarButton(this.configureAssertionAction));
        toolbar.addFixed(UISupport.createToolbarButton(this.removeAssertionAction));
        toolbar.addFixed(UISupport.createToolbarButton(this.moveAssertionUpAction));
        toolbar.addFixed(UISupport.createToolbarButton(this.moveAssertionDownAction));
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.assertionList.setEnabled(enabled);
    }

    protected void selectError(AssertionError error) {
    }

    public void release() {
        this.assertionListModel.release();
        this.addAssertionAction.release();
        this.assertable = null;
    }

    public JList getAssertionsList() {
        return this.assertionList;
    }

    public String getHelpUrl() {
        return "http://www.soapui.org/Functional-Testing/getting-started-with-assertions.html";
    }

    private class MoveAssertionDownAction
    extends AbstractAction {
        public MoveAssertionDownAction() {
            super("Move Assertion Down");
            this.putValue("ShortDescription", "Moves selected asertion down one row");
            this.putValue("SmallIcon", UISupport.createImageIcon("/down_arrow.gif"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int ix = AssertionsPanel.this.assertionList.getSelectedIndex();
            TestAssertion assertion = AssertionsPanel.this.assertionListModel.getAssertionAt(ix);
            if (ix != -1) {
                assertion = AssertionsPanel.this.assertable.moveAssertion(ix, 1);
            }
            AssertionsPanel.this.assertionList.setSelectedValue(assertion, true);
        }
    }

    private class MoveAssertionUpAction
    extends AbstractAction {
        public MoveAssertionUpAction() {
            super("Move Assertion Up");
            this.putValue("ShortDescription", "Moves selected asertion up one row");
            this.putValue("SmallIcon", UISupport.createImageIcon("/up_arrow.gif"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int ix = AssertionsPanel.this.assertionList.getSelectedIndex();
            TestAssertion assertion = AssertionsPanel.this.assertionListModel.getAssertionAt(ix);
            if (ix != -1) {
                assertion = AssertionsPanel.this.assertable.moveAssertion(ix, -1);
            }
            AssertionsPanel.this.assertionList.setSelectedValue(assertion, true);
        }
    }

    public class RemoveAssertionAction
    extends AbstractAction {
        public RemoveAssertionAction() {
            super("Remove Assertion");
            this.putValue("ShortDescription", "Removes the selected assertion");
            this.putValue("SmallIcon", UISupport.createImageIcon("/remove_assertion.gif"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayList<TestAssertion> removeAssertionList = new ArrayList<TestAssertion>();
            int[] indices = AssertionsPanel.this.assertionList.getSelectedIndices();
            if (indices.length == 0) {
                return;
            }
            if (this.hasRunningTestCase(indices[0])) {
                return;
            }
            for (int i : indices) {
                removeAssertionList.add(AssertionsPanel.this.assertionListModel.getAssertionAt(i));
            }
            if (removeAssertionList.size() == 1) {
                int selectedIndex = AssertionsPanel.this.assertionList.getSelectedIndex();
                this.removeSingleAssertion((TestAssertion)removeAssertionList.get(0));
                if (AssertionsPanel.this.assertionList.getLastVisibleIndex() >= selectedIndex) {
                    AssertionsPanel.this.assertionList.setSelectedIndex(selectedIndex);
                }
            } else {
                this.removeMultipleAssertions(removeAssertionList);
            }
        }

        private boolean hasRunningTestCase(int assertionIndex) {
            if (AssertionsPanel.this.assertionListModel.getAssertionAt(assertionIndex).getParent().getParent() instanceof TestCase && SoapUI.getTestMonitor().hasRunningTestCase((TestCase)AssertionsPanel.this.assertionListModel.getAssertionAt(assertionIndex).getParent().getParent())) {
                UISupport.showInfoMessage("Can not remove assertion(s) while test case is running");
                return true;
            }
            if (AssertionsPanel.this.assertionListModel.getAssertionAt(assertionIndex).getParent().getParent().getParent() instanceof TestCase && SoapUI.getTestMonitor().hasRunningSecurityTest((TestCase)AssertionsPanel.this.assertionListModel.getAssertionAt(assertionIndex).getParent().getParent().getParent())) {
                UISupport.showInfoMessage("Can not remove assertion(s) while test case is running");
                return true;
            }
            return false;
        }

        private void removeMultipleAssertions(List<TestAssertion> removeAssertionList) {
            if (UISupport.confirm("Remove all selected assertions?", "Remove Multiple Assertions")) {
                HashSet<TestAssertion> assertions = new HashSet<TestAssertion>();
                for (ModelItem modelItem : removeAssertionList) {
                    assertions.add((TestAssertion)modelItem);
                }
                for (TestAssertion testAssertion : assertions) {
                    ((Assertable)((Object)testAssertion.getParent())).removeAssertion(testAssertion);
                }
            }
        }

        private void removeSingleAssertion(TestAssertion assertion) {
            if (UISupport.confirm("Remove assertion [" + assertion.getName() + "]", "Remove Assertion")) {
                AssertionsPanel.this.assertable.removeAssertion(assertion);
            }
        }
    }

    public class ConfigureAssertionAction
    extends AbstractAction {
        ConfigureAssertionAction() {
            super("Configure");
            this.putValue("ShortDescription", "Configures the selection assertion");
            this.putValue("SmallIcon", UISupport.createImageIcon("/options.gif"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int ix = AssertionsPanel.this.assertionList.getSelectedIndex();
            if (ix == -1) {
                return;
            }
            TestAssertion assertion = AssertionsPanel.this.assertionListModel.getAssertionAt(ix);
            if (assertion.isConfigurable()) {
                assertion.configure();
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    protected class AssertionListModel
    extends AbstractListModel
    implements PropertyChangeListener,
    AssertionsListener {
        protected List<Object> items = new ArrayList<Object>();

        public AssertionListModel() {
            this.init();
        }

        @Override
        public int getSize() {
            return this.items.size();
        }

        @Override
        public Object getElementAt(int index) {
            return index >= this.items.size() ? null : this.items.get(index);
        }

        public TestAssertion getAssertionAt(int index) {
            Object object = this.items.get(index);
            while (!(object instanceof TestAssertion) && index > 0) {
                object = this.items.get(--index);
            }
            return (TestAssertion)(object instanceof TestAssertion ? object : null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refresh() {
            AssertionListModel assertionListModel = this;
            synchronized (assertionListModel) {
                this.release();
                this.init();
                this.fireContentsChanged(this, 0, this.getSize() - 1);
            }
        }

        private void init() {
            AssertionsPanel.this.assertable.addAssertionsListener(this);
            for (int c = 0; c < AssertionsPanel.this.assertable.getAssertionCount(); ++c) {
                TestAssertion assertion = AssertionsPanel.this.assertable.getAssertionAt(c);
                this.addAssertion(assertion);
            }
        }

        public void release() {
            this.items.clear();
            for (int c = 0; c < AssertionsPanel.this.assertable.getAssertionCount(); ++c) {
                TestAssertion assertion = AssertionsPanel.this.assertable.getAssertionAt(c);
                assertion.removePropertyChangeListener(this);
            }
            AssertionsPanel.this.assertable.removeAssertionsListener(this);
        }

        @Override
        public synchronized void propertyChange(PropertyChangeEvent evt) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.refresh();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AssertionListModel.this.refresh();
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void assertionAdded(TestAssertion assertion) {
            AssertionListModel assertionListModel = this;
            synchronized (assertionListModel) {
                int sz = this.getSize();
                this.addAssertion(assertion);
                this.fireIntervalAdded(this, sz, this.items.size() - 1);
            }
        }

        protected void addAssertion(TestAssertion assertion) {
            assertion.addPropertyChangeListener(this);
            this.items.add(assertion);
            AssertionError[] errors = assertion.getErrors();
            if (errors != null) {
                for (int i = 0; i < errors.length; ++i) {
                    this.items.add(errors[i]);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void assertionRemoved(TestAssertion assertion) {
            AssertionListModel assertionListModel = this;
            synchronized (assertionListModel) {
                int ix = this.items.indexOf(assertion);
                if (ix == -1) {
                    return;
                }
                assertion.removePropertyChangeListener(this);
                this.items.remove(ix);
                this.fireIntervalRemoved(this, ix, ix);
                while (ix < this.items.size() && this.items.get(ix) instanceof AssertionError) {
                    this.items.remove(ix);
                    this.fireIntervalRemoved(this, ix, ix);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void assertionMoved(TestAssertion newAssertion, int ix, int offset) {
            AssertionListModel assertionListModel = this;
            synchronized (assertionListModel) {
                TestAssertion assertion = (TestAssertion)this.items.get(ix);
                if (ix == 0 && offset == -1 || ix == this.items.size() - 1 && offset == 1) {
                    return;
                }
                assertion.removePropertyChangeListener(this);
                this.items.remove(ix);
                this.fireIntervalRemoved(this, ix, ix);
                while (ix < this.items.size() && this.items.get(ix) instanceof AssertionError) {
                    this.items.remove(ix);
                    this.fireIntervalRemoved(this, ix, ix);
                }
                newAssertion.addPropertyChangeListener(this);
                this.items.add(ix + offset, newAssertion);
                this.fireIntervalAdded(this, ix + offset, ix + offset);
                while (ix < this.items.size() && this.items.get(ix) instanceof AssertionError) {
                    this.items.add(newAssertion);
                    this.fireIntervalAdded(this, ix + offset, ix + offset);
                }
            }
        }
    }

    private static class AssertionCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private AssertionCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setEnabled(list.isEnabled());
            if (value instanceof TestAssertion) {
                TestAssertion assertion = (TestAssertion)value;
                this.setText(assertion.getLabel() + " - " + assertion.getStatus().toString());
                this.setIcon(assertion.getIcon());
                if (assertion.isDisabled() && this.isEnabled()) {
                    this.setEnabled(false);
                }
            } else if (value instanceof AssertionError) {
                AssertionError assertion = (AssertionError)value;
                this.setText(" -> " + assertion.toString());
                this.setIcon(null);
            } else if (value instanceof String) {
                this.setText(value.toString());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }
}

