/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.testcase.actions;

import com.eviware.soapui.impl.support.http.HttpRequestTestStep;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.TestRequest;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import javax.swing.AbstractAction;

public class SetEndpointAction
extends AbstractAction {
    private static final String USE_CURRENT = "- use current -";
    private final WsdlTestCase testCase;

    public SetEndpointAction(WsdlTestCase testCase) {
        this.testCase = testCase;
        this.putValue("SmallIcon", UISupport.createImageIcon("/set_endpoint.gif"));
        this.putValue("ShortDescription", "Sets the endpoint for all requests in this testcase");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        HashSet<String> endpointSet = new HashSet<String>();
        HashSet<String> currentEndpointSet = new HashSet<String>();
        endpointSet.add(USE_CURRENT);
        for (int c = 0; c < this.testCase.getTestStepCount(); ++c) {
            WsdlTestStep step = this.testCase.getTestStepAt(c);
            if (!(step instanceof HttpRequestTestStep)) continue;
            HttpRequestTestStep requestStep = (HttpRequestTestStep)((Object)step);
            Operation operation = requestStep.getTestRequest().getOperation();
            if (operation != null) {
                String[] endpoints = operation.getInterface().getEndpoints();
                for (int i = 0; i < endpoints.length; ++i) {
                    endpointSet.add(endpoints[i]);
                }
            }
            currentEndpointSet.add(requestStep.getTestRequest().getEndpoint());
        }
        String selected = (String)UISupport.prompt("Select endpoint to set for all requests", "Set Endpoint", endpointSet.toArray(), currentEndpointSet.size() == 1 ? (String)currentEndpointSet.iterator().next() : USE_CURRENT);
        if (selected == null || selected.equals(USE_CURRENT)) {
            return;
        }
        int cnt = 0;
        for (int c = 0; c < this.testCase.getTestStepCount(); ++c) {
            HttpRequestTestStep requestStep;
            TestRequest testRequest;
            WsdlTestStep step = this.testCase.getTestStepAt(c);
            if (!(step instanceof HttpRequestTestStep) || (testRequest = (requestStep = (HttpRequestTestStep)((Object)step)).getTestRequest()).getEndpoint() != null && testRequest.getEndpoint().equals(selected)) continue;
            testRequest.setEndpoint(selected);
            ++cnt;
        }
        UISupport.showInfoMessage("Changed endpoint to [" + selected + "] for " + cnt + " requests");
    }
}

