/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.mockoperation;

import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockOperation;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.support.InterfaceListenerAdapter;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.model.support.ProjectListenerAdapter;
import com.eviware.soapui.model.util.ModelItemNames;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.SwingActionDelegate;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.swing.ExtendedComboBoxModel;
import com.eviware.soapui.ui.support.AbstractMockOperationDesktopPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;

public class WsdlMockOperationDesktopPanel
extends AbstractMockOperationDesktopPanel<WsdlMockOperation> {
    private WsdlInterface currentInterface;
    private InternalInterfaceListener interfaceListener = new InternalInterfaceListener();
    private JComboBox interfaceCombo;
    private JComboBox operationCombo;
    private InternalProjectListener projectListener = new InternalProjectListener();

    public WsdlMockOperationDesktopPanel(WsdlMockOperation mockOperation) {
        super(mockOperation);
        WsdlOperation operation = ((WsdlMockOperation)this.getModelItem()).getOperation();
        if (operation != null) {
            this.currentInterface = operation.getInterface();
            this.currentInterface.addInterfaceListener(this.interfaceListener);
        }
        mockOperation.getMockService().getProject().addProjectListener(this.projectListener);
    }

    @Override
    protected String getAddToMockOperationIconPath() {
        return "/addToMockService.gif";
    }

    @Override
    protected Component buildToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        toolbar.addSpace(3);
        toolbar.addFixed(UISupport.createToolbarButton(SwingActionDelegate.createDelegate("NewMockResponseAction", this.getModelItem(), null, "/addToMockService.gif")));
        toolbar.addFixed(UISupport.createToolbarButton(SwingActionDelegate.createDelegate("OpenRequestForMockOperationAction", this.getModelItem(), null, "/open_request.gif")));
        toolbar.addUnrelatedGap();
        ModelItemNames<WsdlInterface> names = new ModelItemNames<WsdlInterface>(ModelSupport.getChildren(((WsdlMockOperation)this.getModelItem()).getMockService().getProject(), WsdlInterface.class));
        this.interfaceCombo = new JComboBox<String>(names.getNames());
        this.interfaceCombo.setSelectedIndex(-1);
        this.interfaceCombo.addItemListener(new InterfaceComboListener());
        toolbar.addLabeledFixed("Interface", this.interfaceCombo);
        toolbar.addUnrelatedGap();
        this.operationCombo = new JComboBox(new ExtendedComboBoxModel());
        this.operationCombo.setPreferredSize(new Dimension(150, 20));
        this.operationCombo.addItemListener(new OperationComboListener());
        toolbar.addLabeledFixed("Operation", this.operationCombo);
        WsdlOperation operation = ((WsdlMockOperation)this.getModelItem()).getOperation();
        this.interfaceCombo.setSelectedItem(operation == null ? null : operation.getInterface().getName());
        this.operationCombo.setSelectedItem(operation == null ? null : operation.getName());
        toolbar.addGlue();
        toolbar.addFixed(WsdlMockOperationDesktopPanel.createActionButton(new ShowOnlineHelpAction("http://www.soapui.org/Service-Mocking/simulating-complex-behaviour.html"), true));
        return toolbar;
    }

    @Override
    public boolean onClose(boolean canCancel) {
        super.onClose(canCancel);
        if (this.currentInterface != null) {
            this.currentInterface.removeInterfaceListener(this.interfaceListener);
        }
        ((WsdlMockOperation)this.getModelItem()).getMockService().getProject().removeProjectListener(this.projectListener);
        return this.release();
    }

    private final class InternalProjectListener
    extends ProjectListenerAdapter {
        private InternalProjectListener() {
        }

        @Override
        public void interfaceAdded(Interface iface) {
            WsdlMockOperationDesktopPanel.this.interfaceCombo.addItem(iface.getName());
        }

        @Override
        public void interfaceRemoved(Interface iface) {
            if (WsdlMockOperationDesktopPanel.this.interfaceCombo.getSelectedItem().equals(iface.getName())) {
                ((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).setOperation(null);
            }
        }
    }

    private final class OperationComboListener
    implements ItemListener {
        private OperationComboListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            WsdlInterface iface = (WsdlInterface)((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).getMockService().getProject().getInterfaceByName(WsdlMockOperationDesktopPanel.this.interfaceCombo.getSelectedItem().toString());
            WsdlOperation operation = iface.getOperationByName(WsdlMockOperationDesktopPanel.this.operationCombo.getSelectedItem().toString());
            ((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).setOperation(operation);
        }
    }

    private final class InterfaceComboListener
    implements ItemListener {
        private InterfaceComboListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object selectedItem;
            if (WsdlMockOperationDesktopPanel.this.currentInterface != null) {
                WsdlMockOperationDesktopPanel.this.currentInterface.removeInterfaceListener(WsdlMockOperationDesktopPanel.this.interfaceListener);
            }
            if ((selectedItem = WsdlMockOperationDesktopPanel.this.interfaceCombo.getSelectedItem()) == null) {
                WsdlMockOperationDesktopPanel.this.operationCombo.setModel(new ExtendedComboBoxModel());
                WsdlMockOperationDesktopPanel.this.currentInterface = null;
            } else {
                WsdlMockOperationDesktopPanel.this.currentInterface = (WsdlInterface)((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).getMockService().getProject().getInterfaceByName(selectedItem.toString());
                ModelItemNames<Operation> names = new ModelItemNames<Operation>(WsdlMockOperationDesktopPanel.this.currentInterface.getOperationList());
                WsdlMockOperationDesktopPanel.this.operationCombo.setModel(new ExtendedComboBoxModel(names.getNames()));
                WsdlMockOperationDesktopPanel.this.currentInterface.addInterfaceListener(WsdlMockOperationDesktopPanel.this.interfaceListener);
            }
        }
    }

    private final class InternalInterfaceListener
    extends InterfaceListenerAdapter {
        private InternalInterfaceListener() {
        }

        @Override
        public void operationAdded(Operation operation) {
            WsdlMockOperationDesktopPanel.this.operationCombo.addItem(operation.getName());
        }

        @Override
        public void operationRemoved(Operation operation) {
            Object selectedItem = WsdlMockOperationDesktopPanel.this.operationCombo.getSelectedItem();
            WsdlMockOperationDesktopPanel.this.operationCombo.removeItem(operation.getName());
            if (selectedItem.equals(operation.getName())) {
                ((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).setOperation(null);
                WsdlMockOperationDesktopPanel.this.interfaceCombo.setSelectedIndex(-1);
            }
        }

        @Override
        public void operationUpdated(Operation operation) {
            ExtendedComboBoxModel model = (ExtendedComboBoxModel)WsdlMockOperationDesktopPanel.this.operationCombo.getModel();
            int ix = model.getIndexOf(operation.getName());
            if (ix != -1) {
                model.setElementAt(operation.getName(), ix);
            }
        }
    }
}

