/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.loadtest;

import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTest;
import com.eviware.soapui.impl.wsdl.loadtest.data.actions.ExportStatisticsHistoryAction;
import com.eviware.soapui.impl.wsdl.panels.loadtest.JStatisticsGraph;
import com.eviware.soapui.model.support.TestSuiteListenerAdapter;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.ui.support.DefaultDesktopPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class StatisticsDesktopPanel
extends DefaultDesktopPanel {
    private JPanel panel;
    private final WsdlLoadTest loadTest;
    private JStatisticsGraph statisticsGraph;
    private JButton exportButton;
    private SelectStepComboBoxModel selectStepComboBoxModel;
    private InternalPropertyChangeListener propertyChangeListener = new InternalPropertyChangeListener();
    private JComboBox resolutionCombo;

    public StatisticsDesktopPanel(WsdlLoadTest loadTest) {
        super("Statistics for [" + loadTest.getName() + "]", null, null);
        this.loadTest = loadTest;
        loadTest.addPropertyChangeListener(this.propertyChangeListener);
        this.buildUI();
    }

    private void buildUI() {
        this.statisticsGraph = new JStatisticsGraph(this.loadTest);
        JScrollPane scrollPane = new JScrollPane(this.statisticsGraph);
        scrollPane.getViewport().setBackground(Color.WHITE);
        scrollPane.setHorizontalScrollBarPolicy(32);
        this.panel = UISupport.buildPanelWithToolbarAndStatusBar(this.buildToolbar(), scrollPane, this.statisticsGraph.getLegend());
        this.panel.setPreferredSize(new Dimension(600, 400));
    }

    private JComponent buildToolbar() {
        this.exportButton = UISupport.createToolbarButton(new ExportStatisticsHistoryAction(this.statisticsGraph));
        JXToolBar toolbar = UISupport.createToolbar();
        toolbar.addSpace(5);
        toolbar.addLabeledFixed("Select Step:", this.buildSelectStepCombo());
        toolbar.addUnrelatedGap();
        toolbar.addLabeledFixed("Resolution:", this.buildResolutionCombo());
        toolbar.addGlue();
        toolbar.addFixed(this.exportButton);
        toolbar.addFixed(UISupport.createToolbarButton(new ShowOnlineHelpAction("http://www.soapui.org/Load-Testing/statistics-diagram.html")));
        return toolbar;
    }

    private JComponent buildResolutionCombo() {
        this.resolutionCombo = new JComboBox<String>(new String[]{"data", "250", "500", "1000"});
        this.resolutionCombo.setEditable(true);
        this.resolutionCombo.setToolTipText("Sets update interval of graph in milliseconds");
        long resolution = this.statisticsGraph.getResolution();
        this.resolutionCombo.setSelectedItem(resolution == 0L ? "data" : String.valueOf(resolution));
        this.resolutionCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    long resolution;
                    String value = StatisticsDesktopPanel.this.resolutionCombo.getSelectedItem().toString();
                    long l = resolution = value.equals("data") ? 0L : Long.parseLong(value);
                    if (resolution != StatisticsDesktopPanel.this.statisticsGraph.getResolution()) {
                        StatisticsDesktopPanel.this.statisticsGraph.setResolution(resolution);
                    }
                }
                catch (Exception ex) {
                    long resolution = StatisticsDesktopPanel.this.statisticsGraph.getResolution();
                    StatisticsDesktopPanel.this.resolutionCombo.setSelectedItem(resolution == 0L ? "data" : String.valueOf(resolution));
                }
            }
        });
        return this.resolutionCombo;
    }

    private JComponent buildSelectStepCombo() {
        this.selectStepComboBoxModel = new SelectStepComboBoxModel();
        JComboBox<Object> selectStepCombo = new JComboBox<Object>(this.selectStepComboBoxModel);
        selectStepCombo.setRenderer(new TestStepCellRenderer());
        return selectStepCombo;
    }

    @Override
    public JComponent getComponent() {
        return this.panel;
    }

    @Override
    public boolean onClose(boolean canCancel) {
        this.selectStepComboBoxModel.release();
        this.loadTest.removePropertyChangeListener(this.propertyChangeListener);
        this.statisticsGraph.release();
        return super.onClose(canCancel);
    }

    private static final class TestStepCellRenderer
    extends DefaultListCellRenderer {
        private TestStepCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof TestStep) {
                label.setText(((TestStep)value).getName());
            }
            return label;
        }
    }

    private class SelectStepComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private TestStep selectedStep;
        private InternalTestSuiteListener testSuiteListener = new InternalTestSuiteListener();

        public SelectStepComboBoxModel() {
            StatisticsDesktopPanel.this.loadTest.getTestCase().getTestSuite().addTestSuiteListener(this.testSuiteListener);
        }

        @Override
        public void setSelectedItem(Object anItem) {
            if (anItem == this.selectedStep) {
                return;
            }
            if (anItem == null || anItem.equals("Total")) {
                this.selectedStep = null;
            }
            if (anItem instanceof TestStep) {
                this.selectedStep = (TestStep)anItem;
            }
            StatisticsDesktopPanel.this.statisticsGraph.setTestStep(this.selectedStep);
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedStep == null ? "Total" : this.selectedStep;
        }

        @Override
        public int getSize() {
            return StatisticsDesktopPanel.this.loadTest.getTestCase().getTestStepCount() + 1;
        }

        @Override
        public Object getElementAt(int index) {
            return index == this.getSize() - 1 ? "Total" : StatisticsDesktopPanel.this.loadTest.getTestCase().getTestStepAt(index);
        }

        public void release() {
            StatisticsDesktopPanel.this.loadTest.getTestCase().getTestSuite().removeTestSuiteListener(this.testSuiteListener);
        }

        private final class InternalTestSuiteListener
        extends TestSuiteListenerAdapter {
            private InternalTestSuiteListener() {
            }

            @Override
            public void testStepAdded(TestStep testStep, int index) {
                if (testStep.getTestCase() == StatisticsDesktopPanel.this.loadTest.getTestCase()) {
                    SelectStepComboBoxModel.this.fireIntervalAdded(SelectStepComboBoxModel.this, index, index);
                }
            }

            @Override
            public void testStepRemoved(TestStep testStep, int index) {
                if (testStep.getTestCase() == StatisticsDesktopPanel.this.loadTest.getTestCase()) {
                    if (SelectStepComboBoxModel.this.selectedStep == testStep) {
                        SelectStepComboBoxModel.this.setSelectedItem(null);
                        SelectStepComboBoxModel.this.fireContentsChanged(SelectStepComboBoxModel.this, -1, -1);
                    }
                    SelectStepComboBoxModel.this.fireIntervalRemoved(SelectStepComboBoxModel.this, index, index);
                }
            }
        }
    }

    private final class InternalPropertyChangeListener
    implements PropertyChangeListener {
        private InternalPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(WsdlLoadTest.NAME_PROPERTY)) {
                StatisticsDesktopPanel.this.setTitle("Statistics for [" + StatisticsDesktopPanel.this.loadTest.getName() + "]");
            }
        }
    }
}

