/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.mock.dispatch;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.analytics.Analytics;
import com.eviware.soapui.analytics.SoapUIActions;
import com.eviware.soapui.impl.support.AbstractMockOperation;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.mock.DispatchException;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRunContext;
import com.eviware.soapui.impl.wsdl.mock.dispatch.AbstractMockOperationDispatcher;
import com.eviware.soapui.impl.wsdl.mock.dispatch.MockOperationDispatchFactory;
import com.eviware.soapui.impl.wsdl.mock.dispatch.MockOperationDispatcher;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.GroovyEditor;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.GroovyEditorModel;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.mock.MockOperation;
import com.eviware.soapui.model.mock.MockRequest;
import com.eviware.soapui.model.mock.MockResponse;
import com.eviware.soapui.model.mock.MockResult;
import com.eviware.soapui.model.mock.MockRunContext;
import com.eviware.soapui.model.mock.MockRunner;
import com.eviware.soapui.model.mock.MockService;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.scripting.ScriptEnginePool;
import com.eviware.soapui.support.scripting.SoapUIScriptEngine;
import com.eviware.soapui.ui.support.ModelItemDesktopPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ScriptMockOperationDispatcher
extends AbstractMockOperationDispatcher
implements PropertyChangeListener {
    private ScriptEnginePool scriptEnginePool;
    private GroovyEditor groovyEditor;
    private JPanel groovyEditorPanel;

    public ScriptMockOperationDispatcher(MockOperation mockOperation) {
        super(mockOperation);
        this.scriptEnginePool = new ScriptEnginePool(mockOperation);
        this.scriptEnginePool.setScript(mockOperation.getScript());
        mockOperation.addPropertyChangeListener(AbstractMockOperation.DISPATCH_PATH_PROPERTY, this);
    }

    @Override
    public MockResponse selectMockResponse(MockRequest request, MockResult result) throws DispatchException {
        String dispatchScript = this.getMockOperation().getScript();
        if (StringUtils.hasContent(dispatchScript)) {
            SoapUIScriptEngine scriptEngine = this.scriptEnginePool.getScriptEngine();
            try {
                MockService mockService = this.getMockOperation().getMockService();
                MockRunner mockRunner = mockService.getMockRunner();
                MockRunContext context = mockRunner == null ? new WsdlMockRunContext(mockService, null) : mockRunner.getMockContext();
                scriptEngine.setVariable("context", context);
                scriptEngine.setVariable("requestContext", request == null ? null : request.getRequestContext());
                scriptEngine.setVariable("mockRequest", request);
                scriptEngine.setVariable("mockOperation", this.getMockOperation());
                scriptEngine.setVariable("log", SoapUI.ensureGroovyLog());
                scriptEngine.setScript(dispatchScript);
                Object retVal = scriptEngine.run();
                MockResponse mockResponse = this.getMockOperation().getMockResponseByName(String.valueOf(retVal));
                return mockResponse;
            }
            catch (Throwable e) {
                SoapUI.logError(e);
                throw new DispatchException("Failed to dispatch using script; " + e);
            }
            finally {
                this.scriptEnginePool.returnScriptEngine(scriptEngine);
            }
        }
        return null;
    }

    @Override
    public void release() {
        this.scriptEnginePool.release();
        this.releaseEditorComponent();
        this.getMockOperation().removePropertyChangeListener(AbstractMockOperation.DISPATCH_PATH_PROPERTY, this);
        super.release();
    }

    @Override
    public JComponent getEditorComponent() {
        if (this.groovyEditorPanel == null) {
            this.groovyEditorPanel = new JPanel(new BorderLayout());
            DispatchScriptGroovyEditorModel editorModel = new DispatchScriptGroovyEditorModel();
            this.groovyEditor = (GroovyEditor)UISupport.getEditorFactory().buildGroovyEditor(editorModel);
            this.groovyEditorPanel.add((Component)this.groovyEditor, "Center");
            this.groovyEditorPanel.add((Component)this.buildGroovyEditorToolbar(editorModel), "First");
        }
        return this.groovyEditorPanel;
    }

    @Override
    public void releaseEditorComponent() {
        if (this.groovyEditor != null) {
            this.groovyEditor.release();
        }
        this.groovyEditor = null;
        this.groovyEditorPanel = null;
        super.releaseEditorComponent();
    }

    @Override
    public boolean hasDefaultResponse() {
        return true;
    }

    protected JXToolBar buildGroovyEditorToolbar(DispatchScriptGroovyEditorModel editorModel) {
        JXToolBar toolbar = UISupport.createToolbar();
        toolbar.addSpace(3);
        toolbar.addFixed(UISupport.createToolbarButton(editorModel.getRunAction()));
        toolbar.addGlue();
        JLabel label = new JLabel("<html>Script is invoked with <code>log</code>, <code>context</code>, <code>requestContext</code>, <code>mockRequest</code> and <code>mockOperation</code> variables</html>");
        label.setToolTipText(label.getText());
        label.setMaximumSize(label.getPreferredSize());
        toolbar.add(label);
        toolbar.addFixed(ModelItemDesktopPanel.createActionButton(new ShowOnlineHelpAction(this.getMockOperation().getScriptHelpUrl()), true));
        return toolbar;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.scriptEnginePool.setScript(String.valueOf(evt.getNewValue()));
    }

    private class RunScriptAction
    extends AbstractAction {
        public RunScriptAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/run_groovy_script.gif"));
            this.putValue("ShortDescription", "Runs this script using a mockRequest and context");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Analytics.trackAction((String)SoapUIActions.RUN_TEST_STEP.getActionName(), (String[])new String[]{"StepType", "GroovyScript"});
            MockResult lastMockResult = ScriptMockOperationDispatcher.this.getMockOperation().getLastMockResult();
            MockRequest mockRequest = lastMockResult == null ? null : lastMockResult.getMockRequest();
            try {
                MockResponse retVal = ScriptMockOperationDispatcher.this.selectMockResponse(mockRequest, null);
                UISupport.showInfoMessage("Script returned [" + (retVal == null ? "null" : retVal.getName()) + "]");
            }
            catch (Exception e1) {
                UISupport.showErrorMessage(e1);
            }
        }
    }

    public class DispatchScriptGroovyEditorModel
    implements GroovyEditorModel {
        private RunScriptAction runScriptAction;

        public DispatchScriptGroovyEditorModel() {
            this.runScriptAction = new RunScriptAction();
        }

        @Override
        public String[] getKeywords() {
            return new String[]{"mockRequest", "context", "requestContext", "log", "mockOperation"};
        }

        @Override
        public Action getRunAction() {
            return this.runScriptAction;
        }

        @Override
        public String getScript() {
            return ScriptMockOperationDispatcher.this.getMockOperation().getScript();
        }

        @Override
        public Settings getSettings() {
            return ScriptMockOperationDispatcher.this.getMockOperation().getSettings();
        }

        @Override
        public void setScript(String text) {
            ScriptMockOperationDispatcher.this.getMockOperation().setScript(text);
        }

        @Override
        public String getScriptName() {
            return "Dispatch";
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public ModelItem getModelItem() {
            return ScriptMockOperationDispatcher.this.getMockOperation();
        }
    }

    public static class Factory
    implements MockOperationDispatchFactory {
        @Override
        public MockOperationDispatcher build(MockOperation mockOperation) {
            return new ScriptMockOperationDispatcher(mockOperation);
        }
    }
}

