/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.loadtest.assertions;

import com.eviware.soapui.config.LoadTestAssertionConfig;
import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTest;
import com.eviware.soapui.impl.wsdl.loadtest.assertions.AbstractLoadTestAssertion;
import com.eviware.soapui.impl.wsdl.loadtest.data.LoadTestStatistics;
import com.eviware.soapui.impl.wsdl.support.Configurable;
import com.eviware.soapui.model.testsuite.LoadTestRunContext;
import com.eviware.soapui.model.testsuite.LoadTestRunner;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormDialogBuilder;
import com.eviware.x.form.XFormFactory;
import java.util.Arrays;
import org.apache.xmlbeans.XmlObject;

public class TestStepStatusAssertion
extends AbstractLoadTestAssertion
implements Configurable {
    private static final String NAME_FIELD = "Name";
    private static final String NAME_ELEMENT = "name";
    private static final String MINIMUM_REQUESTS_FIELD = "Minimum Requests";
    private static final String MIN_REQUESTS_ELEMENT = "min-requests";
    private static final String MAX_ERRORS_ELEMENT = "max-errors";
    private static final String MAX_ERRORS_FIELD = "Max Errors";
    private int minRequests;
    private int maxErrors;
    private XFormDialog dialog;
    public static final String STEP_STATUS_TYPE = "Step Status";

    public TestStepStatusAssertion(LoadTestAssertionConfig assertionConfig, WsdlLoadTest loadTest) {
        super(assertionConfig, loadTest);
        this.init(assertionConfig);
        this.initIcon("/status_loadtest_assertion.gif");
    }

    private void init(LoadTestAssertionConfig assertionConfig) {
        XmlObject configuration = assertionConfig.getConfiguration();
        XmlObjectConfigurationReader reader = new XmlObjectConfigurationReader(configuration);
        this.setName(reader.readString(NAME_ELEMENT, STEP_STATUS_TYPE));
        this.minRequests = reader.readInt(MIN_REQUESTS_ELEMENT, 0);
        this.setTargetStep(reader.readString("test-step", "- Any -"));
        this.maxErrors = reader.readInt(MAX_ERRORS_ELEMENT, -1);
    }

    @Override
    public String getDescription() {
        return "testStep: " + this.getTargetStep() + ", minRequests: " + this.minRequests + ", maxErrors: " + this.maxErrors;
    }

    @Override
    public String assertResult(LoadTestRunner loadTestRunner, LoadTestRunContext context, TestStepResult result, TestCaseRunner testRunner, TestCaseRunContext runContext) {
        WsdlLoadTest loadTest = (WsdlLoadTest)loadTestRunner.getLoadTest();
        LoadTestStatistics statisticsModel = loadTest.getStatisticsModel();
        TestStep step = result.getTestStep();
        if (this.targetStepMatches(step)) {
            int index = step.getTestCase().getIndexOfTestStep(step);
            if (statisticsModel.getStatistic(index, LoadTestStatistics.Statistic.COUNT) >= (long)this.minRequests && result.getStatus() == TestStepResult.TestStepStatus.FAILED) {
                return this.returnErrorOrFail("TestStep [" + step.getName() + "] result status is " + result.getStatus().toString() + "; " + Arrays.toString(result.getMessages()), this.maxErrors, loadTestRunner, context);
            }
            return null;
        }
        return null;
    }

    @Override
    public String assertResults(LoadTestRunner loadTestRunner, LoadTestRunContext context, TestCaseRunner testRunner, TestCaseRunContext runContext) {
        return null;
    }

    @Override
    public boolean configure() {
        if (this.dialog == null) {
            this.buildDialog();
        }
        StringToStringMap values = new StringToStringMap();
        values.put(NAME_FIELD, this.getName());
        values.put(MINIMUM_REQUESTS_FIELD, String.valueOf(this.minRequests));
        values.put("TestStep", this.getTargetStep());
        values.put(MAX_ERRORS_FIELD, String.valueOf(this.maxErrors));
        this.dialog.setOptions("TestStep", this.getTargetStepOptions(false));
        values = this.dialog.show(values);
        if (this.dialog.getReturnValue() == 1) {
            try {
                this.minRequests = Integer.parseInt((String)values.get(MINIMUM_REQUESTS_FIELD));
                this.maxErrors = Integer.parseInt((String)values.get(MAX_ERRORS_FIELD));
                this.setName((String)values.get(NAME_FIELD));
                this.setTargetStep((String)values.get("TestStep"));
            }
            catch (Exception e) {
                UISupport.showErrorMessage(e.getMessage());
            }
            this.updateConfiguration();
            return true;
        }
        return false;
    }

    private void buildDialog() {
        XFormDialogBuilder builder = XFormFactory.createDialogBuilder("Step Status Assertion");
        XForm form = builder.createForm("Basic");
        form.addTextField(NAME_FIELD, "Name of this assertion", XForm.FieldType.TEXT);
        form.addTextField(MINIMUM_REQUESTS_FIELD, "Minimum number of runs before asserting", XForm.FieldType.TEXT);
        form.addTextField(MAX_ERRORS_FIELD, "Maximum number of errors before failing", XForm.FieldType.TEXT);
        form.addComboBox("TestStep", new String[0], "TestStep to assert");
        this.dialog = builder.buildDialog(builder.buildOkCancelHelpActions("http://www.soapui.org/Load-Testing/step-status-assertion.html"), "Specify options for this Step Status Assertion", UISupport.OPTIONS_ICON);
    }

    @Override
    protected void updateConfiguration() {
        XmlObjectConfigurationBuilder builder = new XmlObjectConfigurationBuilder();
        builder.add(NAME_ELEMENT, this.getName());
        builder.add(MIN_REQUESTS_ELEMENT, this.minRequests);
        builder.add("test-step", this.getTargetStep());
        builder.add(MAX_ERRORS_ELEMENT, this.maxErrors);
        this.setConfiguration(builder.finish());
    }
}

